/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodQuickFix
implements LocalQuickFix {
    protected final PsiClass myTargetClass;
    protected final String mySignature;
    protected final String myBody;

    private CreateMethodQuickFix(PsiClass targetClass, @NonNls String signature, @NonNls String body) {
        this.myTargetClass = targetClass;
        this.mySignature = signature;
        this.myBody = body;
    }

    @NotNull
    public String getName() {
        String signature = PsiFormatUtil.formatMethod((PsiMethod)this.createMethod(this.myTargetClass.getProject()), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)65795, (int)65538, (int)2);
        String string = QuickFixBundle.message("create.method.from.usage.text", signature);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodQuickFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodQuickFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodQuickFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodQuickFix.applyFix must not be null");
        }
        try {
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{this.myTargetClass.getContainingFile().getVirtualFile()}).hasReadonlyFiles()) {
                return;
            }
            PsiMethod method = this.createMethod(project);
            List arguments = ContainerUtil.map2List((Object[])method.getParameterList().getParameters(), (Function)new Function<PsiParameter, Pair<PsiExpression, PsiType>>(){

                public Pair<PsiExpression, PsiType> fun(PsiParameter psiParameter) {
                    return Pair.create(null, (Object)psiParameter.getType());
                }
            });
            method = (PsiMethod)this.myTargetClass.add((PsiElement)method);
            CreateMethodFromUsageFix.doCreate(this.myTargetClass, method, arguments, PsiSubstitutor.EMPTY, ExpectedTypeInfo.EMPTY_ARRAY, (PsiElement)method);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private PsiMethod createMethod(Project project) {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String methodText = this.mySignature + "{" + this.myBody + "}";
        return elementFactory.createMethodFromText(methodText, null);
    }

    @Nullable
    public static CreateMethodQuickFix createFix(@NotNull PsiClass targetClass, @NonNls String signature, @NonNls String body) {
        if (targetClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodQuickFix.createFix must not be null");
        }
        CreateMethodQuickFix fix = new CreateMethodQuickFix(targetClass, signature, body);
        try {
            fix.createMethod(targetClass.getProject());
            return fix;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }
}

