/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateClassOrPackageFix
implements IntentionAction,
LocalQuickFix {
    private final List<PsiDirectory> myWritableDirectoryList;
    private final PsiElement myContext;
    private final String myPresentation;
    @Nullable
    private final ClassKind myClassKind;
    @Nullable
    private final String mySuperClass;
    private final String myRedPart;
    @Nullable
    private final String myTemplateName;

    @Nullable
    public static CreateClassOrPackageFix createFix(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope, @NotNull PsiElement context, @Nullable PsiPackage basePackage, @Nullable ClassKind kind, @Nullable String superClass, @Nullable String templateName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.createFix must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.createFix must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.createFix must not be null");
        }
        List<PsiDirectory> directories = CreateClassOrPackageFix.getWritableDirectoryListDefault(basePackage, scope, context.getManager());
        if (directories.isEmpty()) {
            return null;
        }
        String redPart = basePackage == null ? qualifiedName : qualifiedName.substring(basePackage.getQualifiedName().length() + 1);
        int dot = redPart.indexOf(46);
        boolean fixPath = dot >= 0;
        String firstRedName = fixPath ? redPart.substring(0, dot) : redPart;
        Iterator<PsiDirectory> i = directories.iterator();
        while (i.hasNext()) {
            if (CreateClassOrPackageFix.checkCreateClassOrPackage(kind != null && !fixPath, i.next(), firstRedName)) continue;
            i.remove();
        }
        return directories.isEmpty() ? null : new CreateClassOrPackageFix(directories, context, fixPath ? qualifiedName : redPart, redPart, kind, superClass, templateName);
    }

    @Nullable
    public static CreateClassOrPackageFix createFix(@NotNull String qualifiedName, @NotNull PsiElement context, @Nullable ClassKind kind, String superClass) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.createFix must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.createFix must not be null");
        }
        return CreateClassOrPackageFix.createFix(qualifiedName, context.getResolveScope(), context, null, kind, superClass, null);
    }

    private CreateClassOrPackageFix(List<PsiDirectory> writableDirectoryList, PsiElement context, String presentation, String redPart, @Nullable ClassKind kind, @Nullable String superClass, @Nullable String templateName) {
        this.myRedPart = redPart;
        this.myTemplateName = templateName;
        this.myWritableDirectoryList = writableDirectoryList;
        this.myContext = context;
        this.myClassKind = kind;
        this.mySuperClass = superClass;
        this.myPresentation = presentation;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message(this.myClassKind == ClassKind.INTERFACE ? "create.interface.text" : (this.myClassKind != null ? "create.class.text" : "create.package.text"), this.myPresentation);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.applyFix must not be null");
        }
        final PsiFile file = descriptor.getPsiElement().getContainingFile();
        if (this.isAvailable(project, null, file)) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    CreateClassOrPackageFix.this.invoke(project, null, file);
                }
            }.execute();
        }
    }

    private static boolean checkCreateClassOrPackage(boolean createJavaClass, PsiDirectory directory, String name) {
        try {
            if (createJavaClass) {
                JavaDirectoryService.getInstance().checkCreateClass(directory, name);
            } else {
                directory.checkCreateSubdirectory(name);
            }
            return true;
        }
        catch (IncorrectOperationException ex) {
            return false;
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateClassOrPackageFix.invoke must not be null");
        }
        final PsiDirectory directory = this.chooseDirectory(project, file);
        if (directory == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CreateClassOrPackageFix.this.doCreate(directory);
            }
        });
    }

    @Nullable
    private PsiDirectory chooseDirectory(Project project, PsiFile file) {
        PsiDirectory preferredDirectory = this.myWritableDirectoryList.isEmpty() ? null : this.myWritableDirectoryList.get(0);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null);
        Module moduleForFile = fileIndex.getModuleForFile(virtualFile);
        if (this.myWritableDirectoryList.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            if (moduleForFile != null) {
                for (PsiDirectory directory : this.myWritableDirectoryList) {
                    if (fileIndex.getModuleForFile(directory.getVirtualFile()) != moduleForFile) continue;
                    preferredDirectory = directory;
                    break;
                }
            }
            return DirectoryChooserUtil.chooseDirectory(this.myWritableDirectoryList.toArray(new PsiDirectory[this.myWritableDirectoryList.size()]), preferredDirectory, project, new HashMap<PsiDirectory, String>());
        }
        return preferredDirectory;
    }

    private void doCreate(PsiDirectory baseDirectory) {
        String lastName;
        PsiManager manager = baseDirectory.getManager();
        PsiDirectory directory = baseDirectory;
        StringTokenizer st = new StringTokenizer(this.myRedPart, ".");
        while (true) {
            lastName = st.nextToken();
            if (!st.hasMoreTokens()) break;
            try {
                PsiDirectory subdirectory = directory.findSubdirectory(lastName);
                directory = subdirectory != null ? subdirectory : directory.createSubdirectory(lastName);
            }
            catch (IncorrectOperationException e) {
                CreateFromUsageUtils.scheduleFileOrPackageCreationFailedMessageBox(e, lastName, directory, true);
                return;
            }
        }
        if (this.myClassKind != null) {
            PsiClass createdClass = this.myTemplateName != null ? CreateClassUtil.createClassFromCustomTemplate(directory, null, lastName, this.myTemplateName) : CreateFromUsageUtils.createClass(this.myClassKind == ClassKind.INTERFACE ? CreateClassKind.INTERFACE : CreateClassKind.CLASS, directory, lastName, manager, this.myContext, null, this.mySuperClass);
            if (createdClass != null) {
                createdClass.navigate(true);
            }
        } else {
            try {
                directory.createSubdirectory(lastName);
            }
            catch (IncorrectOperationException e) {
                CreateFromUsageUtils.scheduleFileOrPackageCreationFailedMessageBox(e, lastName, directory, true);
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static List<PsiDirectory> getWritableDirectoryListDefault(@Nullable PsiPackage context, GlobalSearchScope scope, PsiManager psiManager) {
        ArrayList<PsiDirectory> writableDirectoryList = new ArrayList<PsiDirectory>();
        if (context != null) {
            for (PsiDirectory directory : context.getDirectories()) {
                if (!directory.isWritable() || !scope.contains(directory.getVirtualFile())) continue;
                writableDirectoryList.add(directory);
            }
        } else {
            for (VirtualFile root : ProjectRootManager.getInstance((Project)psiManager.getProject()).getContentSourceRoots()) {
                PsiDirectory directory = psiManager.findDirectory(root);
                if (directory == null || !directory.isWritable() || !scope.contains(directory.getVirtualFile())) continue;
                writableDirectoryList.add(directory);
            }
        }
        return writableDirectoryList;
    }
}

