/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

class JavaWithIfExpressionSurrounder
extends JavaExpressionSurrounder {
    JavaWithIfExpressionSurrounder() {
    }

    public boolean isApplicable(PsiExpression expr) {
        PsiType type = expr.getType();
        if (PsiType.BOOLEAN != type) {
            return false;
        }
        PsiElement parent = expr.getParent();
        if (!(parent instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiElement element = parent.getParent();
        return element instanceof PsiCodeBlock || JspPsiUtil.isInJspFile((PsiElement)element) && element instanceof PsiFile;
    }

    public TextRange surroundExpression(Project project, Editor editor, PsiExpression expr) throws IncorrectOperationException {
        PsiManager manager = expr.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        String text = "if(a){\nst;\n}";
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(text, null);
        ifStatement = (PsiIfStatement)codeStyleManager.reformat((PsiElement)ifStatement);
        ifStatement.getCondition().replace((PsiElement)expr);
        PsiExpressionStatement statement = (PsiExpressionStatement)expr.getParent();
        ifStatement = (PsiIfStatement)statement.replace((PsiElement)ifStatement);
        PsiCodeBlock block = ((PsiBlockStatement)ifStatement.getThenBranch()).getCodeBlock();
        block = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(block);
        TextRange range = block.getStatements()[0].getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        return new TextRange(range.getStartOffset(), range.getStartOffset());
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.if.expression.template", (Object[])new Object[0]);
    }
}

