/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class EditorFragmentComponent
extends JPanel {
    private EditorFragmentComponent(EditorEx editor, int startLine, int endLine, boolean showFolding, boolean showGutter) {
        BufferedImage markersImage;
        EditorGutterComponentEx rowHeader;
        Document doc = editor.getDocument();
        int endOffset = endLine < doc.getLineCount() ? doc.getLineEndOffset(endLine) : doc.getTextLength();
        int textWidth = Math.min(editor.getMaxWidthInRange(doc.getLineStartOffset(startLine), endOffset), ScreenUtil.getScreenRectangle((int)1, (int)1).width);
        FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
        boolean isFoldingEnabled = foldingModel.isFoldingEnabled();
        if (!showFolding) {
            foldingModel.setFoldingEnabled(false);
        }
        Point p1 = editor.logicalPositionToXY(new LogicalPosition(startLine, 0));
        Point p2 = editor.logicalPositionToXY(new LogicalPosition(Math.max(endLine, startLine + 1), 0));
        int y1 = p1.y;
        int y2 = p2.y;
        int savedScrollOfset = editor.getScrollingModel().getHorizontalScrollOffset();
        if (savedScrollOfset > 0) {
            editor.stopOptimizedScrolling();
            editor.getScrollingModel().scrollHorizontally(0);
        }
        final BufferedImage textImage = new BufferedImage(textWidth, y2 - y1, 1);
        Graphics textGraphics = ((Image)textImage).getGraphics();
        if (showGutter) {
            rowHeader = editor.getGutterComponentEx();
            markersImage = new BufferedImage(Math.max(1, rowHeader.getWidth()), y2 - y1, 1);
            Graphics markerGraphics = ((Image)markersImage).getGraphics();
            markerGraphics.translate(0, -y1);
            markerGraphics.setClip(0, y1, rowHeader.getWidth(), y2 - y1);
            markerGraphics.setColor(EditorFragmentComponent.getBackgroundColor(editor));
            markerGraphics.fillRect(0, y1, rowHeader.getWidth(), y2 - y1);
            rowHeader.paint(markerGraphics);
        } else {
            rowHeader = null;
            markersImage = null;
        }
        textGraphics.translate(0, -y1);
        textGraphics.setClip(0, y1, textWidth, y2 - y1);
        boolean wasVisible = editor.setCaretVisible(false);
        editor.getContentComponent().paint(textGraphics);
        if (wasVisible) {
            editor.setCaretVisible(true);
        }
        if (!showFolding) {
            foldingModel.setFoldingEnabled(isFoldingEnabled);
        }
        if (savedScrollOfset > 0) {
            editor.stopOptimizedScrolling();
            editor.getScrollingModel().scrollHorizontally(savedScrollOfset);
        }
        JComponent component = new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(textImage.getWidth(null) + (markersImage == null ? 0 : markersImage.getWidth(null)), textImage.getHeight(null));
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                if (markersImage != null) {
                    graphics.drawImage(markersImage, 0, 0, null);
                    graphics.drawImage(textImage, rowHeader.getWidth(), 0, null);
                } else {
                    graphics.drawImage(textImage, 0, 0, null);
                }
            }
        };
        this.setLayout(new BorderLayout());
        this.add(component);
        Color borderColor = editor.getColorsScheme().getColor(EditorColors.SELECTED_FOLDING_TREE_COLOR);
        Border outsideBorder = BorderFactory.createLineBorder(borderColor, 1);
        Border insideBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.setBorder(BorderFactory.createCompoundBorder(outsideBorder, insideBorder));
    }

    @Nullable
    public static LightweightHint showEditorFragmentHintAt(Editor editor, TextRange range, int x, int y, boolean showUpward, boolean showFolding, boolean hideByAnyKey) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        int startLine = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
        int endLine = Math.min(editor.offsetToLogicalPosition((int)range.getEndOffset()).line + 1, editor.getDocument().getLineCount() - 1);
        if (editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)startLine, (int)0)).y >= editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)endLine, (int)0)).y) {
            return null;
        }
        EditorFragmentComponent fragmentComponent = EditorFragmentComponent.createEditorFragmentComponent(editor, startLine, endLine, showFolding, true);
        if (showUpward) {
            y -= fragmentComponent.getPreferredSize().height + 10;
            y = Math.max(0, y);
        }
        Point p = new Point(x, y);
        MyComponentHint hint = new MyComponentHint(fragmentComponent);
        HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)hint, editor, p, (hideByAnyKey ? 2 : 0) | 8, 0, false);
        return hint;
    }

    public static EditorFragmentComponent createEditorFragmentComponent(Editor editor, int startLine, int endLine, boolean showFolding, boolean showGutter) {
        EditorEx editorEx = (EditorEx)editor;
        Color old = editorEx.getBackroundColor();
        Color backColor = EditorFragmentComponent.getBackgroundColor(editor);
        editorEx.setBackgroundColor(backColor);
        EditorFragmentComponent fragmentComponent = new EditorFragmentComponent(editorEx, startLine, endLine, showFolding, showGutter);
        fragmentComponent.setBackground(backColor);
        editorEx.setBackgroundColor(old);
        return fragmentComponent;
    }

    @Nullable
    public static LightweightHint showEditorFragmentHint(Editor editor, TextRange range, boolean showFolding, boolean hideByAnyKey) {
        int x = -2;
        int y = 0;
        JComponent editorComponent = editor.getComponent();
        JRootPane rootPane = editorComponent.getRootPane();
        if (rootPane == null) {
            return null;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        Point point = SwingUtilities.convertPoint(editorComponent, x, y, layeredPane);
        return EditorFragmentComponent.showEditorFragmentHintAt(editor, range, point.x, point.y, true, showFolding, hideByAnyKey);
    }

    public static Color getBackgroundColor(Editor editor) {
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        Color color = colorsScheme.getColor(EditorColors.CARET_ROW_COLOR);
        if (color == null) {
            color = colorsScheme.getDefaultBackground();
        }
        return color;
    }

    private static class MyComponentHint
    extends LightweightHint {
        public MyComponentHint(JComponent component) {
            super(component);
            this.setForceLightweightPopup(true);
        }

        @Override
        public void hide() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyComponentHint.super.hide();
                }
            });
        }
    }
}

