/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeTypeGenericAction
extends PsiElementBaseIntentionAction {
    private String variableName;
    private String newTypeName;

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.make.type.generic.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/MakeTypeGenericAction.getFamilyName must not return null");
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.make.type.generic.text", (Object[])new Object[]{this.variableName, this.newTypeName});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/MakeTypeGenericAction.getText must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/MakeTypeGenericAction.isAvailable must not be null");
        }
        if (element == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return false;
        }
        if (!element.isWritable()) {
            return false;
        }
        return this.findVariable(element) != null;
    }

    private Pair<PsiVariable, PsiType> findVariable(PsiElement element) {
        PsiVariable variable = null;
        if (element instanceof PsiIdentifier) {
            if (element.getParent() instanceof PsiVariable) {
                variable = (PsiVariable)element.getParent();
            }
        } else if (element instanceof PsiJavaToken) {
            PsiJavaToken token = (PsiJavaToken)element;
            if (token.getTokenType() != JavaTokenType.EQ) {
                return null;
            }
            if (token.getParent() instanceof PsiVariable) {
                variable = (PsiVariable)token.getParent();
            }
        }
        if (variable == null) {
            return null;
        }
        this.variableName = variable.getName();
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiType variableType = variable.getType();
        PsiType initializerType = initializer.getType();
        if (!(variableType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType variableClassType = (PsiClassType)variableType;
        if (!variableClassType.isRaw()) {
            return null;
        }
        if (!(initializerType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType initializerClassType = (PsiClassType)initializerType;
        if (initializerClassType.isRaw()) {
            return null;
        }
        PsiClassType.ClassResolveResult variableResolveResult = variableClassType.resolveGenerics();
        PsiClassType.ClassResolveResult initializerResolveResult = initializerClassType.resolveGenerics();
        if (initializerResolveResult.getElement() == null) {
            return null;
        }
        PsiSubstitutor targetSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)variableResolveResult.getElement(), (PsiClass)initializerResolveResult.getElement(), (PsiSubstitutor)initializerResolveResult.getSubstitutor());
        if (targetSubstitutor == null) {
            return null;
        }
        PsiClassType type = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory().createType(variableResolveResult.getElement(), targetSubstitutor);
        this.newTypeName = type.getCanonicalText();
        return Pair.create((Object)variable, (Object)type);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/MakeTypeGenericAction.invoke must not be null");
        }
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        PsiElement element = file.findElementAt(position);
        Pair<PsiVariable, PsiType> pair = this.findVariable(element);
        if (pair == null) {
            return;
        }
        PsiVariable variable = (PsiVariable)pair.getFirst();
        PsiType type = (PsiType)pair.getSecond();
        variable.getTypeElement().replace((PsiElement)JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory().createTypeElement(type));
    }
}

