/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsConfigurable;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="IntentionManagerSettings", storages={@Storage(id="other", file="$APP_CONFIG$/intentionSettings.xml")})
public class IntentionManagerSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings");
    private final Set<String> myIgnoredActions = new LinkedHashSet<String>();
    private final Map<MetaDataKey, IntentionActionMetaData> myMetaData = new LinkedHashMap<MetaDataKey, IntentionActionMetaData>();
    @NonNls
    private static final String IGNORE_ACTION_TAG = "ignoreAction";
    @NonNls
    private static final String NAME_ATT = "name";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");

    public static IntentionManagerSettings getInstance() {
        return (IntentionManagerSettings)ServiceManager.getService(IntentionManagerSettings.class);
    }

    public void registerIntentionMetaData(@NotNull IntentionAction intentionAction, @NotNull String[] category, @NotNull String descriptionDirectoryName) {
        if (intentionAction == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings.registerIntentionMetaData must not be null");
        }
        if (category == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings.registerIntentionMetaData must not be null");
        }
        if (descriptionDirectoryName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings.registerIntentionMetaData must not be null");
        }
        this.registerMetaData(new IntentionActionMetaData(intentionAction, IntentionManagerSettings.getClassLoader(intentionAction), category, descriptionDirectoryName));
    }

    private static ClassLoader getClassLoader(IntentionAction intentionAction) {
        return intentionAction instanceof IntentionActionWrapper ? ((IntentionActionWrapper)intentionAction).getImplementationClassLoader() : intentionAction.getClass().getClassLoader();
    }

    public void registerIntentionMetaData(IntentionAction intentionAction, String[] category, String descriptionDirectoryName, ClassLoader classLoader) {
        this.registerMetaData(new IntentionActionMetaData(intentionAction, classLoader, category, descriptionDirectoryName));
    }

    public synchronized boolean isShowLightBulb(@NotNull IntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings.isShowLightBulb must not be null");
        }
        return !this.myIgnoredActions.contains(action.getFamilyName());
    }

    public void loadState(Element element) {
        this.myIgnoredActions.clear();
        List children = element.getChildren(IGNORE_ACTION_TAG);
        for (Object aChildren : children) {
            Element e = (Element)aChildren;
            this.myIgnoredActions.add(e.getAttributeValue(NAME_ATT));
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (String name : this.myIgnoredActions) {
            element.addContent(new Element(IGNORE_ACTION_TAG).setAttribute(NAME_ATT, name));
        }
        return element;
    }

    @NotNull
    public synchronized List<IntentionActionMetaData> getMetaData() {
        IntentionManager.getInstance();
        ArrayList<IntentionActionMetaData> arrayList = new ArrayList<IntentionActionMetaData>(this.myMetaData.values());
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings.getMetaData must not return null");
        }
        return arrayList;
    }

    public synchronized boolean isEnabled(IntentionActionMetaData metaData) {
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(metaData));
    }

    private static String getFamilyName(IntentionActionMetaData metaData) {
        return StringUtil.join((String[])metaData.myCategory, (String)"/") + "/" + metaData.getFamily();
    }

    private static String getFamilyName(IntentionAction action) {
        return action instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action).getFullFamilyName() : action.getFamilyName();
    }

    public synchronized void setEnabled(IntentionActionMetaData metaData, boolean enabled) {
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(metaData));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(metaData));
        }
    }

    public synchronized boolean isEnabled(IntentionAction action) {
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(action));
    }

    public synchronized void setEnabled(IntentionAction action, boolean enabled) {
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(action));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(action));
        }
    }

    public synchronized void registerMetaData(IntentionActionMetaData metaData) {
        MetaDataKey key = new MetaDataKey(metaData.myCategory, metaData.getFamily());
        if (!this.myMetaData.containsKey(key)) {
            IntentionManagerSettings.processMetaData(metaData);
        }
        this.myMetaData.put(key, metaData);
    }

    private static synchronized void processMetaData(final @NotNull IntentionActionMetaData metaData) {
        if (metaData == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings.processMetaData must not be null");
        }
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        final TextDescriptor description = metaData.getDescription();
        app.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
                    if (registrar == null) {
                        return;
                    }
                    String descriptionText = description.getText().toLowerCase();
                    descriptionText = HTML_PATTERN.matcher(descriptionText).replaceAll(" ");
                    Set words = registrar.getProcessedWordsWithoutStemming(descriptionText);
                    words.addAll(registrar.getProcessedWords(metaData.getFamily()));
                    for (String word : words) {
                        registrar.addOption(word, metaData.getFamily(), metaData.getFamily(), "preferences.intentionPowerPack", IntentionSettingsConfigurable.DISPLAY_NAME);
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public synchronized void unregisterMetaData(IntentionAction intentionAction) {
        for (Map.Entry<MetaDataKey, IntentionActionMetaData> entry : this.myMetaData.entrySet()) {
            if (entry.getValue().getAction() != intentionAction) continue;
            this.myMetaData.remove(entry.getKey());
            break;
        }
    }

    private class MetaDataKey {
        @NotNull
        private final String categoryNames;
        @NotNull
        private final String familyName;

        private MetaDataKey(@NotNull String[] categoryNames, String familyName) {
            if (categoryNames == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey.<init> must not be null");
            }
            if (familyName == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/config/IntentionManagerSettings$MetaDataKey.<init> must not be null");
            }
            this.categoryNames = StringUtil.join((String[])categoryNames, (String)":");
            this.familyName = familyName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaDataKey that = (MetaDataKey)o;
            if (!this.categoryNames.equals(that.categoryNames)) {
                return false;
            }
            return this.familyName.equals(that.familyName);
        }

        public int hashCode() {
            int result = this.categoryNames.hashCode();
            result = 31 * result + this.familyName.hashCode();
            return result;
        }
    }
}

