/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SortedList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupModel
extends AbstractListModel {
    private final List<LookupElement> myModelItems = new ArrayList<LookupElement>();
    private final ArrayList<LookupElement> myItems = new ArrayList();
    @Nullable
    private List<LookupElement> mySortedItems;
    private String myAdditionalPrefix = "";
    private final LookupArranger myArranger;
    private int myPreferredItemsCount;
    private static final int MAX_PREFERRED_COUNT = 5;

    LookupModel(LookupArranger arranger) {
        this.myArranger = arranger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        LookupModel.assertEDT();
        List<LookupElement> list = this.myModelItems;
        synchronized (list) {
            return this.myModelItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupElement getElementAt(int index) {
        LookupModel.assertEDT();
        List<LookupElement> list = this.myModelItems;
        synchronized (list) {
            return this.myModelItems.get(index);
        }
    }

    private static void assertEDT() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(LookupElement item) {
        ArrayList<LookupElement> arrayList = this.myItems;
        synchronized (arrayList) {
            this.myItems.add(item);
            this.mySortedItems = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<LookupElement> getSortedItems() {
        ArrayList<LookupElement> arrayList = this.myItems;
        // MONITORENTER : arrayList
        List<LookupElement> sortedItems = this.mySortedItems;
        if (sortedItems == null) {
            sortedItems = new ArrayList<LookupElement>(this.myItems);
            this.myArranger.sortItems(sortedItems);
            this.mySortedItems = sortedItems;
        }
        List<LookupElement> list = sortedItems;
        // MONITOREXIT : arrayList
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/impl/LookupModel.getSortedItems must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resort() {
        ArrayList<LookupElement> items;
        ArrayList<LookupElement> arrayList = this.myItems;
        synchronized (arrayList) {
            items = new ArrayList<LookupElement>(this.myItems);
            this.myItems.clear();
            this.mySortedItems = null;
        }
        for (LookupElement item : items) {
            this.addItem(item);
        }
    }

    int getPreferredItemsCount() {
        return this.myPreferredItemsCount;
    }

    String getAdditionalPrefix() {
        return this.myAdditionalPrefix;
    }

    void setAdditionalPrefix(String additionalPrefix) {
        this.myAdditionalPrefix = additionalPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<LookupElement> updateList(@Nullable LookupElement preselectedItem) {
        int oldSize;
        LookupModel.assertEDT();
        List<LookupElement> items = this.getSortedItems();
        TreeMap<Comparable, ArrayList<LookupElement>> itemsMap = new TreeMap<Comparable, ArrayList<LookupElement>>();
        for (LookupElement item : items) {
            Comparable relevance = this.myArranger.getRelevance(item);
            ArrayList<LookupElement> list = (ArrayList<LookupElement>)itemsMap.get(relevance);
            if (list == null) {
                list = new ArrayList<LookupElement>();
                itemsMap.put(relevance, list);
            }
            list.add(item);
        }
        ArrayList<LookupElement> list = new ArrayList<LookupElement>();
        THashSet firstItems = new THashSet();
        this.addExactPrefixItems((Set<LookupElement>)firstItems, items, list);
        this.addMostRelevantItems((Set<LookupElement>)firstItems, itemsMap.values(), list);
        LookupModel.addPreselectedItem((Set<LookupElement>)firstItems, preselectedItem, list);
        this.myPreferredItemsCount = firstItems.size();
        this.addRemainingItemsLexicographically((Set<LookupElement>)firstItems, items, list);
        List<LookupElement> list2 = this.myModelItems;
        synchronized (list2) {
            oldSize = this.myModelItems.size() - 1;
            this.myModelItems.clear();
        }
        this.fireIntervalRemoved(this, 0, oldSize);
        if (!list.isEmpty()) {
            list2 = this.myModelItems;
            synchronized (list2) {
                this.myModelItems.addAll(list);
            }
            this.fireIntervalAdded(this, 0, list.size() - 1);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEmptyElement(LookupElement element) {
        LookupModel.assertEDT();
        List<LookupElement> list = this.myModelItems;
        synchronized (list) {
            this.myModelItems.add(element);
        }
        this.fireIntervalAdded(this, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changePrefix(String prefix) {
        LookupModel.assertEDT();
        ArrayList<LookupElement> arrayList = this.myItems;
        synchronized (arrayList) {
            Iterator<LookupElement> iterator = this.myItems.iterator();
            while (iterator.hasNext()) {
                LookupElement item = iterator.next();
                if (item.setPrefixMatcher(item.getPrefixMatcher().cloneWithPrefix(prefix))) continue;
                iterator.remove();
                this.mySortedItems = null;
            }
        }
        this.myAdditionalPrefix = "";
    }

    private boolean addExactPrefixItems(Set<LookupElement> firstItems, List<LookupElement> elements, List<LookupElement> modelItems) {
        SortedList sorted = new SortedList((Comparator)new Comparator<LookupElement>(){

            @Override
            public int compare(LookupElement o1, LookupElement o2) {
                return LookupModel.this.myArranger.getRelevance(o1).compareTo(LookupModel.this.myArranger.getRelevance(o2));
            }
        });
        for (LookupElement item : elements) {
            if (!this.isExactPrefixItem(item)) continue;
            sorted.add(item);
        }
        for (LookupElement item : sorted) {
            modelItems.add(item);
            firstItems.add(item);
        }
        return !firstItems.isEmpty();
    }

    boolean isExactPrefixItem(LookupElement item) {
        return item.getAllLookupStrings().contains(item.getPrefixMatcher().getPrefix() + this.myAdditionalPrefix);
    }

    private void addMostRelevantItems(Set<LookupElement> firstItems, Collection<List<LookupElement>> sortedItems, List<LookupElement> modelItems) {
        for (List<LookupElement> elements : sortedItems) {
            SmartList suitable = new SmartList();
            for (LookupElement item : elements) {
                if (firstItems.contains(item) || !this.prefixMatches(item)) continue;
                suitable.add(item);
            }
            if (firstItems.size() + suitable.size() > 5) break;
            for (LookupElement item : suitable) {
                firstItems.add(item);
                modelItems.add(item);
            }
        }
    }

    private void addRemainingItemsLexicographically(Set<LookupElement> firstItems, List<LookupElement> myItems, List<LookupElement> modelItems) {
        for (LookupElement item : myItems) {
            if (firstItems.contains(item) || !this.prefixMatches(item)) continue;
            modelItems.add(item);
        }
    }

    private static void addPreselectedItem(Set<LookupElement> firstItems, @Nullable LookupElement preselectedItem, List<LookupElement> modelItems) {
        if (preselectedItem != null && !firstItems.contains(preselectedItem)) {
            firstItems.add(preselectedItem);
            modelItems.add(preselectedItem);
        }
    }

    private boolean prefixMatches(LookupElement item) {
        if (this.myAdditionalPrefix.length() == 0) {
            return item.isPrefixMatched();
        }
        return item.getPrefixMatcher().cloneWithPrefix(item.getPrefixMatcher().getPrefix() + this.myAdditionalPrefix).prefixMatches(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LookupElement> getModelItems() {
        List<LookupElement> list = this.myModelItems;
        synchronized (list) {
            return new ArrayList<LookupElement>(this.myModelItems);
        }
    }
}

