/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class GotoImplementationHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.implementation";
    }

    @Override
    public Pair<PsiElement, PsiElement[]> getSourceAndTargetElements(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement source = TargetElementUtilBase.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        PsiElement[] target = new ImplementationSearcher().searchImplementations(editor, source, offset);
        if (target.length == 0) {
            return new Pair((Object)source, (Object)new PsiElement[]{source});
        }
        return new Pair((Object)source, (Object)target);
    }

    @Override
    protected String getChooserInFileTitleKey(PsiElement sourceElement) {
        return "goto.implementation.in.file.chooser.title";
    }

    @Override
    protected String getChooserTitleKey(PsiElement sourceElement) {
        return "goto.implementation.chooser.title";
    }
}

