/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;

public class MethodImplementationsSearch
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(PsiElement sourceElement, Processor<PsiElement> consumer) {
        if (sourceElement instanceof PsiMethod) {
            for (PsiMethod implementation : MethodImplementationsSearch.getMethodImplementations((PsiMethod)sourceElement)) {
                if (consumer.process((Object)implementation)) continue;
                return false;
            }
        }
        return true;
    }

    public static void getOverridingMethods(PsiMethod method, ArrayList<PsiMethod> list) {
        for (PsiMethod psiMethod : OverridingMethodsSearch.search((PsiMethod)method)) {
            list.add(psiMethod);
        }
    }

    public static PsiMethod[] getMethodImplementations(PsiMethod method) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        MethodImplementationsSearch.getOverridingMethods(method, result);
        return result.toArray(new PsiMethod[result.size()]);
    }
}

