/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class JavaUnwrapper
implements Unwrapper {
    private final String myDescription;

    public JavaUnwrapper(String description) {
        this.myDescription = description;
    }

    @Override
    public abstract boolean isApplicableTo(PsiElement var1);

    @Override
    public void collectElementsToIgnore(PsiElement element, Set<PsiElement> result) {
    }

    @Override
    public String getDescription(PsiElement e) {
        return this.myDescription;
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        try {
            Context c = new Context(false);
            this.doUnwrap(e, c);
            toExtract.addAll(c.myElementsToExtract);
            return e;
        }
        catch (IncorrectOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<PsiElement> unwrap(Editor editor, PsiElement element) throws IncorrectOperationException {
        Context c = new Context(true);
        this.doUnwrap(element, c);
        return c.myElementsToExtract;
    }

    protected abstract void doUnwrap(PsiElement var1, Context var2) throws IncorrectOperationException;

    protected boolean isElseBlock(PsiElement e) {
        PsiElement p = e.getParent();
        return p instanceof PsiIfStatement && e == ((PsiIfStatement)p).getElseBranch();
    }

    protected PsiElement findTopmostParentOfType(PsiElement el, Class clazz) {
        PsiElement temp;
        while ((temp = PsiTreeUtil.getParentOfType((PsiElement)el, (Class)clazz, (boolean)true, (Class[])new Class[]{PsiAnonymousClass.class})) != null && !(temp instanceof PsiFile)) {
            el = temp;
        }
        return el;
    }

    protected static class Context {
        private final List<PsiElement> myElementsToExtract = new ArrayList<PsiElement>();
        private final boolean myIsEffective;

        public Context(boolean isEffective) {
            this.myIsEffective = isEffective;
        }

        public void addElementToExtract(PsiElement e) {
            this.myElementsToExtract.add(e);
        }

        public void extractFromBlockOrSingleStatement(PsiStatement block, PsiElement from) throws IncorrectOperationException {
            if (block instanceof PsiBlockStatement) {
                this.extractFromCodeBlock(((PsiBlockStatement)block).getCodeBlock(), from);
            } else if (block != null && !(block instanceof PsiEmptyStatement)) {
                this.extract((PsiElement)block, (PsiElement)block, from);
            }
        }

        public void extractFromCodeBlock(PsiCodeBlock block, PsiElement from) throws IncorrectOperationException {
            if (block == null) {
                return;
            }
            this.extract(block.getFirstBodyElement(), block.getLastBodyElement(), from);
        }

        public void extractElement(PsiElement element, PsiElement from) throws IncorrectOperationException {
            this.extract(element, element, from);
        }

        private void extract(PsiElement first, PsiElement last, PsiElement from) throws IncorrectOperationException {
            if (first == null) {
                return;
            }
            while (first != last && first instanceof PsiWhiteSpace) {
                first = first.getNextSibling();
            }
            while (last != first && last instanceof PsiWhiteSpace) {
                last = last.getPrevSibling();
            }
            if (first == last && last instanceof PsiWhiteSpace) {
                return;
            }
            PsiElement toExtract = first;
            if (this.myIsEffective) {
                toExtract = from.getParent().addRangeBefore(first, last, from);
            }
            do {
                this.addElementToExtract(toExtract);
                toExtract = toExtract.getNextSibling();
            } while ((first = first.getNextSibling()) != null && first.getPrevSibling() != last);
        }

        public void delete(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e.delete();
            }
        }

        public void deleteExactly(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                e.getParent().deleteChildRange(e, e);
            }
        }

        public void setElseBranch(PsiIfStatement ifStatement, PsiStatement elseBranch) throws IncorrectOperationException {
            PsiStatement toExtract = elseBranch;
            if (this.myIsEffective) {
                ifStatement.setElseBranch(this.copyElement(elseBranch));
                toExtract = ifStatement.getElseBranch();
            }
            this.addElementToExtract((PsiElement)toExtract);
        }

        private PsiStatement copyElement(PsiStatement e) throws IncorrectOperationException {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)e.getProject()).getElementFactory();
            return factory.createStatementFromText(e.getText(), null);
        }
    }
}

