/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dependencyViolation;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.ide.DataManager;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.packageDependencies.ui.DependencyConfigurable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyInspection
extends BaseLocalInspectionTool {
    public static final String GROUP_DISPLAY_NAME = "";
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"illegal.package.dependencies", (Object[])new Object[0]);
    @NonNls
    public static final String SHORT_NAME = "Dependency";

    @NotNull
    public String getGroupDisplayName() {
        if (GROUP_DISPLAY_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dependencyViolation/DependencyInspection.getGroupDisplayName must not return null");
        }
        return GROUP_DISPLAY_NAME;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dependencyViolation/DependencyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dependencyViolation/DependencyInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    public JComponent createOptionsPanel() {
        final JButton editDependencies = new JButton(InspectionsBundle.message((String)"inspection.dependency.configure.button.text", (Object[])new Object[0]));
        editDependencies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editDependencies));
                if (project == null) {
                    project = ProjectManager.getInstance().getDefaultProject();
                }
                ShowSettingsUtil.getInstance().editConfigurable((Component)editDependencies, (Configurable)new DependencyConfigurable(project));
            }
        });
        JPanel depPanel = new JPanel(new FlowLayout(1));
        depPanel.add(editDependencies);
        return depPanel;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dependencyViolation/DependencyInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/dependencyViolation/DependencyInspection.checkFile must not be null");
        }
        if (file == null) {
            return null;
        }
        if (file.getViewProvider().getPsi(StdLanguages.JAVA) == null) {
            return null;
        }
        final DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)file.getProject());
        if (!validationManager.hasRules()) {
            return null;
        }
        if (validationManager.getApplicableRules(file).length == 0) {
            return null;
        }
        final ArrayList problems = new ArrayList();
        ForwardDependenciesBuilder builder = new ForwardDependenciesBuilder(file.getProject(), new AnalysisScope(file));
        ForwardDependenciesBuilder.analyzeFileDependencies(file, new DependenciesBuilder.DependencyProcessor(){

            @Override
            public void process(PsiElement place, PsiElement dependency) {
                PsiFile dependencyFile = dependency.getContainingFile();
                if (dependencyFile != null && dependencyFile.isPhysical() && dependencyFile.getVirtualFile() != null) {
                    DependencyRule[] rule;
                    for (DependencyRule dependencyRule : rule = validationManager.getViolatorDependencyRules(file, dependencyFile)) {
                        StringBuffer message = new StringBuffer();
                        message.append(MessageFormat.format(InspectionsBundle.message((String)"inspection.dependency.violator.problem.descriptor", (Object[])new Object[0]), dependencyRule.getDisplayText()));
                        problems.add(manager.createProblemDescriptor(place, message.toString(), isOnTheFly, new LocalQuickFix[]{new EditDependencyRulesAction(dependencyRule)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    }
                }
            }
        });
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dependencyViolation/DependencyInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    private static class EditDependencyRulesAction
    implements LocalQuickFix {
        private final DependencyRule myRule;

        public EditDependencyRulesAction(DependencyRule rule) {
            this.myRule = rule;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"edit.dependency.rules.text", (Object[])new Object[]{this.myRule.getDisplayText()});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dependencyViolation/DependencyInspection$EditDependencyRulesAction.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"edit.dependency.rules.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dependencyViolation/DependencyInspection$EditDependencyRulesAction.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dependencyViolation/DependencyInspection$EditDependencyRulesAction.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/dependencyViolation/DependencyInspection$EditDependencyRulesAction.applyFix must not be null");
            }
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new DependencyConfigurable(project));
        }
    }
}

