/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalQuickFixWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class QuickFixAction
extends AnAction {
    protected InspectionTool myTool;

    public static InspectionResultsView getInvoker(AnActionEvent e) {
        return (InspectionResultsView)InspectionResultsView.DATA_KEY.getData(e.getDataContext());
    }

    protected QuickFixAction(String text, InspectionTool tool) {
        this(text, IconLoader.getIcon((String)"/actions/createFromUsage.png"), null, tool);
    }

    protected QuickFixAction(String text, Icon icon, KeyStroke keyStroke, InspectionTool tool) {
        super(text, null, icon);
        this.myTool = tool;
        if (keyStroke != null) {
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), null);
        }
    }

    public void update(AnActionEvent e) {
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        if (view == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        InspectionTree tree = view.getTree();
        if (!view.isSingleToolInSelection() || tree.getSelectedTool() != this.myTool) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
            return;
        }
        if (!this.isProblemDescriptorsAcceptable() && tree.getSelectedElements().length > 0 || this.isProblemDescriptorsAcceptable() && tree.getSelectedDescriptors().length > 0) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(true);
        }
    }

    protected boolean isProblemDescriptorsAcceptable() {
        return false;
    }

    public String getText(RefEntity where) {
        return this.getTemplatePresentation().getText();
    }

    public void actionPerformed(AnActionEvent e) {
        CommonProblemDescriptor[] descriptors;
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        InspectionTree tree = view.getTree();
        InspectionTool tool = tree.getSelectedTool();
        if (this.isProblemDescriptorsAcceptable() && (descriptors = tree.getSelectedDescriptors()).length > 0) {
            this.doApplyFix(view.getProject(), descriptors);
            return;
        }
        this.doApplyFix(QuickFixAction.getSelectedElements(e), view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(final Project project, final CommonProblemDescriptor[] descriptors) {
        ReadonlyStatusHandler.OperationStatus operationStatus;
        THashSet readOnlyFiles = new THashSet();
        for (CommonProblemDescriptor descriptor : descriptors) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
            if (psiElement == null || psiElement.isWritable()) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        if (!readOnlyFiles.isEmpty() && (operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(VfsUtil.toVirtualFileArray((Collection)readOnlyFiles))).hasReadonlyFiles()) {
            return;
        }
        RefManagerImpl refManager = (RefManagerImpl)this.myTool.getContext().getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            final HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiModificationTracker tracker = PsiManager.getInstance((Project)project).getModificationTracker();
                            for (CommonProblemDescriptor descriptor : descriptors) {
                                QuickFix[] fixes;
                                if (descriptor == null || (fixes = descriptor.getFixes()) == null) continue;
                                for (QuickFix fix : fixes) {
                                    QuickFixAction quickFixAction;
                                    if (fix == null || (quickFixAction = QuickFixAction.this) instanceof LocalQuickFixWrapper && !((LocalQuickFixWrapper)quickFixAction).getFix().getClass().isInstance(fix)) continue;
                                    long startCount = tracker.getModificationCount();
                                    fix.applyFix(project, descriptor);
                                    if (startCount == tracker.getModificationCount()) continue;
                                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                                    ((DescriptorProviderInspection)QuickFixAction.this.myTool).ignoreProblem(descriptor, fix);
                                    if (!(descriptor instanceof ProblemDescriptor)) continue;
                                    ignoredElements.add(((ProblemDescriptor)descriptor).getPsiElement());
                                }
                            }
                        }
                    });
                }
            }, this.getTemplatePresentation().getText(), null);
            QuickFixAction.refreshViews(project, ignoredElements, this.myTool);
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doApplyFix(final RefElement[] refElements, InspectionResultsView view) {
        RefManagerImpl refManager = (RefManagerImpl)this.myTool.getContext().getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            final boolean[] refreshNeeded = new boolean[]{false};
            if (refElements.length > 0) {
                final Project project = refElements[0].getRefManager().getProject();
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                refreshNeeded[0] = QuickFixAction.this.applyFix(refElements);
                            }
                        });
                    }
                }, this.getTemplatePresentation().getText(), null);
            }
            if (refreshNeeded[0]) {
                QuickFixAction.refreshViews(view.getProject(), refElements, this.myTool);
            }
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    public static void removeElements(RefElement[] refElements, Project project, InspectionTool tool) {
        QuickFixAction.refreshViews(project, refElements, tool);
        ArrayList deletedRefs = new ArrayList(1);
        for (RefElement refElement : refElements) {
            refElement.getRefManager().removeRefElement(refElement, deletedRefs);
        }
    }

    private static Set<VirtualFile> getReadOnlyFiles(RefElement[] refElements) {
        THashSet readOnlyFiles = new THashSet();
        for (RefElement refElement : refElements) {
            PsiElement psiElement = refElement.getElement();
            if (psiElement == null || psiElement.getContainingFile() == null) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        return readOnlyFiles;
    }

    private static RefElement[] getSelectedElements(AnActionEvent e) {
        InspectionResultsView invoker = QuickFixAction.getInvoker(e);
        if (invoker == null) {
            return new RefElement[0];
        }
        ArrayList<RefEntity> selection = new ArrayList<RefEntity>(Arrays.asList(invoker.getTree().getSelectedElements()));
        PsiDocumentManager.getInstance((Project)invoker.getProject()).commitAllDocuments();
        Collections.sort(selection, new Comparator<RefEntity>(){

            @Override
            public int compare(RefEntity o1, RefEntity o2) {
                if (o1 instanceof RefElement && o2 instanceof RefElement) {
                    PsiFile containingFile2;
                    RefElement r1 = (RefElement)o1;
                    RefElement r2 = (RefElement)o2;
                    PsiElement element1 = r1.getElement();
                    PsiElement element2 = r2.getElement();
                    PsiFile containingFile1 = element1.getContainingFile();
                    if (containingFile1 == (containingFile2 = element2.getContainingFile())) {
                        int i2;
                        int i1 = element1.getTextOffset();
                        if (i1 < (i2 = element2.getTextOffset())) {
                            return 1;
                        }
                        if (i1 > i2) {
                            return -1;
                        }
                        return 0;
                    }
                    return containingFile1.getName().compareTo(containingFile2.getName());
                }
                if (o1 instanceof RefElement) {
                    return 1;
                }
                if (o2 instanceof RefElement) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return selection.toArray(new RefElement[selection.size()]);
    }

    private static void refreshViews(Project project, Set<PsiElement> selectedElements, InspectionTool tool) {
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        Set<GlobalInspectionContextImpl> runningContexts = managerEx.getRunningContexts();
        for (GlobalInspectionContextImpl context : runningContexts) {
            for (PsiElement element : selectedElements) {
                context.ignoreElement(tool, element);
            }
            context.refreshViews();
        }
    }

    private static void refreshViews(Project project, RefElement[] refElements, InspectionTool tool) {
        HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
        for (RefElement element : refElements) {
            PsiElement psiElement = element.getElement();
            if (psiElement == null || !psiElement.isValid()) continue;
            ignoredElements.add(psiElement);
        }
        QuickFixAction.refreshViews(project, ignoredElements, tool);
    }

    protected boolean applyFix(RefElement[] refElements) {
        Project project;
        ReadonlyStatusHandler.OperationStatus operationStatus;
        Set<VirtualFile> readOnlyFiles = QuickFixAction.getReadOnlyFiles(refElements);
        return readOnlyFiles.isEmpty() || !(operationStatus = ReadonlyStatusHandler.getInstance((Project)(project = refElements[0].getRefManager().getProject())).ensureFilesWritable(VfsUtil.toVirtualFileArray(readOnlyFiles))).hasReadonlyFiles();
    }
}

