/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.export.HTMLExporter;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;

public class HTMLExportFrameMaker {
    private final String myRootFolder;
    private final Project myProject;
    private final ArrayList myInspectionTools;

    public HTMLExportFrameMaker(String rootFolder, Project project) {
        this.myRootFolder = rootFolder;
        this.myProject = project;
        this.myInspectionTools = new ArrayList();
    }

    public void start() {
        StringBuffer buf = new StringBuffer();
        buf.append("<HTML><BODY></BODY></HTML>");
        HTMLExporter.writeFile(this.myRootFolder, "empty.html", buf, this.myProject);
    }

    public void done() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.myInspectionTools.size(); ++i) {
            InspectionTool tool = (InspectionTool)((Object)this.myInspectionTools.get(i));
            buf.append("<A HREF=\"");
            buf.append(tool.getFolderName());
            buf.append("-index.html\">");
            buf.append(tool.getDisplayName());
            buf.append("</A><BR>");
        }
        HTMLExporter.writeFile(this.myRootFolder, "index.html", buf, this.myProject);
    }

    public void startInspection(InspectionTool tool) {
        this.myInspectionTools.add(tool);
        StringBuffer buf = new StringBuffer();
        buf.append("<HTML><HEAD><TITLE>");
        buf.append(ApplicationNamesInfo.getInstance().getFullProductName());
        buf.append(InspectionsBundle.message((String)"inspection.export.title", (Object[])new Object[0]));
        buf.append("</TITLE></HEAD>");
        buf.append("<FRAMESET cols=\"30%,70%\"><FRAMESET rows=\"30%,70%\">");
        buf.append("<FRAME src=\"");
        buf.append(tool.getFolderName());
        buf.append("/index.html\" name=\"inspectionFrame\">");
        buf.append("<FRAME src=\"empty.html\" name=\"packageFrame\">");
        buf.append("</FRAMESET>");
        buf.append("<FRAME src=\"empty.html\" name=\"elementFrame\">");
        buf.append("</FRAMESET></BODY></HTML");
        HTMLExporter.writeFile(this.myRootFolder, tool.getFolderName() + "-index.html", buf, this.myProject);
    }

    public String getRootFolder() {
        return this.myRootFolder;
    }
}

