/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspection
extends BaseLocalInspectionTool {
    private static final String REQUIRED_JAVADOC_IS_ABSENT = InspectionsBundle.message((String)"inspection.javadoc.problem.descriptor", (Object[])new Object[0]);
    @NonNls
    private static final String NONE = "none";
    @NonNls
    private static final String PUBLIC = "public";
    @NonNls
    private static final String PROTECTED = "protected";
    @NonNls
    private static final String PACKAGE_LOCAL = "package";
    @NonNls
    private static final String PRIVATE = "private";
    @NonNls
    private static final Set<String> ourUniqueTags = new HashSet<String>();
    @NonNls
    public static final String SHORT_NAME = "JavaDoc";
    @NonNls
    public Options TOP_LEVEL_CLASS_OPTIONS = new Options("none", "");
    @NonNls
    public Options INNER_CLASS_OPTIONS = new Options("none", "");
    @NonNls
    public Options METHOD_OPTIONS = new Options("none", "@return@param@throws or @exception");
    @NonNls
    public Options FIELD_OPTIONS = new Options("none", "");
    public boolean IGNORE_DEPRECATED = false;
    public boolean IGNORE_JAVADOC_PERIOD = true;
    public boolean IGNORE_DUPLICATED_THROWS = false;
    public String myAdditionalJavadocTags = "";
    private static final Logger LOG;

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    private static ProblemDescriptor createDescriptor(@NotNull PsiElement element, String template, InspectionManager manager, boolean onTheFly) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.createDescriptor must not be null");
        }
        return manager.createProblemDescriptor(element, template, onTheFly, (LocalQuickFix[])null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private static ProblemDescriptor createDescriptor(@NotNull PsiElement element, String template, @NotNull LocalQuickFix fix, InspectionManager manager, boolean onTheFly) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.createDescriptor must not be null");
        }
        if (fix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.createDescriptor must not be null");
        }
        return manager.createProblemDescriptor(element, template, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiIdentifier elementToHighlight;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.checkClass must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.checkClass must not be null");
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return null;
        }
        if (psiClass instanceof JspClass) {
            return null;
        }
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        if (this.IGNORE_DEPRECATED && psiClass.isDeprecated()) {
            return null;
        }
        PsiDocComment docComment = psiClass.getDocComment();
        PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
        Object object = elementToHighlight = nameIdentifier != null ? nameIdentifier : psiClass;
        if (docComment == null) {
            ProblemDescriptor[] problemDescriptorArray;
            if (this.isJavaDocRequired((PsiModifierListOwner)psiClass)) {
                ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
                problemDescriptorArray = problemDescriptorArray2;
                problemDescriptorArray2[0] = JavaDocLocalInspection.createDescriptor((PsiElement)elementToHighlight, REQUIRED_JAVADOC_IS_ABSENT, manager, isOnTheFly);
            } else {
                problemDescriptorArray = null;
            }
            return problemDescriptorArray;
        }
        PsiDocTag[] tags = docComment.getTags();
        String[] tagsToCheck = new String[]{"author", "version", "since"};
        String[] absentDescriptionKeys = new String[]{"inspection.javadoc.problem.missing.author.description", "inspection.javadoc.problem.missing.version.description", "inspection.javadoc.problem.missing.since.description"};
        boolean[] isTagRequired = new boolean[tagsToCheck.length];
        boolean[] isTagPresent = new boolean[tagsToCheck.length];
        boolean someTagsAreRequired = false;
        for (int i = 0; i < tagsToCheck.length; ++i) {
            String tag = tagsToCheck[i];
            isTagRequired[i] = this.isTagRequired((PsiElement)psiClass, tag);
            someTagsAreRequired |= isTagRequired[i];
        }
        if (someTagsAreRequired) {
            for (PsiDocTag tag : tags) {
                String tagName = tag.getName();
                for (int i = 0; i < tagsToCheck.length; ++i) {
                    String tagToCheck = tagsToCheck[i];
                    if (!tagToCheck.equals(tagName)) continue;
                    isTagPresent[i] = true;
                }
            }
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        for (int i = 0; i < tagsToCheck.length; ++i) {
            String tagToCheck = tagsToCheck[i];
            if (!isTagRequired[i] || isTagPresent[i]) continue;
            problems.add(JavaDocLocalInspection.createMissingTagDescriptor((PsiElement)elementToHighlight, tagToCheck, manager, isOnTheFly));
        }
        ArrayList<ProblemDescriptor> tagProblems = this.getTagValuesProblems((PsiDocCommentOwner)psiClass, tags, manager, isOnTheFly);
        if (tagProblems != null) {
            problems.addAll(tagProblems);
        }
        this.checkForPeriodInDoc(docComment, problems, manager, isOnTheFly);
        this.checkInlineTags(manager, problems, docComment.getDescriptionElements(), JavaPsiFacade.getInstance((Project)docComment.getProject()).getJavadocManager(), isOnTheFly);
        this.checkForBadCharacters(docComment, problems, manager, isOnTheFly);
        for (PsiDocTag tag : tags) {
            for (int i = 0; i < tagsToCheck.length; ++i) {
                String tagToCheck = tagsToCheck[i];
                if (!tagToCheck.equals(tag.getName()) || JavaDocLocalInspection.extractTagDescription(tag).length() != 0) continue;
                problems.add(JavaDocLocalInspection.createDescriptor((PsiElement)elementToHighlight, InspectionsBundle.message((String)absentDescriptionKeys[i], (Object[])new Object[0]), manager, isOnTheFly));
            }
        }
        this.checkDuplicateTags(tags, problems, manager, isOnTheFly);
        if (this.isTagRequired((PsiElement)psiClass, "param") && psiClass.hasTypeParameters() && nameIdentifier != null) {
            PsiTypeParameter[] typeParameters;
            ArrayList<PsiTypeParameter> absentParameters = null;
            for (PsiTypeParameter typeParameter : typeParameters = psiClass.getTypeParameters()) {
                if (JavaDocLocalInspection.isFound(tags, (PsiElement)typeParameter)) continue;
                if (absentParameters == null) {
                    absentParameters = new ArrayList<PsiTypeParameter>(1);
                }
                absentParameters.add(typeParameter);
            }
            if (absentParameters != null) {
                for (PsiTypeParameter psiTypeParameter : absentParameters) {
                    problems.add(JavaDocLocalInspection.createMissingParamTagDescriptor(nameIdentifier, psiTypeParameter, manager, isOnTheFly));
                }
            }
        }
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static ProblemDescriptor createMissingParamTagDescriptor(PsiIdentifier nameIdentifier, PsiTypeParameter psiTypeParameter, InspectionManager manager, boolean isOnTheFly) {
        String message = InspectionsBundle.message((String)"inspection.javadoc.problem.missing.tag", (Object[])new Object[]{"<code>@param</code>"});
        return JavaDocLocalInspection.createDescriptor((PsiElement)nameIdentifier, message, new AddMissingTagFix("param", "<" + psiTypeParameter.getName() + ">"), manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField psiField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiField == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.checkField must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.checkField must not be null");
        }
        if (this.IGNORE_DEPRECATED && (psiField.isDeprecated() || psiField.getContainingClass().isDeprecated())) {
            return null;
        }
        PsiDocComment docComment = psiField.getDocComment();
        if (docComment == null) {
            ProblemDescriptor[] problemDescriptorArray;
            if (this.isJavaDocRequired((PsiModifierListOwner)psiField)) {
                ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
                problemDescriptorArray = problemDescriptorArray2;
                problemDescriptorArray2[0] = JavaDocLocalInspection.createDescriptor((PsiElement)psiField.getNameIdentifier(), REQUIRED_JAVADOC_IS_ABSENT, manager, isOnTheFly);
            } else {
                problemDescriptorArray = null;
            }
            return problemDescriptorArray;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        ArrayList<ProblemDescriptor> tagProblems = this.getTagValuesProblems((PsiDocCommentOwner)psiField, docComment.getTags(), manager, isOnTheFly);
        if (tagProblems != null) {
            problems.addAll(tagProblems);
        }
        this.checkInlineTags(manager, problems, docComment.getDescriptionElements(), JavaPsiFacade.getInstance((Project)docComment.getProject()).getJavadocManager(), isOnTheFly);
        this.checkForPeriodInDoc(docComment, problems, manager, isOnTheFly);
        this.checkDuplicateTags(docComment.getTags(), problems, manager, isOnTheFly);
        this.checkForBadCharacters(docComment, problems, manager, isOnTheFly);
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> tagProblems;
        PsiIdentifier psiIdentifier;
        PsiElement[] descriptionElements;
        if (psiMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.checkMethod must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.checkMethod must not be null");
        }
        if (psiMethod instanceof JspHolderMethod) {
            return null;
        }
        if (this.IGNORE_DEPRECATED && (psiMethod.isDeprecated() || psiMethod.getContainingClass().isDeprecated())) {
            return null;
        }
        PsiDocComment docComment = psiMethod.getDocComment();
        PsiMethod[] superMethods = psiMethod.findSuperMethods();
        if (docComment == null) {
            if (this.isJavaDocRequired((PsiModifierListOwner)psiMethod)) {
                Condition[] addins;
                if (superMethods.length > 0) {
                    return null;
                }
                ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.javaDocNotNecessary");
                for (Condition addin : addins = (Condition[])point.getExtensions()) {
                    if (!addin.value((Object)psiMethod)) continue;
                    return null;
                }
                if (superMethods.length == 0) {
                    ProblemDescriptor[] problemDescriptorArray;
                    PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
                    if (nameIdentifier != null) {
                        ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
                        problemDescriptorArray = problemDescriptorArray2;
                        problemDescriptorArray2[0] = JavaDocLocalInspection.createDescriptor((PsiElement)nameIdentifier, REQUIRED_JAVADOC_IS_ABSENT, manager, isOnTheFly);
                    } else {
                        problemDescriptorArray = null;
                    }
                    return problemDescriptorArray;
                }
                return null;
            }
            return null;
        }
        for (PsiElement descriptionElement : descriptionElements = docComment.getDescriptionElements()) {
            if (!(descriptionElement instanceof PsiInlineDocTag) || !"inheritDoc".equals(((PsiInlineDocTag)descriptionElement).getName())) continue;
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        this.checkInlineTags(manager, problems, descriptionElements, JavaPsiFacade.getInstance((Project)docComment.getProject()).getJavadocManager(), isOnTheFly);
        PsiDocTag tagByName = docComment.findTagByName("inheritDoc");
        if (tagByName != null) {
            String tagName = tagByName.getName();
            JavadocTagInfo tagInfo = JavaPsiFacade.getInstance((Project)tagByName.getProject()).getJavadocManager().getTagInfo(tagName);
            if (tagInfo != null && tagInfo.isValidInContext((PsiElement)psiMethod)) {
                return null;
            }
        }
        PsiDocTag[] tags = docComment.getTags();
        boolean isReturnRequired = false;
        boolean isReturnAbsent = true;
        if (superMethods.length == 0 && !psiMethod.isConstructor() && PsiType.VOID != psiMethod.getReturnType() && this.isTagRequired((PsiElement)psiMethod, "return")) {
            isReturnRequired = true;
            for (PsiDocTag tag : tags) {
                if (!"return".equals(tag.getName())) continue;
                isReturnAbsent = false;
                break;
            }
        }
        ArrayList<PsiParameter> absentParameters = null;
        if (superMethods.length == 0 && this.isTagRequired((PsiElement)psiMethod, "param")) {
            PsiParameter[] params;
            PsiParameter[] arr$ = params = psiMethod.getParameterList().getParameters();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PsiParameter param = arr$[i$];
                if (JavaDocLocalInspection.isFound(tags, (PsiElement)param)) continue;
                if (absentParameters == null) {
                    absentParameters = new ArrayList<PsiParameter>(2);
                }
                absentParameters.add(param);
            }
        }
        if (isReturnRequired && isReturnAbsent && (psiIdentifier = psiMethod.getNameIdentifier()) != null) {
            problems.add(JavaDocLocalInspection.createMissingTagDescriptor((PsiElement)psiIdentifier, "return", manager, isOnTheFly));
        }
        if (absentParameters != null) {
            for (PsiParameter psiParameter : absentParameters) {
                PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
                if (nameIdentifier == null) continue;
                problems.add(JavaDocLocalInspection.createMissingParamTagDescriptor((PsiElement)nameIdentifier, psiParameter, manager, isOnTheFly));
            }
        }
        for (PsiDocTag tag : tags) {
            boolean hasProblemsWithTag;
            if (!"param".equals(tag.getName())) continue;
            PsiElement[] dataElements = tag.getDataElements();
            PsiDocTagValue valueElement = tag.getValueElement();
            boolean bl = hasProblemsWithTag = dataElements.length < 2;
            if (!hasProblemsWithTag) {
                StringBuilder buf = new StringBuilder();
                for (PsiElement psiElement : dataElements) {
                    if (psiElement == valueElement) continue;
                    buf.append(psiElement.getText());
                }
                boolean bl2 = hasProblemsWithTag = buf.toString().trim().length() == 0;
            }
            if (!hasProblemsWithTag || valueElement == null) continue;
            problems.add(JavaDocLocalInspection.createDescriptor((PsiElement)valueElement, InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.tag.description", (Object[])new Object[]{"<code>@param " + valueElement.getText() + "</code>"}), manager, isOnTheFly));
        }
        if (superMethods.length == 0 && this.isTagRequired((PsiElement)psiMethod, "@throws") && psiMethod.getThrowsList().getReferencedTypes().length > 0) {
            PsiClassType[] classTypes;
            HashMap<PsiClassType, PsiClass> declaredExceptions = new HashMap<PsiClassType, PsiClass>();
            for (PsiClassType classType : classTypes = psiMethod.getThrowsList().getReferencedTypes()) {
                PsiClass psiClass = classType.resolve();
                if (psiClass == null) continue;
                declaredExceptions.put(classType, psiClass);
            }
            JavaDocLocalInspection.processThrowsTags(tags, declaredExceptions, manager, problems, isOnTheFly);
            if (!declaredExceptions.isEmpty()) {
                for (PsiClassType declaredException : declaredExceptions.keySet()) {
                    problems.add(JavaDocLocalInspection.createMissingThrowsTagDescriptor(psiMethod, manager, declaredException, isOnTheFly));
                }
            }
        }
        if ((tagProblems = this.getTagValuesProblems((PsiDocCommentOwner)psiMethod, tags, manager, isOnTheFly)) != null) {
            problems.addAll(tagProblems);
        }
        this.checkForPeriodInDoc(docComment, problems, manager, isOnTheFly);
        this.checkForBadCharacters(docComment, problems, manager, isOnTheFly);
        for (PsiDocTag tag : tags) {
            if ("param".equals(tag.getName())) {
                PsiDocTagValue value;
                if (JavaDocLocalInspection.extractTagDescription(tag).length() != 0 || !((value = tag.getValueElement()) instanceof PsiDocParamRef)) continue;
                PsiDocParamRef paramRef = (PsiDocParamRef)value;
                PsiParameter[] params = psiMethod.getParameterList().getParameters();
                for (PsiElement psiElement : params) {
                    if (!paramRef.getReference().isReferenceTo(psiElement)) continue;
                    problems.add(JavaDocLocalInspection.createDescriptor((PsiElement)value, InspectionsBundle.message((String)"inspection.javadoc.method.problem.descriptor", (Object[])new Object[]{"<code>@param</code>", "<code>" + psiElement.getName() + "</code>"}), manager, isOnTheFly));
                }
                continue;
            }
            if (!"return".equals(tag.getName()) || JavaDocLocalInspection.extractTagDescription(tag).length() != 0) continue;
            String message = InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.tag.description", (Object[])new Object[]{"<code>@return</code>"});
            ProblemDescriptor descriptor = manager.createProblemDescriptor(tag.getNameElement(), message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            problems.add(descriptor);
        }
        this.checkDuplicateTags(tags, problems, manager, isOnTheFly);
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    public static boolean isFound(PsiDocTag[] tags, PsiElement param) {
        for (PsiDocTag tag : tags) {
            PsiDocParamRef paramRef;
            PsiReference psiReference;
            PsiDocTagValue value;
            if (!"param".equals(tag.getName()) || !((value = tag.getValueElement()) instanceof PsiDocParamRef) || (psiReference = (paramRef = (PsiDocParamRef)value).getReference()) == null || !psiReference.isReferenceTo(param)) continue;
            return true;
        }
        return false;
    }

    private static void processThrowsTags(PsiDocTag[] tags, Map<PsiClassType, PsiClass> declaredExceptions, InspectionManager mananger, @NotNull ArrayList<ProblemDescriptor> problems, boolean isOnTheFly) {
        if (problems == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.processThrowsTags must not be null");
        }
        for (PsiDocTag tag : tags) {
            PsiJavaCodeReferenceElement ref;
            PsiElement element;
            PsiElement psiElement;
            PsiElement firstChild;
            PsiDocTagValue value;
            if (!"throws".equals(tag.getName()) && !"exception".equals(tag.getName()) || (value = tag.getValueElement()) == null || (firstChild = value.getFirstChild()) == null || !((psiElement = firstChild.getFirstChild()) instanceof PsiJavaCodeReferenceElement) || !((element = (ref = (PsiJavaCodeReferenceElement)psiElement).resolve()) instanceof PsiClass)) continue;
            PsiClass exceptionClass = (PsiClass)element;
            Iterator<PsiClassType> it = declaredExceptions.keySet().iterator();
            while (it.hasNext()) {
                PsiClassType classType = it.next();
                PsiClass psiClass = declaredExceptions.get(classType);
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)exceptionClass, (PsiClass)psiClass, (boolean)true)) continue;
                if (JavaDocLocalInspection.extractThrowsTagDescription(tag).length() == 0) {
                    problems.add(JavaDocLocalInspection.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.tag.description", (Object[])new Object[]{"<code>" + tag.getName() + "</code>"}), mananger, isOnTheFly));
                }
                it.remove();
            }
        }
    }

    @Nullable
    private static ProblemDescriptor createMissingThrowsTagDescriptor(PsiMethod method, InspectionManager manager, PsiClassType exceptionClassType, boolean isOnTheFly) {
        String tag = "throws";
        String message = InspectionsBundle.message((String)"inspection.javadoc.problem.missing.tag", (Object[])new Object[]{"<code>@" + tag + "</code> " + exceptionClassType.getCanonicalText()});
        String firstDeclaredException = exceptionClassType.getCanonicalText();
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        return nameIdentifier != null ? JavaDocLocalInspection.createDescriptor((PsiElement)nameIdentifier, message, new AddMissingTagFix(tag, firstDeclaredException), manager, isOnTheFly) : null;
    }

    private static ProblemDescriptor createMissingTagDescriptor(PsiElement elementToHighlight, @NonNls String tag, InspectionManager manager, boolean isOnTheFly) {
        String message = InspectionsBundle.message((String)"inspection.javadoc.problem.missing.tag", (Object[])new Object[]{"<code>@" + tag + "</code>"});
        return JavaDocLocalInspection.createDescriptor(elementToHighlight, message, new AddMissingTagFix(tag), manager, isOnTheFly);
    }

    private static ProblemDescriptor createMissingParamTagDescriptor(PsiElement elementToHighlight, PsiParameter param, InspectionManager manager, boolean isOnTheFly) {
        String message = InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.param.tag", (Object[])new Object[]{"<code>@param</code>", "<code>" + param.getName() + "</code>"});
        return JavaDocLocalInspection.createDescriptor(elementToHighlight, message, new AddMissingParamTagFix(param), manager, isOnTheFly);
    }

    private static String extractTagDescription(PsiDocTag tag) {
        PsiElement[] children;
        StringBuilder buf = new StringBuilder();
        for (PsiElement child : children = tag.getChildren()) {
            if (child instanceof PsiDocToken) {
                PsiDocToken token = (PsiDocToken)child;
                if (token.getTokenType() != JavaDocTokenType.DOC_COMMENT_DATA) continue;
                buf.append(token.getText());
                continue;
            }
            if (child instanceof PsiDocTagValue) {
                buf.append(child.getText());
                continue;
            }
            if (!(child instanceof PsiInlineDocTag)) continue;
            buf.append(child.getText());
        }
        String s = buf.toString();
        return s.trim();
    }

    private static String extractThrowsTagDescription(PsiDocTag tag) {
        PsiElement[] children;
        StringBuilder buf = new StringBuilder();
        for (PsiElement child : children = tag.getChildren()) {
            PsiDocToken token;
            if (!(child instanceof PsiDocToken) || (token = (PsiDocToken)child).getTokenType() != JavaDocTokenType.DOC_COMMENT_DATA) continue;
            buf.append(token.getText());
        }
        return buf.toString().trim();
    }

    private void checkForBadCharacters(PsiDocComment docComment, final ArrayList<ProblemDescriptor> problems, final InspectionManager manager, final boolean onTheFly) {
        docComment.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                ASTNode node = element.getNode();
                if (node != null && node.getElementType() == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                    problems.add(manager.createProblemDescriptor(element, "Illegal character", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        });
    }

    private void checkForPeriodInDoc(PsiDocComment docComment, ArrayList<ProblemDescriptor> problems, InspectionManager manager, boolean onTheFly) {
        if (this.IGNORE_JAVADOC_PERIOD) {
            return;
        }
        PsiDocTag[] tags = docComment.getTags();
        int dotIndex = docComment.getText().indexOf(46);
        int tagOffset = 0;
        if (dotIndex >= 0) {
            PsiDocCommentOwner owner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)docComment, PsiDocCommentOwner.class);
            for (PsiDocTag tag : tags) {
                String tagName = tag.getName();
                JavadocTagInfo tagInfo = JavaPsiFacade.getInstance((Project)tag.getProject()).getJavadocManager().getTagInfo(tagName);
                if (tagInfo == null || !tagInfo.isValidInContext((PsiElement)owner) || tagInfo.isInline()) continue;
                tagOffset = tag.getTextOffset();
                break;
            }
        }
        if (dotIndex == -1 || tagOffset > 0 && dotIndex + docComment.getTextOffset() > tagOffset) {
            problems.add(manager.createProblemDescriptor(docComment.getFirstChild(), InspectionsBundle.message((String)"inspection.javadoc.problem.descriptor1", (Object[])new Object[0]), null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, false));
        }
    }

    @Nullable
    private ArrayList<ProblemDescriptor> getTagValuesProblems(PsiDocCommentOwner context, PsiDocTag[] tags, InspectionManager inspectionManager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        for (PsiDocTag tag : tags) {
            int textOffset;
            PsiElement element;
            PsiReference reference;
            String tagName;
            JavadocManager manager = JavaPsiFacade.getInstance((Project)tag.getProject()).getJavadocManager();
            JavadocTagInfo tagInfo = manager.getTagInfo(tagName = tag.getName());
            if ((tagInfo == null || !tagInfo.isValidInContext((PsiElement)context)) && this.checkTagInfo(inspectionManager, tagInfo, tag, isOnTheFly, problems)) continue;
            PsiDocTagValue value = tag.getValueElement();
            JavadocTagInfo info = manager.getTagInfo(tagName);
            if (info != null && !info.isValidInContext((PsiElement)context)) continue;
            String message = info == null ? null : info.checkTagValue(value);
            PsiReference psiReference = reference = value != null ? value.getReference() : null;
            if (message == null && reference != null && (element = reference.resolve()) == null && (textOffset = value.getTextOffset()) == value.getTextRange().getEndOffset()) {
                problems.add(inspectionManager.createProblemDescriptor((PsiElement)tag, InspectionsBundle.message((String)"inspection.javadoc.problem.name.expected", (Object[])new Object[0]), null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, true));
            }
            if (message != null) {
                PsiDocTagValue valueElement = tag.getValueElement();
                if (valueElement == null) {
                    problems.add(inspectionManager.createProblemDescriptor((PsiElement)tag, InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.tag.description", (Object[])new Object[]{"<code>" + tag.getName() + "</code>"}), null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, true));
                } else {
                    problems.add(JavaDocLocalInspection.createDescriptor((PsiElement)valueElement, message, inspectionManager, isOnTheFly));
                }
            }
            this.checkInlineTags(inspectionManager, problems, tag.getDataElements(), manager, isOnTheFly);
        }
        return problems.isEmpty() ? null : problems;
    }

    private boolean checkTagInfo(InspectionManager inspectionManager, JavadocTagInfo tagInfo, PsiDocTag tag, boolean isOnTheFly, ArrayList<ProblemDescriptor> problems) {
        String tagName = tag.getName();
        StringTokenizer tokenizer = new StringTokenizer(this.myAdditionalJavadocTags, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!Comparing.strEqual((String)tagName, (String)tokenizer.nextToken())) continue;
            return true;
        }
        PsiElement nameElement = tag.getNameElement();
        if (nameElement != null) {
            if (tagInfo == null) {
                problems.add(JavaDocLocalInspection.createDescriptor(nameElement, InspectionsBundle.message((String)"inspection.javadoc.problem.wrong.tag", (Object[])new Object[]{"<code>" + tagName + "</code>"}), new AddUnknownTagToCustoms(tag), inspectionManager, isOnTheFly));
            } else {
                problems.add(JavaDocLocalInspection.createDescriptor(nameElement, InspectionsBundle.message((String)"inspection.javadoc.problem.disallowed.tag", (Object[])new Object[]{"<code>" + tagName + "</code>"}), new AddUnknownTagToCustoms(tag), inspectionManager, isOnTheFly));
            }
        }
        return false;
    }

    private void checkInlineTags(InspectionManager inspectionManager, ArrayList<ProblemDescriptor> problems, PsiElement[] dataElements, JavadocManager manager, boolean isOnTheFly) {
        for (PsiElement dataElement : dataElements) {
            PsiElement ref;
            PsiReference reference;
            PsiDocTagValue value;
            if (!(dataElement instanceof PsiInlineDocTag)) continue;
            PsiInlineDocTag inlineDocTag = (PsiInlineDocTag)dataElement;
            PsiElement nameElement = inlineDocTag.getNameElement();
            if (manager.getTagInfo(inlineDocTag.getName()) == null) {
                this.checkTagInfo(inspectionManager, null, (PsiDocTag)inlineDocTag, isOnTheFly, problems);
            }
            if ((value = inlineDocTag.getValueElement()) == null || (reference = value.getReference()) == null || (ref = reference.resolve()) == null || PsiTreeUtil.getParentOfType((PsiElement)inlineDocTag, PsiDocCommentOwner.class) != PsiTreeUtil.getParentOfType((PsiElement)ref, PsiDocCommentOwner.class, (boolean)false) || nameElement == null) continue;
            problems.add(JavaDocLocalInspection.createDescriptor(nameElement, InspectionsBundle.message((String)"inspection.javadoc.problem.pointing.to.itself", (Object[])new Object[0]), inspectionManager, isOnTheFly));
        }
    }

    private boolean isTagRequired(PsiElement context, @NonNls String tag) {
        if (context instanceof PsiClass) {
            if (PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class) != null) {
                return JavaDocLocalInspection.isTagRequired(this.INNER_CLASS_OPTIONS, tag);
            }
            return JavaDocLocalInspection.isTagRequired(this.TOP_LEVEL_CLASS_OPTIONS, tag);
        }
        if (context instanceof PsiMethod) {
            return JavaDocLocalInspection.isTagRequired(this.METHOD_OPTIONS, tag);
        }
        if (context instanceof PsiField) {
            return JavaDocLocalInspection.isTagRequired(this.FIELD_OPTIONS, tag);
        }
        return false;
    }

    private static boolean isTagRequired(Options options, String tag) {
        return options.REQUIRED_TAGS.contains(tag);
    }

    private boolean isJavaDocRequired(PsiModifierListOwner psiElement) {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        int actualAccess = JavaDocLocalInspection.getAccessNumber(refUtil.getAccessModifier(psiElement));
        if (psiElement instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            if (PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class) != null) {
                return actualAccess <= JavaDocLocalInspection.getAccessNumber(this.INNER_CLASS_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
            }
            return actualAccess <= JavaDocLocalInspection.getAccessNumber(this.TOP_LEVEL_CLASS_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
        }
        if (psiElement instanceof PsiMethod) {
            psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            while (psiElement != null) {
                actualAccess = Math.max(actualAccess, JavaDocLocalInspection.getAccessNumber(refUtil.getAccessModifier(psiElement)));
                psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            }
            return actualAccess <= JavaDocLocalInspection.getAccessNumber(this.METHOD_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
        }
        if (psiElement instanceof PsiField) {
            psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            while (psiElement != null) {
                actualAccess = Math.max(actualAccess, JavaDocLocalInspection.getAccessNumber(refUtil.getAccessModifier(psiElement)));
                psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            }
            return actualAccess <= JavaDocLocalInspection.getAccessNumber(this.FIELD_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
        }
        return false;
    }

    private void checkDuplicateTags(PsiDocTag[] tags, ArrayList<ProblemDescriptor> problems, InspectionManager manager, boolean isOnTheFly) {
        HashSet<String> documentedParamNames = null;
        HashSet<String> documentedExceptions = null;
        HashSet<String> uniqueTags = null;
        for (PsiDocTag tag : tags) {
            PsiDocTagValue value;
            if ("param".equals(tag.getName())) {
                PsiDocParamRef paramRef;
                PsiReference reference;
                value = tag.getValueElement();
                if (!(value instanceof PsiDocParamRef) || (reference = (paramRef = (PsiDocParamRef)value).getReference()) == null) continue;
                String paramName = reference.getCanonicalText();
                if (documentedParamNames == null) {
                    documentedParamNames = new HashSet<String>();
                }
                if (documentedParamNames.contains(paramName)) {
                    problems.add(JavaDocLocalInspection.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)"inspection.javadoc.problem.duplicate.param", (Object[])new Object[]{paramName}), manager, isOnTheFly));
                }
                documentedParamNames.add(paramName);
                continue;
            }
            if (!this.IGNORE_DUPLICATED_THROWS && ("throws".equals(tag.getName()) || "exception".equals(tag.getName()))) {
                PsiElement element;
                PsiJavaCodeReferenceElement refElement;
                PsiElement firstChild;
                value = tag.getValueElement();
                if (value == null || (firstChild = value.getFirstChild()) == null || !(firstChild.getFirstChild() instanceof PsiJavaCodeReferenceElement) || (refElement = (PsiJavaCodeReferenceElement)firstChild.getFirstChild()) == null || !((element = refElement.resolve()) instanceof PsiClass)) continue;
                String fqName = ((PsiClass)element).getQualifiedName();
                if (documentedExceptions == null) {
                    documentedExceptions = new HashSet<String>();
                }
                if (documentedExceptions.contains(fqName)) {
                    problems.add(JavaDocLocalInspection.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)"inspection.javadoc.problem.duplicate.throws", (Object[])new Object[]{fqName}), manager, isOnTheFly));
                }
                documentedExceptions.add(fqName);
                continue;
            }
            if (!ourUniqueTags.contains(tag.getName())) continue;
            if (uniqueTags == null) {
                uniqueTags = new HashSet<String>();
            }
            if (uniqueTags.contains(tag.getName())) {
                problems.add(JavaDocLocalInspection.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)"inspection.javadoc.problem.duplicate.tag", (Object[])new Object[]{tag.getName()}), manager, isOnTheFly));
            }
            uniqueTags.add(tag.getName());
        }
    }

    private static int getAccessNumber(@NonNls String accessModifier) {
        if (accessModifier.startsWith(NONE)) {
            return 0;
        }
        if (accessModifier.startsWith(PUBLIC)) {
            return 1;
        }
        if (accessModifier.startsWith(PROTECTED)) {
            return 2;
        }
        if (accessModifier.startsWith(PACKAGE_LOCAL)) {
            return 3;
        }
        if (accessModifier.startsWith(PRIVATE)) {
            return 4;
        }
        return 5;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.javadoc.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.getGroupDisplayName must not return null");
        }
        return "";
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocLocalInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    static {
        ourUniqueTags.add("return");
        ourUniqueTags.add("deprecated");
        ourUniqueTags.add("serial");
        ourUniqueTags.add("serialData");
        LOG = Logger.getInstance((String)"com.intellij.codeInspection.javaDoc.JavaDocLocalInspection");
    }

    private class AddUnknownTagToCustoms
    implements LocalQuickFix {
        PsiDocTag myTag;

        public AddUnknownTagToCustoms(PsiDocTag tag) {
            this.myTag = tag;
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("add.doctag.to.custom.tags", this.myTag.getName());
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("fix.javadoc.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms.applyFix must not be null");
            }
            if (this.myTag == null || !this.myTag.isValid()) {
                return;
            }
            JavaDocLocalInspection.this.myAdditionalJavadocTags = JavaDocLocalInspection.this.myAdditionalJavadocTags.length() > 0 ? JavaDocLocalInspection.this.myAdditionalJavadocTags + "," + this.myTag.getName() : this.myTag.getName();
            InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
            ((ModifiableModel)inspectionProfile).isProperSetting(HighlightDisplayKey.find((String)JavaDocLocalInspection.SHORT_NAME));
            InspectionProfileManager.getInstance().fireProfileChanged((Profile)inspectionProfile);
        }
    }

    private static class AddMissingParamTagFix
    extends AddMissingTagFix {
        private final PsiParameter myParam;

        public AddMissingParamTagFix(PsiParameter param) {
            super("param", param.getName());
            this.myParam = param;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.param.tag", (Object[])new Object[]{this.myParam.getName()});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingParamTagFix.getName must not return null");
            }
            return string;
        }

        @Override
        @Nullable
        protected PsiElement getAnchor() {
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myParam, PsiMethod.class);
            LOG.assertTrue(psiMethod != null);
            PsiDocComment docComment = psiMethod.getDocComment();
            LOG.assertTrue(docComment != null);
            PsiDocTag[] tags = docComment.findTagsByName("param");
            if (tags.length == 0) {
                tags = docComment.getTags();
                if (tags.length == 0) {
                    return null;
                }
                return tags[0];
            }
            PsiParameter nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.myParam, PsiParameter.class);
            while (nextParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(nextParam, tag)) continue;
                    return tag;
                }
                nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextParam, PsiParameter.class);
            }
            PsiParameter prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.myParam, PsiParameter.class);
            while (prevParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(prevParam, tag)) continue;
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, PsiDocTag.class);
                }
                prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevParam, PsiParameter.class);
            }
            return null;
        }

        private static boolean matches(PsiParameter param, PsiDocTag tag) {
            return tag.getValueElement().getText().trim().startsWith(param.getName());
        }
    }

    private static class AddMissingTagFix
    implements LocalQuickFix {
        private final String myTag;
        private final String myValue;

        public AddMissingTagFix(@NonNls String tag, String value) {
            this.myTag = tag;
            this.myValue = value;
        }

        public AddMissingTagFix(String tag) {
            this(tag, "");
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag", (Object[])new Object[]{this.myTag, this.myValue});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix.getName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix.applyFix must not be null");
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            try {
                PsiDocCommentOwner owner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getEndElement(), PsiDocCommentOwner.class);
                if (owner != null) {
                    if (!CodeInsightUtil.preparePsiElementsForWrite(new PsiElement[]{owner})) {
                        return;
                    }
                    PsiDocComment docComment = owner.getDocComment();
                    PsiDocTag tag = factory.createDocTagFromText("@" + this.myTag + " " + this.myValue, (PsiElement)docComment);
                    if (docComment != null) {
                        PsiElement anchor = this.getAnchor();
                        PsiElement addedTag = anchor != null ? docComment.addBefore((PsiElement)tag, anchor) : docComment.add((PsiElement)tag);
                        AddMissingTagFix.moveCaretTo(addedTag);
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @Nullable
        protected PsiElement getAnchor() {
            return null;
        }

        private static void moveCaretTo(PsiElement newCaretPosition) {
            PsiFile file;
            Project project = newCaretPosition.getProject();
            PsiFile psiFile = newCaretPosition.getContainingFile();
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor != null && IJSwingUtilities.hasFocus(editor.getComponent()) && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == psiFile) {
                editor.getCaretModel().moveToOffset(newCaretPosition.getTextRange().getEndOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix.getFamilyName must not return null");
            }
            return string;
        }
    }

    private class OptionsPanel
    extends JPanel {
        private JPanel createOptionsPanel(String[] modifiers, String[] tags, Options options) {
            JPanel pane = new JPanel(new GridLayout(1, tags == null ? 1 : 2));
            pane.add(this.createScopePanel(modifiers, options));
            if (tags != null) {
                pane.add(this.createTagsPanel(tags, options));
            }
            pane.validate();
            return pane;
        }

        private JPanel createTagsPanel(String[] tags, Options options) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.javadoc.required.tags.option.title", (Object[])new Object[0])), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            for (int i = 0; i < tags.length; ++i) {
                JCheckBox box = new JCheckBox(tags[i]);
                gc.gridy = i;
                if (i == tags.length - 1) {
                    gc.weighty = 1.0;
                }
                panel.add((Component)box, gc);
                box.setSelected(JavaDocLocalInspection.isTagRequired(options, tags[i]));
                box.addChangeListener(new MyChangeListener(box, options, tags[i]));
            }
            return panel;
        }

        private JPanel createScopePanel(final String[] modifiers, final Options options) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.scope.for.title", (Object[])new Object[0])), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            final Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            for (int i = 0; i < modifiers.length; ++i) {
                sliderLabels.put(i + 1, new JLabel(modifiers[i]));
            }
            final JSlider slider = new JSlider(1, 1, modifiers.length, 1);
            slider.setLabelTable(sliderLabels);
            slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            slider.setPreferredSize(new Dimension(80, 50));
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = slider.getValue();
                    options.ACCESS_JAVADOC_REQUIRED_FOR = modifiers[value - 1];
                    for (Integer key : sliderLabels.keySet()) {
                        ((JLabel)sliderLabels.get(key)).setForeground(key <= value ? Color.black : new Color(100, 100, 100));
                    }
                }
            });
            Color fore = Color.black;
            for (int i = 0; i < modifiers.length; ++i) {
                ((JLabel)sliderLabels.get(i + 1)).setForeground(fore);
                if (!modifiers[i].equals(options.ACCESS_JAVADOC_REQUIRED_FOR)) continue;
                slider.setValue(i + 1);
                fore = new Color(100, 100, 100);
            }
            panel.add((Component)slider, "West");
            return panel;
        }

        public OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0);
            gc.weighty = 0.0;
            this.add((Component)this.createAdditionalJavadocTagsPanel(), gc);
            JTabbedPane tabs = new JTabbedPane(3);
            String[] tags = new String[]{"@author", "@version", "@since", "@param"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PACKAGE_LOCAL}, tags, JavaDocLocalInspection.this.TOP_LEVEL_CLASS_OPTIONS));
            tags = new String[]{"@return", "@param", InspectionsBundle.message((String)"inspection.javadoc.throws.or.exception.option", (Object[])new Object[0])};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.method", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, tags, JavaDocLocalInspection.this.METHOD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.field", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, null, JavaDocLocalInspection.this.FIELD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.inner.class", (Object[])new Object[0]), this.createOptionsPanel(new String[]{JavaDocLocalInspection.NONE, JavaDocLocalInspection.PUBLIC, JavaDocLocalInspection.PROTECTED, JavaDocLocalInspection.PACKAGE_LOCAL, JavaDocLocalInspection.PRIVATE}, null, JavaDocLocalInspection.this.INNER_CLASS_OPTIONS));
            this.add((Component)tabs, gc);
            final JCheckBox checkBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.deprecated", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_DEPRECATED);
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaDocLocalInspection.this.IGNORE_DEPRECATED = checkBox.isSelected();
                }
            });
            gc.gridwidth = 1;
            this.add((Component)checkBox, gc);
            final JCheckBox periodCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.period", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD);
            periodCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD = periodCheckBox.isSelected();
                }
            });
            this.add((Component)periodCheckBox, gc);
            final JCheckBox ignoreDuplicateThrowsCheckBox = new JCheckBox("Ignore duplicate throws tag", JavaDocLocalInspection.this.IGNORE_DUPLICATED_THROWS);
            ignoreDuplicateThrowsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaDocLocalInspection.this.IGNORE_DUPLICATED_THROWS = ignoreDuplicateThrowsCheckBox.isSelected();
                }
            });
            this.add((Component)ignoreDuplicateThrowsCheckBox, gc);
        }

        public FieldPanel createAdditionalJavadocTagsPanel() {
            FieldPanel additionalTagsPanel = new FieldPanel(InspectionsBundle.message((String)"inspection.javadoc.label.text", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.javadoc.dialog.title", (Object[])new Object[0]), null, null);
            additionalTagsPanel.setPreferredSize(new Dimension(150, additionalTagsPanel.getPreferredSize().height));
            additionalTagsPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    Document document = e.getDocument();
                    try {
                        String text = document.getText(0, document.getLength());
                        if (text != null) {
                            JavaDocLocalInspection.this.myAdditionalJavadocTags = text.trim();
                        }
                    }
                    catch (BadLocationException e1) {
                        LOG.error((Throwable)e1);
                    }
                }
            });
            additionalTagsPanel.setText(JavaDocLocalInspection.this.myAdditionalJavadocTags);
            return additionalTagsPanel;
        }

        private class MyChangeListener
        implements ChangeListener {
            private final JCheckBox myCheckBox;
            private final Options myOptions;
            private final String myTagName;

            public MyChangeListener(JCheckBox checkBox, Options options, String tagName) {
                this.myCheckBox = checkBox;
                this.myOptions = options;
                this.myTagName = tagName;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.myCheckBox.isSelected()) {
                    if (!JavaDocLocalInspection.isTagRequired(this.myOptions, this.myTagName)) {
                        this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS + this.myTagName;
                    }
                } else {
                    this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS.replaceAll(this.myTagName, "");
                }
            }
        }
    }

    public static class Options
    implements JDOMExternalizable {
        @NonNls
        public String ACCESS_JAVADOC_REQUIRED_FOR = "none";
        @NonNls
        public String REQUIRED_TAGS = "";

        public Options() {
        }

        public Options(String ACCESS_JAVADOC_REQUIRED_FOR, String REQUIRED_TAGS) {
            this.ACCESS_JAVADOC_REQUIRED_FOR = ACCESS_JAVADOC_REQUIRED_FOR;
            this.REQUIRED_TAGS = REQUIRED_TAGS;
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
    }
}

