/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class GenericsInspectionToolBase
extends BaseLocalInspectionTool {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase.checkClass must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase.checkClass must not be null");
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (initializers.length == 0) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
        for (PsiClassInitializer initializer : initializers) {
            ProblemDescriptor[] localDescriptions = this.getDescriptions((PsiElement)initializer, manager, isOnTheFly);
            if (localDescriptions == null) continue;
            descriptors.addAll(Arrays.asList(localDescriptions));
        }
        if (descriptors.isEmpty()) {
            return null;
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase.checkField must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase.checkField must not be null");
        }
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            return this.getDescriptions((PsiElement)initializer, manager, isOnTheFly);
        }
        return null;
    }

    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase.checkMethod must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase.checkMethod must not be null");
        }
        PsiCodeBlock body = psiMethod.getBody();
        if (body != null) {
            return this.getDescriptions((PsiElement)body, manager, isOnTheFly);
        }
        return null;
    }

    public abstract ProblemDescriptor[] getDescriptions(PsiElement var1, InspectionManager var2, boolean var3);
}

