/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.MalformedPatternException;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.api.CompilerAPICompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseEmbeddedCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacCompiler;
import com.intellij.compiler.impl.javaCompiler.jikes.JikesCompiler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CompilerConfiguration", storages={@Storage(id="default", file="$PROJECT_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/compiler.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class CompilerConfigurationImpl
extends CompilerConfiguration
implements PersistentStateComponent<Element>,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.CompilerConfiguration");
    @NonNls
    public static final String TESTS_EXTERNAL_COMPILER_HOME_PROPERTY_NAME = "tests.external.compiler.home";
    public static final int DEPENDENCY_FORMAT_VERSION = 54;
    public String DEFAULT_COMPILER;
    @NotNull
    private BackendCompiler myDefaultJavaCompiler;
    private final List<Pattern> myRegexpResourcePatterns = new ArrayList<Pattern>();
    private final List<String> myWildcardPatterns = new ArrayList<String>();
    private final List<Pair<Pattern, Pattern>> myCompiledPatterns = new ArrayList<Pair<Pattern, Pattern>>();
    private final List<Pair<Pattern, Pattern>> myNegatedCompiledPatterns = new ArrayList<Pair<Pattern, Pattern>>();
    private boolean myWildcardPatternsInitialized = false;
    private final Project myProject;
    private final ModuleManager myModuleManager;
    private final ExcludedEntriesConfiguration myExcludedEntriesConfiguration;
    private final Collection<BackendCompiler> myRegisteredCompilers = new ArrayList<BackendCompiler>();
    private JavacCompiler JAVAC_EXTERNAL_BACKEND;
    private final Perl5Matcher myPatternMatcher = new Perl5Matcher();
    private boolean myEnableAnnotationProcessors;
    private final Map<String, String> myProcessorsMap;
    private boolean myObtainProcessorsFromClasspath;
    private String myProcessorPath;
    private final Map<Module, String> myProcessedModules;
    private final Map<String, String> myModuleNames;
    @NonNls
    private static final String EXCLUDE_FROM_COMPILE = "excludeFromCompile";
    @NonNls
    private static final String RESOURCE_EXTENSIONS = "resourceExtensions";
    @NonNls
    private static final String ANNOTATION_PROCESSING = "annotationProcessing";
    @NonNls
    private static final String WILDCARD_RESOURCE_PATTERNS = "wildcardResourcePatterns";
    @NonNls
    private static final String ENTRY = "entry";
    @NonNls
    private static final String NAME = "name";

    public CompilerConfigurationImpl(Project project, ModuleManager moduleManager) {
        this.loadDefaultWildcardPatterns();
        this.myEnableAnnotationProcessors = false;
        this.myProcessorsMap = new HashMap();
        this.myObtainProcessorsFromClasspath = true;
        this.myProcessorPath = "";
        this.myProcessedModules = new HashMap();
        this.myModuleNames = new HashMap();
        this.myProject = project;
        this.myModuleManager = moduleManager;
        this.myExcludedEntriesConfiguration = new ExcludedEntriesConfiguration();
        Disposer.register((Disposable)project, (Disposable)this.myExcludedEntriesConfiguration);
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void modulesRenamed(Project project, List<Module> modules) {
            }

            public void moduleRemoved(Project project, Module module) {
            }

            public void beforeModuleRemoved(Project project, Module module) {
                CompilerConfigurationImpl.this.myProcessedModules.remove(module);
                CompilerConfigurationImpl.this.myModuleNames.remove(module.getName());
            }

            public void moduleAdded(Project project, Module module) {
                String moduleName = module.getName();
                if (CompilerConfigurationImpl.this.myModuleNames.containsKey(moduleName)) {
                    String dirName = (String)CompilerConfigurationImpl.this.myModuleNames.remove(moduleName);
                    CompilerConfigurationImpl.this.myProcessedModules.put(module, dirName);
                }
            }
        });
    }

    public Element getState() {
        try {
            Element e = new Element("state");
            this.writeExternal(e);
            return e;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    private void loadDefaultWildcardPatterns() {
        if (!this.myWildcardPatterns.isEmpty()) {
            this.removeWildcardPatterns();
        }
        try {
            this.addWildcardResourcePattern("?*.properties");
            this.addWildcardResourcePattern("?*.xml");
            this.addWildcardResourcePattern("?*.gif");
            this.addWildcardResourcePattern("?*.png");
            this.addWildcardResourcePattern("?*.jpeg");
            this.addWildcardResourcePattern("?*.jpg");
            this.addWildcardResourcePattern("?*.html");
            this.addWildcardResourcePattern("?*.dtd");
            this.addWildcardResourcePattern("?*.tld");
            this.addWildcardResourcePattern("?*.ftl");
        }
        catch (MalformedPatternException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String getTestsExternalCompilerHome() {
        String compilerHome = System.getProperty(TESTS_EXTERNAL_COMPILER_HOME_PROPERTY_NAME, null);
        if (compilerHome == null) {
            compilerHome = SystemInfo.isMac ? new File(System.getProperty("java.home")).getAbsolutePath() : new File(System.getProperty("java.home")).getParentFile().getAbsolutePath();
        }
        return compilerHome;
    }

    private static Pattern compilePattern(@NonNls String s) throws MalformedPatternException {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            return SystemInfo.isFileSystemCaseSensitive ? compiler.compile(s) : compiler.compile(s, 1);
        }
        catch (org.apache.oro.text.regex.MalformedPatternException ex) {
            throw new MalformedPatternException((Throwable)ex);
        }
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public void projectClosed() {
    }

    public JavacCompiler getJavacCompiler() {
        this.createCompilers();
        return this.JAVAC_EXTERNAL_BACKEND;
    }

    public void projectOpened() {
        this.createCompilers();
    }

    private void createCompilers() {
        if (this.JAVAC_EXTERNAL_BACKEND != null) {
            return;
        }
        this.JAVAC_EXTERNAL_BACKEND = new JavacCompiler(this.myProject);
        this.myRegisteredCompilers.add(this.JAVAC_EXTERNAL_BACKEND);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JikesCompiler JIKES_BACKEND = new JikesCompiler(this.myProject);
            this.myRegisteredCompilers.add(JIKES_BACKEND);
            if (EclipseCompiler.isInitialized()) {
                EclipseCompiler eclipse = new EclipseCompiler(this.myProject);
                this.myRegisteredCompilers.add(eclipse);
            }
            if (ApplicationManagerEx.getApplicationEx().isInternal()) {
                try {
                    EclipseEmbeddedCompiler eclipseEmbedded = new EclipseEmbeddedCompiler(this.myProject);
                    this.myRegisteredCompilers.add(eclipseEmbedded);
                }
                catch (NoClassDefFoundError e) {
                    // empty catch block
                }
            }
            try {
                CompilerAPICompiler inProcessJavaCompiler = new CompilerAPICompiler(this.myProject);
                this.myRegisteredCompilers.add(inProcessJavaCompiler);
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
        BackendCompiler[] compilers = (BackendCompiler[])Extensions.getExtensions(BackendCompiler.EP_NAME, (AreaInstance)this.myProject);
        HashSet<FileType> types = new HashSet<FileType>();
        for (BackendCompiler compiler : compilers) {
            this.myRegisteredCompilers.add(compiler);
            types.addAll(compiler.getCompilableFileTypes());
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        for (FileType type : types) {
            compilerManager.addCompilableFileType(type);
        }
        this.myDefaultJavaCompiler = this.JAVAC_EXTERNAL_BACKEND;
        for (BackendCompiler compiler : this.myRegisteredCompilers) {
            if (!compiler.getId().equals(this.DEFAULT_COMPILER)) continue;
            this.myDefaultJavaCompiler = compiler;
            break;
        }
        this.DEFAULT_COMPILER = this.myDefaultJavaCompiler.getId();
    }

    public Collection<BackendCompiler> getRegisteredJavaCompilers() {
        this.createCompilers();
        return this.myRegisteredCompilers;
    }

    public String[] getResourceFilePatterns() {
        return this.getWildcardPatterns();
    }

    private String[] getRegexpPatterns() {
        String[] patterns = ArrayUtil.newStringArray((int)this.myRegexpResourcePatterns.size());
        int index = 0;
        for (Pattern myRegexpResourcePattern : this.myRegexpResourcePatterns) {
            patterns[index++] = myRegexpResourcePattern.getPattern();
        }
        return patterns;
    }

    private String[] getWildcardPatterns() {
        return ArrayUtil.toStringArray(this.myWildcardPatterns);
    }

    public void addResourceFilePattern(String namePattern) throws MalformedPatternException {
        this.addWildcardResourcePattern(namePattern);
    }

    private void addRegexpPattern(String namePattern) throws MalformedPatternException {
        Pattern pattern = CompilerConfigurationImpl.compilePattern(namePattern);
        if (pattern != null) {
            this.myRegexpResourcePatterns.add(pattern);
        }
    }

    public ExcludedEntriesConfiguration getExcludedEntriesConfiguration() {
        return this.myExcludedEntriesConfiguration;
    }

    public boolean isExcludedFromCompilation(VirtualFile virtualFile) {
        return this.myExcludedEntriesConfiguration.isExcluded(virtualFile);
    }

    public boolean isResourceFile(VirtualFile virtualFile) {
        return this.isResourceFile(virtualFile.getName(), virtualFile.getParent());
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myEnableAnnotationProcessors;
    }

    public void setAnnotationProcessorsEnabled(boolean enableAnnotationProcessors) {
        this.myEnableAnnotationProcessors = enableAnnotationProcessors;
    }

    public boolean isObtainProcessorsFromClasspath() {
        return this.myObtainProcessorsFromClasspath;
    }

    public void setObtainProcessorsFromClasspath(boolean obtainProcessorsFromClasspath) {
        this.myObtainProcessorsFromClasspath = obtainProcessorsFromClasspath;
    }

    public String getProcessorPath() {
        return this.myProcessorPath;
    }

    public void setProcessorsPath(String processorsPath) {
        this.myProcessorPath = processorsPath;
    }

    public Map<String, String> getAnnotationProcessorsMap() {
        return Collections.unmodifiableMap(this.myProcessorsMap);
    }

    public void setAnnotationProcessorsMap(Map<String, String> map) {
        this.myProcessorsMap.clear();
        this.myProcessorsMap.putAll(map);
    }

    public void setAnotationProcessedModules(Map<Module, String> modules) {
        this.myProcessedModules.clear();
        this.myModuleNames.clear();
        this.myProcessedModules.putAll(modules);
    }

    public Map<Module, String> getAnotationProcessedModules() {
        return Collections.unmodifiableMap(this.myProcessedModules);
    }

    public boolean isAnnotationProcessingEnabled(Module module) {
        return this.myProcessedModules.containsKey(module);
    }

    public String getGeneratedSourceDirName(Module module) {
        return this.myProcessedModules.get(module);
    }

    private void addWildcardResourcePattern(@NonNls String wildcardPattern) throws MalformedPatternException {
        Pair<Pattern, Pattern> pattern = CompilerConfigurationImpl.convertToRegexp(wildcardPattern);
        if (pattern != null) {
            this.myWildcardPatterns.add(wildcardPattern);
            if (CompilerConfigurationImpl.isPatternNegated(wildcardPattern)) {
                this.myNegatedCompiledPatterns.add(pattern);
            } else {
                this.myCompiledPatterns.add(pattern);
            }
        }
    }

    public void removeResourceFilePatterns() {
        this.removeWildcardPatterns();
    }

    private void removeRegexpPatterns() {
        this.myRegexpResourcePatterns.clear();
    }

    private void removeWildcardPatterns() {
        this.myWildcardPatterns.clear();
        this.myCompiledPatterns.clear();
        this.myNegatedCompiledPatterns.clear();
    }

    private static Pair<Pattern, Pattern> convertToRegexp(String wildcardPattern) {
        if (CompilerConfigurationImpl.isPatternNegated(wildcardPattern)) {
            wildcardPattern = wildcardPattern.substring(1);
        }
        wildcardPattern = FileUtil.toSystemIndependentName((String)wildcardPattern);
        String dirPattern = null;
        int slash = wildcardPattern.lastIndexOf(47);
        if (slash >= 0) {
            dirPattern = wildcardPattern.substring(0, slash + 1);
            wildcardPattern = wildcardPattern.substring(slash + 1);
            if (!dirPattern.startsWith("/")) {
                dirPattern = "/" + dirPattern;
            }
            dirPattern = CompilerConfigurationImpl.normalizeWildcards(dirPattern);
            dirPattern = StringUtil.replace((String)dirPattern, (String)"/.*.*/", (String)"(/.*)?/");
            dirPattern = StringUtil.trimEnd((String)dirPattern, (String)"/");
            dirPattern = CompilerConfigurationImpl.optimize(dirPattern);
            dirPattern = ".*" + dirPattern;
        }
        wildcardPattern = CompilerConfigurationImpl.normalizeWildcards(wildcardPattern);
        wildcardPattern = CompilerConfigurationImpl.optimize(wildcardPattern);
        Pattern dirCompiled = dirPattern == null ? null : CompilerConfigurationImpl.compilePattern(dirPattern);
        return Pair.create((Object)CompilerConfigurationImpl.compilePattern(wildcardPattern), (Object)dirCompiled);
    }

    private static String optimize(String wildcardPattern) {
        return wildcardPattern.replaceAll("(?:\\.\\*)+", ".*");
    }

    private static String normalizeWildcards(String wildcardPattern) {
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"\\!", (String)"!");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)".", (String)"\\.");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"*?", (String)".+");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"?*", (String)".+");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"*", (String)".*");
        wildcardPattern = StringUtil.replace((String)wildcardPattern, (String)"?", (String)".");
        return wildcardPattern;
    }

    public static boolean isPatternNegated(String wildcardPattern) {
        return wildcardPattern.length() > 1 && wildcardPattern.charAt(0) == '!';
    }

    public boolean isResourceFile(String name) {
        return this.isResourceFile(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matches(String s, Pattern p) {
        Perl5Matcher perl5Matcher = this.myPatternMatcher;
        synchronized (perl5Matcher) {
            try {
                return this.myPatternMatcher.matches(s, p);
            }
            catch (Exception e) {
                LOG.error("Exception matching file name \"" + s + "\" against the pattern \"" + p + "\"", (Throwable)e);
                return false;
            }
        }
    }

    private boolean isResourceFile(String name, @Nullable VirtualFile parent) {
        int i;
        Ref parentRef = Ref.create(null);
        for (i = 0; i < this.myCompiledPatterns.size(); ++i) {
            if (!this.matches(name, parent, (Ref<String>)parentRef, this.myCompiledPatterns.get(i))) continue;
            return true;
        }
        if (this.myNegatedCompiledPatterns.isEmpty()) {
            return false;
        }
        for (i = 0; i < this.myNegatedCompiledPatterns.size(); ++i) {
            if (!this.matches(name, parent, (Ref<String>)parentRef, this.myNegatedCompiledPatterns.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matches(String name, VirtualFile parent, Ref<String> parentRef, Pair<Pattern, Pattern> pair) {
        if (!this.matches(name, (Pattern)pair.first)) {
            return false;
        }
        Pattern dirPattern = (Pattern)pair.second;
        if (dirPattern == null || parent == null) {
            return true;
        }
        String parentPath = (String)parentRef.get();
        if (parentPath == null) {
            parentPath = parent.getPath();
            parentRef.set((Object)parentPath);
        }
        return this.matches(parentPath, dirPattern);
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)parentNode);
        Element node = parentNode.getChild(EXCLUDE_FROM_COMPILE);
        if (node != null) {
            this.myExcludedEntriesConfiguration.readExternal(node);
        }
        try {
            String pattern;
            Element element;
            this.removeRegexpPatterns();
            node = parentNode.getChild(RESOURCE_EXTENSIONS);
            if (node != null) {
                for (Object o : node.getChildren(ENTRY)) {
                    element = (Element)o;
                    pattern = element.getAttributeValue(NAME);
                    if (pattern == null || "".equals(pattern)) continue;
                    this.addRegexpPattern(pattern);
                }
            }
            this.removeWildcardPatterns();
            node = parentNode.getChild(WILDCARD_RESOURCE_PATTERNS);
            if (node != null) {
                this.myWildcardPatternsInitialized = true;
                for (Object o : node.getChildren(ENTRY)) {
                    element = (Element)o;
                    pattern = element.getAttributeValue(NAME);
                    if (pattern == null || "".equals(pattern)) continue;
                    this.addWildcardResourcePattern(pattern);
                }
            }
        }
        catch (MalformedPatternException e) {
            throw new InvalidDataException((Throwable)e);
        }
        Element annotationProcessingSettings = parentNode.getChild(ANNOTATION_PROCESSING);
        if (annotationProcessingSettings != null) {
            this.myEnableAnnotationProcessors = Boolean.valueOf(annotationProcessingSettings.getAttributeValue("enabled", "false"));
            this.myObtainProcessorsFromClasspath = Boolean.valueOf(annotationProcessingSettings.getAttributeValue("useClasspath", "true"));
            StringBuilder pathBuilder = new StringBuilder();
            for (Element pathElement : annotationProcessingSettings.getChildren("processorPath")) {
                String path = pathElement.getAttributeValue("value");
                if (path == null) continue;
                if (pathBuilder.length() > 0) {
                    pathBuilder.append(File.pathSeparator);
                }
                pathBuilder.append(path);
            }
            this.myProcessorPath = pathBuilder.toString();
            this.myProcessorsMap.clear();
            for (Element processorChild : annotationProcessingSettings.getChildren("processor")) {
                String name = processorChild.getAttributeValue(NAME);
                String options = processorChild.getAttributeValue("options", "");
                this.myProcessorsMap.put(name, options);
            }
            this.myProcessedModules.clear();
            this.myModuleNames.clear();
            List processed = annotationProcessingSettings.getChildren("processModule");
            if (!processed.isEmpty()) {
                HashMap moduleMap = new HashMap();
                for (Module module : this.myModuleManager.getModules()) {
                    moduleMap.put(module.getName(), module);
                }
                for (Element moduleElement : processed) {
                    String name = moduleElement.getAttributeValue(NAME);
                    String dirname = moduleElement.getAttributeValue("generatedDirName");
                    if (name == null) continue;
                    Module module = (Module)moduleMap.get(name);
                    if (module != null) {
                        this.myProcessedModules.put(module, dirname);
                        continue;
                    }
                    this.myModuleNames.put(name, dirname);
                }
            }
        }
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        Element newChild;
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)parentNode);
        if (this.myExcludedEntriesConfiguration.getExcludeEntryDescriptions().length > 0) {
            newChild = new Element(EXCLUDE_FROM_COMPILE);
            this.myExcludedEntriesConfiguration.writeExternal(newChild);
            parentNode.addContent(newChild);
        }
        newChild = new Element(RESOURCE_EXTENSIONS);
        for (String pattern : this.getRegexpPatterns()) {
            Element entry = new Element(ENTRY);
            entry.setAttribute(NAME, pattern);
            newChild.addContent(entry);
        }
        parentNode.addContent(newChild);
        if (this.myWildcardPatternsInitialized || !this.myWildcardPatterns.isEmpty()) {
            Element wildcardPatterns = new Element(WILDCARD_RESOURCE_PATTERNS);
            for (String wildcardPattern : this.myWildcardPatterns) {
                Element entry = new Element(ENTRY);
                entry.setAttribute(NAME, wildcardPattern);
                wildcardPatterns.addContent(entry);
            }
            parentNode.addContent(wildcardPatterns);
        }
        Element annotationProcessingSettings = new Element(ANNOTATION_PROCESSING);
        parentNode.addContent(annotationProcessingSettings);
        annotationProcessingSettings.setAttribute("enabled", String.valueOf(this.myEnableAnnotationProcessors));
        annotationProcessingSettings.setAttribute("useClasspath", String.valueOf(this.myObtainProcessorsFromClasspath));
        if (this.myProcessorPath.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(this.myProcessorPath, File.pathSeparator, false);
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken();
                Element pathElement = new Element("processorPath");
                annotationProcessingSettings.addContent(pathElement);
                pathElement.setAttribute("value", path);
            }
        }
        for (Map.Entry<String, String> entry : this.myProcessorsMap.entrySet()) {
            Element processor = new Element("processor");
            annotationProcessingSettings.addContent(processor);
            processor.setAttribute(NAME, entry.getKey());
            processor.setAttribute("options", entry.getValue());
        }
        ArrayList<Module> modules = new ArrayList<Module>(this.myProcessedModules.keySet());
        Collections.sort(modules, new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Module module : modules) {
            Element moduleElement = new Element("processModule");
            annotationProcessingSettings.addContent(moduleElement);
            moduleElement.setAttribute(NAME, module.getName());
            String dirName = this.myProcessedModules.get(module);
            if (dirName == null || dirName.length() <= 0) continue;
            moduleElement.setAttribute("generatedDirName", dirName);
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("CompilerConfiguration" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/CompilerConfigurationImpl.getComponentName must not return null");
        }
        return "CompilerConfiguration";
    }

    public BackendCompiler getDefaultCompiler() {
        this.createCompilers();
        return this.myDefaultJavaCompiler;
    }

    public void setDefaultCompiler(BackendCompiler defaultCompiler) {
        this.myDefaultJavaCompiler = defaultCompiler;
        this.DEFAULT_COMPILER = defaultCompiler.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertPatterns() {
        if (!this.needPatternConversion()) {
            return;
        }
        try {
            boolean ok;
            try {
                ok = this.doConvertPatterns();
            }
            catch (MalformedPatternException e) {
                ok = false;
            }
            if (!ok) {
                String initialPatternString = CompilerConfigurationImpl.patternsToString(this.getRegexpPatterns());
                String message = CompilerBundle.message((String)"message.resource.patterns.format.changed", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), initialPatternString, CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()});
                String wildcardPatterns = Messages.showInputDialog((Project)this.myProject, (String)message, (String)CompilerBundle.message((String)"pattern.conversion.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon(), (String)initialPatternString, (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return true;
                    }

                    public boolean canClose(String inputString) {
                        StringTokenizer tokenizer = new StringTokenizer(inputString, ";", false);
                        StringBuilder malformedPatterns = new StringBuilder();
                        while (tokenizer.hasMoreTokens()) {
                            String pattern = tokenizer.nextToken();
                            try {
                                CompilerConfigurationImpl.this.addWildcardResourcePattern(pattern);
                            }
                            catch (MalformedPatternException e) {
                                malformedPatterns.append("\n\n");
                                malformedPatterns.append(pattern);
                                malformedPatterns.append(": ");
                                malformedPatterns.append(e.getMessage());
                            }
                        }
                        if (malformedPatterns.length() > 0) {
                            Messages.showErrorDialog((String)CompilerBundle.message((String)"error.bad.resource.patterns", (Object[])new Object[]{malformedPatterns.toString()}), (String)CompilerBundle.message((String)"bad.resource.patterns.dialog.title", (Object[])new Object[0]));
                            CompilerConfigurationImpl.this.removeWildcardPatterns();
                            return false;
                        }
                        return true;
                    }
                });
                if (wildcardPatterns == null) {
                    this.loadDefaultWildcardPatterns();
                }
            }
        }
        finally {
            this.myWildcardPatternsInitialized = true;
        }
    }

    private boolean needPatternConversion() {
        return !this.myWildcardPatternsInitialized && !this.myRegexpResourcePatterns.isEmpty();
    }

    private boolean doConvertPatterns() throws MalformedPatternException {
        String[] regexpPatterns = this.getRegexpPatterns();
        ArrayList<String> converted = new ArrayList<String>();
        Pattern multipleExtensionsPatternPattern = CompilerConfigurationImpl.compilePattern("\\.\\+\\\\\\.\\((\\w+(?:\\|\\w+)*)\\)");
        Pattern singleExtensionPatternPattern = CompilerConfigurationImpl.compilePattern("\\.\\+\\\\\\.(\\w+)");
        Perl5Matcher matcher = new Perl5Matcher();
        for (String regexpPattern : regexpPatterns) {
            MatchResult match;
            if (matcher.matches(regexpPattern, multipleExtensionsPatternPattern)) {
                match = matcher.getMatch();
                StringTokenizer tokenizer = new StringTokenizer(match.group(1), "|", false);
                while (tokenizer.hasMoreTokens()) {
                    converted.add("?*." + tokenizer.nextToken());
                }
                continue;
            }
            if (matcher.matches(regexpPattern, singleExtensionPatternPattern)) {
                match = matcher.getMatch();
                converted.add("?*." + match.group(1));
                continue;
            }
            return false;
        }
        for (String aConverted : converted) {
            this.addWildcardResourcePattern(aConverted);
        }
        return true;
    }

    private static String patternsToString(String[] patterns) {
        StringBuilder extensionsString = new StringBuilder();
        for (int idx = 0; idx < patterns.length; ++idx) {
            if (idx > 0) {
                extensionsString.append(";");
            }
            extensionsString.append(patterns[idx]);
        }
        return extensionsString.toString();
    }
}

