/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.SignatureParser;
import com.intellij.compiler.classParsing.SignatureParsingException;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.util.ArrayUtil;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class GenericMethodSignature {
    private final String myFormalTypeParams;
    private final String[] myParamSignatures;
    private final String myReturnTypeSignature;
    private final String myThrowsSignature;

    private GenericMethodSignature(String formalTypeParams, String[] paramSignatures, String returnTypeSignature, String throwsSignature) {
        this.myFormalTypeParams = formalTypeParams;
        this.myParamSignatures = paramSignatures;
        this.myReturnTypeSignature = returnTypeSignature;
        this.myThrowsSignature = throwsSignature;
    }

    public String getFormalTypeParams() {
        return this.myFormalTypeParams;
    }

    public String[] getParamSignatures() {
        return this.myParamSignatures;
    }

    public String getReturnTypeSignature() {
        return this.myReturnTypeSignature;
    }

    public String getThrowsSignature() {
        return this.myThrowsSignature;
    }

    public static GenericMethodSignature parse(String methodSignature) throws SignatureParsingException {
        String[] paramSignatures;
        StringCharacterIterator it = new StringCharacterIterator(methodSignature);
        StringBuilder formals = new StringBuilder();
        if (it.current() == '<') {
            SignatureParser.INSTANCE.parseFormalTypeParameters(it, formals);
        }
        if (it.current() != '(') {
            throw new SignatureParsingException(CompilerBundle.message((String)"error.signature.parsing.expected.other.symbol", (Object[])new Object[]{"(", formals.toString()}));
        }
        it.next();
        if (it.current() != ')') {
            ArrayList<String> params = new ArrayList<String>();
            while (it.current() != ')') {
                StringBuilder typeSignature = new StringBuilder();
                SignatureParser.INSTANCE.parseTypeSignature(it, typeSignature);
                params.add(typeSignature.toString());
            }
            paramSignatures = ArrayUtil.toStringArray(params);
        } else {
            paramSignatures = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        it.next();
        StringBuilder returnTypeSignature = new StringBuilder();
        SignatureParser.INSTANCE.parseReturnType(it, returnTypeSignature);
        StringBuilder throwsSignature = new StringBuilder();
        if (it.current() != '\uffff') {
            SignatureParser.INSTANCE.parseThrowsSignature(it, throwsSignature);
        }
        return new GenericMethodSignature(formals.toString(), paramSignatures, returnTypeSignature.toString(), throwsSignature.toString());
    }
}

