/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.DependencyProcessor;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ExternalCompiler
implements BackendCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.ExternalCompiler");
    private static final Set<FileType> COMPILABLE_TYPES = Collections.singleton(StdFileTypes.JAVA);

    @NotNull
    public abstract String[] createStartupCommand(ModuleChunk var1, CompileContext var2, String var3) throws IOException, IllegalArgumentException;

    @Override
    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        Set<FileType> set = COMPILABLE_TYPES;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/ExternalCompiler.getCompilableFileTypes must not return null");
        }
        return set;
    }

    @Override
    public DependencyProcessor getDependencyProcessor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Process launchProcess(@NotNull ModuleChunk chunk, @NotNull String outputDir, @NotNull CompileContext compileContext) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/ExternalCompiler.launchProcess must not be null");
        }
        if (outputDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/ExternalCompiler.launchProcess must not be null");
        }
        if (compileContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/compiler/impl/javaCompiler/ExternalCompiler.launchProcess must not be null");
        }
        String[] commands = this.createStartupCommand(chunk, compileContext, outputDir);
        if (LOG.isDebugEnabled()) {
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                buf.append("\n===================================Environment:===========================\n");
                for (String pair : EnvironmentUtil.getEnvironment()) {
                    buf.append("\t").append(pair).append("\n");
                }
                buf.append("=============================================================================\n");
                buf.append("Running compiler: ");
                for (String command : commands) {
                    buf.append(" ").append(command);
                }
                LOG.debug(buf.toString());
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
        }
        Process process = Runtime.getRuntime().exec(commands);
        if (process == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/javaCompiler/ExternalCompiler.launchProcess must not return null");
        }
        return process;
    }
}

