/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.conversion.impl.ComponentManagerSettingsImpl;
import com.intellij.conversion.impl.ModuleSettingsImpl;
import com.intellij.conversion.impl.ProjectSettingsImpl;
import com.intellij.conversion.impl.RunManagerSettingsImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.conversion.impl.WorkspaceSettingsImpl;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversionContextImpl
implements ConversionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.conversion.impl.ConversionContextImpl");
    private Map<File, SettingsXmlFile> mySettingsFiles = new HashMap<File, SettingsXmlFile>();
    private StorageScheme myStorageScheme;
    private File myProjectBaseDir;
    private File myProjectFile;
    private File myWorkspaceFile;
    private File[] myModuleFiles;
    private ProjectSettingsImpl myProjectSettings;
    private WorkspaceSettingsImpl myWorkspaceSettings;
    private List<File> myNonExistingModuleFiles = new ArrayList<File>();
    private Map<File, ModuleSettingsImpl> myFile2ModuleSettings = new HashMap<File, ModuleSettingsImpl>();
    private Map<String, ModuleSettingsImpl> myName2ModuleSettings = new HashMap<String, ModuleSettingsImpl>();
    private RunManagerSettingsImpl myRunManagerSettings;
    private File mySettingsBaseDir;
    private ComponentManagerSettings myCompilerManagerSettings;
    private ComponentManagerSettings myProjectRootManagerSettings;

    public ConversionContextImpl(String projectPath) throws CannotConvertException {
        File modulesFile;
        this.myProjectFile = new File(projectPath);
        if (this.myProjectFile.isDirectory()) {
            this.myStorageScheme = StorageScheme.DIRECTORY_BASED;
            this.myProjectBaseDir = this.myProjectFile;
            this.mySettingsBaseDir = new File(this.myProjectBaseDir.getAbsolutePath(), ".idea");
            modulesFile = new File(this.mySettingsBaseDir, "modules.xml");
            this.myWorkspaceFile = new File(this.mySettingsBaseDir, "workspace.xml");
        } else {
            this.myStorageScheme = StorageScheme.DEFAULT;
            this.myProjectBaseDir = this.myProjectFile.getParentFile();
            modulesFile = this.myProjectFile;
            this.myWorkspaceFile = new File(StringUtil.trimEnd((String)projectPath, (String)".ipr") + ".iws");
        }
        this.myModuleFiles = this.findModuleFiles(JDomConvertingUtil.loadDocument(modulesFile).getRootElement());
    }

    public Set<File> getAllProjectFiles() {
        HashSet<File> files = new HashSet<File>(Arrays.asList(this.myModuleFiles));
        if (this.myStorageScheme == StorageScheme.DEFAULT) {
            files.add(this.myProjectFile);
            files.add(this.myWorkspaceFile);
        } else {
            ConversionContextImpl.addFilesRecursively(this.mySettingsBaseDir, files);
        }
        return files;
    }

    private static void addFilesRecursively(File file, Set<File> files) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    ConversionContextImpl.addFilesRecursively(child, files);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".xml") && !file.getName().startsWith(".")) {
            files.add(file);
        }
    }

    @Override
    @NotNull
    public File getProjectBaseDir() {
        File file = this.myProjectBaseDir;
        if (file == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionContextImpl.getProjectBaseDir must not return null");
        }
        return file;
    }

    public File[] getModuleFiles() {
        return this.myModuleFiles;
    }

    private File[] findModuleFiles(Element root) {
        Element modulesManager = JDomConvertingUtil.findComponent(root, "ProjectModuleManager");
        if (modulesManager == null) {
            return new File[0];
        }
        Element modules = modulesManager.getChild("modules");
        if (modules == null) {
            return new File[0];
        }
        ExpandMacroToPathMap macros = this.createExpandMacroMap();
        ArrayList<File> files = new ArrayList<File>();
        for (Element module : JDomConvertingUtil.getChildren(modules, "module")) {
            String filePath = module.getAttributeValue("filepath");
            filePath = macros.substitute(filePath, true);
            files.add(new File(FileUtil.toSystemDependentName((String)filePath)));
        }
        return files.toArray(new File[files.size()]);
    }

    @NotNull
    public String expandPath(@NotNull String path, @NotNull ModuleSettingsImpl moduleSettings) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionContextImpl.expandPath must not be null");
        }
        if (moduleSettings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/conversion/impl/ConversionContextImpl.expandPath must not be null");
        }
        String string = this.createExpandMacroMap(moduleSettings).substitute(path, true);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionContextImpl.expandPath must not return null");
        }
        return string;
    }

    private ExpandMacroToPathMap createExpandMacroMap(@Nullable ModuleSettingsImpl moduleSettings) {
        ExpandMacroToPathMap map = this.createExpandMacroMap();
        if (moduleSettings != null) {
            String modulePath = FileUtil.toSystemIndependentName((String)moduleSettings.getModuleFile().getParentFile().getAbsolutePath());
            map.addMacroExpand("MODULE_DIR", modulePath);
        }
        return map;
    }

    @Override
    @NotNull
    public String collapsePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionContextImpl.collapsePath must not be null");
        }
        ReplacePathToMacroMap map = ConversionContextImpl.createCollapseMacroMap("PROJECT_DIR", this.myProjectBaseDir);
        String string = map.substitute(path, SystemInfo.isFileSystemCaseSensitive);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionContextImpl.collapsePath must not return null");
        }
        return string;
    }

    public String collapsePath(@NotNull String path, @NotNull ModuleSettingsImpl moduleSettings) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionContextImpl.collapsePath must not be null");
        }
        if (moduleSettings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/conversion/impl/ConversionContextImpl.collapsePath must not be null");
        }
        ReplacePathToMacroMap map = ConversionContextImpl.createCollapseMacroMap("MODULE_DIR", moduleSettings.getModuleFile().getParentFile());
        return map.substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    private static ReplacePathToMacroMap createCollapseMacroMap(String macroName, File dir) {
        ReplacePathToMacroMap map = new ReplacePathToMacroMap();
        map.addMacroReplacement(FileUtil.toSystemIndependentName((String)dir.getAbsolutePath()), macroName);
        PathMacrosImpl.getInstanceEx().addMacroReplacements(map);
        return map;
    }

    @Override
    public Collection<File> getLibraryClassRoots(@NotNull String name, @NotNull String level) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionContextImpl.getLibraryClassRoots must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/conversion/impl/ConversionContextImpl.getLibraryClassRoots must not be null");
        }
        try {
            Element libraryElement = null;
            if ("project".equals(level)) {
                libraryElement = this.findProjectLibraryElement(name);
            } else if ("application".equals(level)) {
                libraryElement = this.findGlobalLibraryElement(name);
            }
            if (libraryElement != null) {
                return this.getClassRoots(libraryElement, null);
            }
            return Collections.emptyList();
        }
        catch (CannotConvertException e) {
            return Collections.emptyList();
        }
    }

    @NotNull
    public List<File> getClassRoots(Element libraryElement, ModuleSettingsImpl moduleSettings) {
        ArrayList<File> files = new ArrayList<File>();
        Element classesChild = libraryElement.getChild("CLASSES");
        if (classesChild != null) {
            List<Element> roots = JDomConvertingUtil.getChildren(classesChild, "root");
            ExpandMacroToPathMap pathMap = this.createExpandMacroMap(moduleSettings);
            for (Element root : roots) {
                String url = root.getAttributeValue("url");
                String path = VfsUtil.urlToPath((String)url);
                files.add(new File(PathUtil.getLocalPath((String)pathMap.substitute(path, true))));
            }
        }
        ArrayList<File> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/ConversionContextImpl.getClassRoots must not return null");
        }
        return arrayList;
    }

    @Override
    public ComponentManagerSettings getCompilerSettings() {
        if (this.myCompilerManagerSettings == null) {
            this.myCompilerManagerSettings = this.createProjectSettings("compiler.xml");
        }
        return this.myCompilerManagerSettings;
    }

    @Override
    public ComponentManagerSettings getProjectRootManagerSettings() {
        if (this.myProjectRootManagerSettings == null) {
            this.myProjectRootManagerSettings = this.createProjectSettings("misc.xml");
        }
        return this.myProjectRootManagerSettings;
    }

    @Nullable
    private ComponentManagerSettingsImpl createProjectSettings(String fileName) {
        try {
            File file = this.myStorageScheme == StorageScheme.DEFAULT ? this.myProjectFile : new File(this.mySettingsBaseDir, fileName);
            return new ComponentManagerSettingsImpl(file, this);
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    private Element findGlobalLibraryElement(String name) throws CannotConvertException {
        Element root;
        Element libraryTable;
        File file = PathManager.getOptionsFile((String)"applicationLibraries");
        if (file.exists() && (libraryTable = JDomConvertingUtil.findComponent(root = JDomConvertingUtil.loadDocument(file).getRootElement(), "libraryTable")) != null) {
            return this.findLibraryInTable(libraryTable, name);
        }
        return null;
    }

    @Nullable
    private Element findProjectLibraryElement(String name) throws CannotConvertException {
        if (this.myStorageScheme == StorageScheme.DEFAULT) {
            Element tableElement = this.getProjectSettings().getComponentElement("libraryTable");
            if (tableElement != null) {
                return this.findLibraryInTable(tableElement, name);
            }
        } else {
            File libraryFile = new File(new File(this.mySettingsBaseDir, "libraries"), name + ".xml");
            if (libraryFile.exists()) {
                return JDomConvertingUtil.loadDocument(libraryFile).getRootElement().getChild("library");
            }
        }
        return null;
    }

    @Nullable
    private Element findLibraryInTable(Element tableElement, String name) {
        Condition<Element> filter = JDomConvertingUtil.createElementWithAttributeFilter("library", "name", name);
        return JDomConvertingUtil.findChild(tableElement, filter);
    }

    private ExpandMacroToPathMap createExpandMacroMap() {
        ExpandMacroToPathMap macros = new ExpandMacroToPathMap();
        String projectDir = FileUtil.toSystemIndependentName((String)this.myProjectBaseDir.getAbsolutePath());
        macros.addMacroExpand("PROJECT_DIR", projectDir);
        PathMacrosImpl.getInstanceEx().addMacroExpands(macros);
        return macros;
    }

    @Override
    public File getSettingsBaseDir() {
        return this.mySettingsBaseDir;
    }

    @Override
    public File getProjectFile() {
        return this.myProjectFile;
    }

    @Override
    public ProjectSettings getProjectSettings() throws CannotConvertException {
        if (this.myProjectSettings == null) {
            this.myProjectSettings = new ProjectSettingsImpl(this.myProjectFile, this);
        }
        return this.myProjectSettings;
    }

    @Override
    public RunManagerSettingsImpl getRunManagerSettings() throws CannotConvertException {
        if (this.myRunManagerSettings == null) {
            if (this.myStorageScheme == StorageScheme.DEFAULT) {
                this.myRunManagerSettings = new RunManagerSettingsImpl(this.myWorkspaceFile, this.myProjectFile, null, this);
            } else {
                File[] files = new File(this.mySettingsBaseDir, "runConfigurations").listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return !file.isDirectory() && file.getName().endsWith(".xml");
                    }
                });
                this.myRunManagerSettings = new RunManagerSettingsImpl(this.myWorkspaceFile, null, files, this);
            }
        }
        return this.myRunManagerSettings;
    }

    @Override
    public WorkspaceSettings getWorkspaceSettings() throws CannotConvertException {
        if (this.myWorkspaceSettings == null) {
            this.myWorkspaceSettings = new WorkspaceSettingsImpl(this.myWorkspaceFile, this);
        }
        return this.myWorkspaceSettings;
    }

    @Override
    public ModuleSettings getModuleSettings(File moduleFile) throws CannotConvertException {
        ModuleSettingsImpl settings = this.myFile2ModuleSettings.get(moduleFile);
        if (settings == null) {
            settings = new ModuleSettingsImpl(moduleFile, this);
            this.myFile2ModuleSettings.put(moduleFile, settings);
            this.myName2ModuleSettings.put(settings.getModuleName(), settings);
        }
        return settings;
    }

    @Override
    public ModuleSettings getModuleSettings(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/ConversionContextImpl.getModuleSettings must not be null");
        }
        if (!this.myName2ModuleSettings.containsKey(moduleName)) {
            for (File moduleFile : this.myModuleFiles) {
                try {
                    this.getModuleSettings(moduleFile);
                }
                catch (CannotConvertException ignored) {
                    // empty catch block
                }
            }
        }
        return this.myName2ModuleSettings.get(moduleName);
    }

    public List<File> getNonExistingModuleFiles() {
        return this.myNonExistingModuleFiles;
    }

    @Override
    public StorageScheme getStorageScheme() {
        return this.myStorageScheme;
    }

    public File getWorkspaceFile() {
        return this.myWorkspaceFile;
    }

    public void saveFiles(Collection<File> files) throws IOException {
        for (File file : files) {
            SettingsXmlFile xmlFile = this.mySettingsFiles.get(file);
            if (xmlFile == null) continue;
            xmlFile.save();
        }
    }

    public SettingsXmlFile getOrCreateFile(File file) throws CannotConvertException {
        SettingsXmlFile settingsFile = this.mySettingsFiles.get(file);
        if (settingsFile == null) {
            settingsFile = new SettingsXmlFile(file);
            this.mySettingsFiles.put(file, settingsFile);
        }
        return settingsFile;
    }
}

