/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointFactory;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointManagerListener;
import com.intellij.debugger.ui.breakpoints.BreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.BreakpointTable;
import com.intellij.debugger.ui.breakpoints.BreakpointTableModel;
import com.intellij.debugger.ui.breakpoints.BreakpointTree;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.actions.BreakpointPanelAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.AbstractBreakpointPanel;
import gnu.trove.TIntArrayList;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NonNls;

public class BreakpointPanel
extends AbstractBreakpointPanel<Breakpoint> {
    private final BreakpointPropertiesPanel myPropertiesPanel;
    private final BreakpointPanelAction[] myActions;
    private final Key<? extends Breakpoint> myBreakpointCategory;
    private Breakpoint myCurrentViewableBreakpoint;
    private final List<Runnable> myDisposeActions;
    private final Project myProject;
    private JPanel myPanel;
    private JPanel myBreakPointsPanel;
    private JPanel myTablePlace;
    private JPanel myPropertiesPanelPlace;
    private final BreakpointTable myTable;
    private final BreakpointTree myTree;
    private JPanel myButtonsPanel;
    private String myCurrentViewId;
    @NonNls
    private static final String PROPERTIES_STUB = "STUB";
    @NonNls
    private static final String PROPERTIES_DATA = "DATA";
    @NonNls
    public static final String TREE_VIEW = "TREE";
    @NonNls
    public static final String TABLE_VIEW = "TABLE";

    public BreakpointPanel(Project project, BreakpointPropertiesPanel propertiesPanel, BreakpointPanelAction[] actions, Key<? extends Breakpoint> breakpointCategory, String tabName, String helpId) {
        super(tabName, helpId, Breakpoint.class);
        this.$$$setupUI$$$();
        this.myDisposeActions = new ArrayList<Runnable>();
        this.myCurrentViewId = TABLE_VIEW;
        this.myProject = project;
        this.myPropertiesPanel = propertiesPanel;
        this.myActions = actions;
        this.myBreakpointCategory = breakpointCategory;
        this.myTable = new BreakpointTable(project);
        this.myTree = new BreakpointTree(project);
        this.myTablePlace.setLayout(new CardLayout());
        this.myTablePlace.add((Component)ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myTable)), TABLE_VIEW);
        final ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    BreakpointPanel.this.updateCurrentBreakpointPropertiesPanel();
                }
            }
        };
        final ListSelectionModel tableSelectionModel = this.myTable.getSelectionModel();
        tableSelectionModel.addListSelectionListener(listSelectionListener);
        this.myDisposeActions.add(new Runnable(){

            @Override
            public void run() {
                tableSelectionModel.removeListSelectionListener(listSelectionListener);
            }
        });
        final TreeSelectionModel treeSelectionModel = this.myTree.getSelectionModel();
        final TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BreakpointPanel.this.updateCurrentBreakpointPropertiesPanel();
            }
        };
        treeSelectionModel.addTreeSelectionListener(treeSelectionListener);
        this.myDisposeActions.add(new Runnable(){

            @Override
            public void run() {
                treeSelectionModel.removeTreeSelectionListener(treeSelectionListener);
            }
        });
        final BreakpointTableModel tableModel = this.myTable.getModel();
        final TableModelListener tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    BreakpointPanel.this.updateCurrentBreakpointPropertiesPanel();
                }
                BreakpointPanel.this.fireBreakpointsChanged();
            }
        };
        tableModel.addTableModelListener(tableModelListener);
        this.myDisposeActions.add(new Runnable(){

            @Override
            public void run() {
                tableModel.removeTableModelListener(tableModelListener);
            }
        });
        final TreeModel treeModel = this.myTree.getModel();
        final TreeModelListener treeModelListener = new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BreakpointPanel.this.ensureSelectionExists();
                        BreakpointPanel.this.updateButtons();
                    }
                });
            }
        };
        treeModel.addTreeModelListener(treeModelListener);
        this.myDisposeActions.add(new Runnable(){

            @Override
            public void run() {
                treeModel.removeTreeModelListener(treeModelListener);
            }
        });
        this.myPropertiesPanelPlace.setLayout(new CardLayout());
        JPanel stubPanel = new JPanel();
        stubPanel.setMinimumSize(this.myPropertiesPanel.getPanel().getMinimumSize());
        this.myPropertiesPanelPlace.add((Component)stubPanel, PROPERTIES_STUB);
        this.myPropertiesPanelPlace.add((Component)this.myPropertiesPanel.getPanel(), PROPERTIES_DATA);
        this.myBreakPointsPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)6, (int)6, (int)0, (int)6));
        this.myButtonsPanel.setLayout(new GridBagLayout());
        for (int idx = 0; idx < actions.length; ++idx) {
            final BreakpointPanelAction action = actions[idx];
            action.setPanel(this);
            final AbstractButton button = action.isStateAction() ? new JCheckBox(action.getName()) : new JButton(action.getName());
            action.setButton(button);
            button.addActionListener(action);
            this.myDisposeActions.add(new Runnable(){

                @Override
                public void run() {
                    button.removeActionListener(action);
                }
            });
            double weighty = idx == actions.length - 1 ? 1.0 : 0.0;
            this.myButtonsPanel.add((Component)button, new GridBagConstraints(0, -1, 1, 1, 1.0, weighty, 18, 2, new Insets(0, 2, 2, 2), 0, 0));
        }
        final ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BreakpointPanel.this.updateButtons();
            }
        };
        tableSelectionModel.addListSelectionListener(tableSelectionListener);
        this.myDisposeActions.add(new Runnable(){

            @Override
            public void run() {
                tableSelectionModel.removeListSelectionListener(tableSelectionListener);
            }
        });
        this.myTablePlace.add((Component)ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myTree)), TREE_VIEW);
        this.updateCurrentBreakpointPropertiesPanel();
        final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
        final BreakpointManagerListener breakpointManagerListener = new BreakpointManagerListener(){

            @Override
            public void breakpointsChanged() {
                if (BreakpointPanel.this.isTreeShowing()) {
                    BreakpointPanel.this.myTree.repaint();
                } else {
                    BreakpointPanel.this.myTable.repaint();
                }
            }
        };
        breakpointManager.addBreakpointManagerListener(breakpointManagerListener);
        this.myDisposeActions.add(new Runnable(){

            @Override
            public void run() {
                breakpointManager.removeBreakpointManagerListener(breakpointManagerListener);
            }
        });
    }

    public BreakpointTable getTable() {
        return this.myTable;
    }

    public BreakpointTree getTree() {
        return this.myTree;
    }

    public void switchViews() {
        Breakpoint[] selectedBreakpoints = this.getSelectedBreakpoints();
        this.showView(this.isTreeShowing() ? TABLE_VIEW : TREE_VIEW);
        this.selectBreakpoints(selectedBreakpoints);
    }

    public void showView(String viewId) {
        if (TREE_VIEW.equals(viewId) || TABLE_VIEW.equals(viewId)) {
            this.myCurrentViewId = viewId;
            ((CardLayout)this.myTablePlace.getLayout()).show(this.myTablePlace, viewId);
            this.updateButtons();
            this.ensureSelectionExists();
        }
    }

    public String getCurrentViewId() {
        return this.myCurrentViewId;
    }

    public boolean isTreeShowing() {
        return TREE_VIEW.equals(this.getCurrentViewId());
    }

    public void setupPanelUI() {
        String viewId;
        String groupByMethods;
        String groupByClasses;
        BreakpointManager breakpointManager = this.getBreakpointManager();
        Key<? extends Breakpoint> category = this.getBreakpointCategory();
        BreakpointTree tree = this.getTree();
        String flattenPackages = breakpointManager.getProperty(category + "_flattenPackages");
        if (flattenPackages != null) {
            tree.setFlattenPackages("true".equalsIgnoreCase(flattenPackages));
        }
        if ((groupByClasses = breakpointManager.getProperty(category + "_groupByClasses")) != null) {
            tree.setGroupByClasses("true".equalsIgnoreCase(groupByClasses));
        }
        if ((groupByMethods = breakpointManager.getProperty(category + "_groupByMethods")) != null) {
            tree.setGroupByMethods("true".equalsIgnoreCase(groupByMethods));
        }
        if ((viewId = breakpointManager.getProperty(category + "_viewId")) != null) {
            this.showView(viewId);
        }
    }

    public void savePanelSettings() {
        Key<? extends Breakpoint> category = this.getBreakpointCategory();
        BreakpointManager breakpointManager = this.getBreakpointManager();
        BreakpointTree tree = this.getTree();
        breakpointManager.setProperty(category + "_flattenPackages", tree.isFlattenPackages() ? "true" : "false");
        breakpointManager.setProperty(category + "_groupByClasses", tree.isGroupByClasses() ? "true" : "false");
        breakpointManager.setProperty(category + "_groupByMethods", tree.isGroupByMethods() ? "true" : "false");
        breakpointManager.setProperty(category + "_viewId", this.getCurrentViewId());
    }

    protected BreakpointManager getBreakpointManager() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager();
    }

    private boolean hasEnabledBreakpoints() {
        List<Breakpoint> breakpoints = this.getBreakpoints();
        for (Breakpoint breakpoint : breakpoints) {
            if (!breakpoint.ENABLED) continue;
            return true;
        }
        return false;
    }

    @Override
    public Icon getTabIcon() {
        BreakpointFactory factory = BreakpointFactory.getInstance(this.getBreakpointCategory());
        return this.hasEnabledBreakpoints() ? factory.getIcon() : factory.getDisabledIcon();
    }

    @Override
    public boolean canSelectBreakpoint(Breakpoint breakpoint) {
        return breakpoint.getCategory().equals(this.getBreakpointCategory());
    }

    public Key<? extends Breakpoint> getBreakpointCategory() {
        return this.myBreakpointCategory;
    }

    public Breakpoint getCurrentViewableBreakpoint() {
        return this.myCurrentViewableBreakpoint;
    }

    @Override
    public void saveBreakpoints() {
        if (this.myCurrentViewableBreakpoint != null) {
            this.myPropertiesPanel.saveTo(this.myCurrentViewableBreakpoint, new Runnable(){

                @Override
                public void run() {
                    BreakpointPanel.this.myTable.repaint();
                }
            });
        }
    }

    public void updateButtons() {
        for (BreakpointPanelAction action : this.myActions) {
            AbstractButton button = action.getButton();
            action.update();
            if (button.isEnabled() || !button.hasFocus()) continue;
            button.transferFocus();
        }
    }

    @Override
    public JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    public void selectBreakpoint(Breakpoint breakpoint) {
        if (this.isTreeShowing()) {
            this.myTree.selectBreakpoint(breakpoint);
        } else {
            int index = this.myTable.getModel().getBreakpointIndex(breakpoint);
            ListSelectionModel model = this.myTable.getSelectionModel();
            model.clearSelection();
            model.addSelectionInterval(index, index);
        }
    }

    @Override
    public boolean hasBreakpoints() {
        return this.getBreakpointManager().getBreakpoints(this.getBreakpointCategory()).length > 0;
    }

    public void selectBreakpoints(Breakpoint[] breakpoints) {
        if (this.isTreeShowing()) {
            this.myTree.selectBreakpoints(breakpoints);
        } else {
            TIntArrayList rows = new TIntArrayList(breakpoints.length);
            for (Breakpoint breakpoint : breakpoints) {
                int index = this.myTable.getModel().getBreakpointIndex(breakpoint);
                if (index < 0) continue;
                rows.add(index);
            }
            this.myTable.getSelectionModel().clearSelection();
            TableUtil.selectRows((JTable)((Object)this.myTable), (int[])rows.toNativeArray());
        }
    }

    @Override
    public void resetBreakpoints() {
        Breakpoint[] breakpoints = this.getBreakpointManager().getBreakpoints(this.getBreakpointCategory());
        this.myTable.setBreakpoints(breakpoints);
        this.myTree.setBreakpoints(breakpoints);
        this.ensureSelectionExists();
        this.updateButtons();
    }

    public Breakpoint[] getSelectedBreakpoints() {
        return this.isTreeShowing() ? this.myTree.getSelectedBreakpoints() : this.myTable.getSelectedBreakpoints();
    }

    public void removeSelectedBreakpoints() {
        Breakpoint[] selectedBreakpoints = this.getSelectedBreakpoints();
        if (selectedBreakpoints.length == 0) {
            return;
        }
        boolean inTreeMode = this.isTreeShowing();
        int minSelectionIndex = inTreeMode ? Math.max(0, this.myTree.getSelectionModel().getMinSelectionRow()) : Math.max(0, this.myTable.getSelectionModel().getMinSelectionIndex());
        this.myTree.removeBreakpoints(selectedBreakpoints);
        this.myTable.getModel().removeBreakpoints(selectedBreakpoints);
        this.myCurrentViewableBreakpoint = null;
        if (inTreeMode) {
            int rowToSelect;
            TreePath path;
            if (this.myTree.getRowCount() > 0 && (path = this.myTree.getPathForRow(rowToSelect = minSelectionIndex >= this.myTree.getRowCount() ? this.myTree.getRowCount() - 1 : minSelectionIndex)) != null) {
                TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)path, (boolean)true);
            }
        } else if (this.myTable.getRowCount() > 0) {
            int indexToSelect = minSelectionIndex >= this.myTable.getRowCount() ? this.myTable.getRowCount() - 1 : minSelectionIndex;
            TableUtil.selectRows((JTable)((Object)this.myTable), (int[])new int[]{indexToSelect});
        }
        this.updateCurrentBreakpointPropertiesPanel();
    }

    public void insertBreakpointAt(Breakpoint breakpoint, int index) {
        this.myTable.getModel().insertBreakpointAt(breakpoint, index);
        this.myTree.addBreakpoint(breakpoint);
        this.selectBreakpoint(breakpoint);
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        this.myTable.getModel().addBreakpoint(breakpoint);
        this.myTree.addBreakpoint(breakpoint);
        this.selectBreakpoint(breakpoint);
    }

    private void updateCurrentBreakpointPropertiesPanel() {
        if (this.myCurrentViewableBreakpoint != null) {
            this.myPropertiesPanel.saveTo(this.myCurrentViewableBreakpoint, new Runnable(){

                @Override
                public void run() {
                    if (BreakpointPanel.this.isTreeShowing()) {
                        BreakpointPanel.this.myTree.repaint();
                    } else {
                        BreakpointPanel.this.myTable.repaint();
                    }
                }
            });
        }
        Breakpoint[] breakpoints = this.getSelectedBreakpoints();
        Breakpoint oldViewableBreakpoint = this.myCurrentViewableBreakpoint;
        Breakpoint breakpoint = this.myCurrentViewableBreakpoint = breakpoints != null && breakpoints.length == 1 ? breakpoints[0] : null;
        if (this.myCurrentViewableBreakpoint != null) {
            if (oldViewableBreakpoint == null) {
                ((CardLayout)this.myPropertiesPanelPlace.getLayout()).show(this.myPropertiesPanelPlace, PROPERTIES_DATA);
            }
            this.myPropertiesPanel.initFrom(this.myCurrentViewableBreakpoint);
        } else {
            ((CardLayout)this.myPropertiesPanelPlace.getLayout()).show(this.myPropertiesPanelPlace, PROPERTIES_STUB);
        }
        this.updateButtons();
    }

    public JComponent getControl(String control) {
        return this.myPropertiesPanel.getControl(control);
    }

    public int getBreakpointCount() {
        return this.myTable.getBreakpoints().size();
    }

    public final List<Breakpoint> getBreakpoints() {
        return this.myTable.getBreakpoints();
    }

    @Override
    public void dispose() {
        KeyStroke[] tableStrokes;
        this.savePanelSettings();
        for (Runnable runnable : this.myDisposeActions) {
            runnable.run();
        }
        this.myDisposeActions.clear();
        this.myTree.dispose();
        for (KeyStroke stroke : tableStrokes = this.myTable.getRegisteredKeyStrokes()) {
            this.myTable.unregisterKeyboardAction(stroke);
        }
        this.myPropertiesPanel.dispose();
    }

    public OpenFileDescriptor createEditSourceDescriptor(Project project) {
        VirtualFile vFile;
        PsiField field;
        Breakpoint[] breakpoints = this.getSelectedBreakpoints();
        if (breakpoints == null || breakpoints.length == 0) {
            return null;
        }
        Breakpoint br = breakpoints[0];
        if (!(br instanceof BreakpointWithHighlighter)) {
            return null;
        }
        BreakpointWithHighlighter breakpoint = (BreakpointWithHighlighter)br;
        Document doc = breakpoint.getDocument();
        int line = breakpoint.getLineIndex();
        if (line < 0 || line >= doc.getLineCount()) {
            return null;
        }
        int offset = doc.getLineStartOffset(line);
        if (br instanceof FieldBreakpoint && (field = ((FieldBreakpoint)br).getPsiField()) != null) {
            offset = field.getTextOffset();
        }
        if ((vFile = FileDocumentManager.getInstance().getFile(doc)) == null || !vFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(project, vFile, offset);
    }

    @Override
    public void ensureSelectionExists() {
        List<Breakpoint> treeBreakpoints;
        if (this.myTable.getRowCount() > 0 && this.myTable.getSelectedRow() < 0) {
            ListSelectionModel model = this.myTable.getSelectionModel();
            model.clearSelection();
            model.addSelectionInterval(0, 0);
        }
        if ((treeBreakpoints = this.myTree.getBreakpoints()).size() > 0 && this.myTree.getSelectionModel().getSelectionCount() == 0) {
            this.myTree.selectFirstBreakpoint();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BreakpointPanel.this.isTreeShowing()) {
                    BreakpointPanel.this.myTree.requestFocus();
                } else {
                    BreakpointPanel.this.myTable.requestFocus();
                }
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myBreakPointsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 5, 5, 5), 7, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTablePlace = jPanel3 = new JPanel();
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myButtonsPanel = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPropertiesPanelPlace = jPanel = new JPanel();
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

