/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.WatchpointRequest;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FieldBreakpoint
extends BreakpointWithHighlighter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.FieldBreakpoint");
    public boolean WATCH_MODIFICATION;
    public boolean WATCH_ACCESS;
    private boolean myIsStatic;
    private String myFieldName;
    public static Icon ICON = IconLoader.getIcon((String)"/debugger/db_field_breakpoint.png");
    public static Icon MUTED_ICON = IconLoader.getIcon((String)"/debugger/db_muted_field_breakpoint.png");
    public static Icon DISABLED_ICON = IconLoader.getIcon((String)"/debugger/db_disabled_field_breakpoint.png");
    public static Icon DISABLED_DEP_ICON = IconLoader.getIcon((String)"/debugger/db_dep_field_breakpoint.png");
    public static Icon MUTED_DISABLED_ICON = IconLoader.getIcon((String)"/debugger/db_muted_disabled_field_breakpoint.png");
    public static Icon MUTED_DISABLED_DEP_ICON = IconLoader.getIcon((String)"/debugger/db_muted_dep_field_breakpoint.png");
    private static final Icon ourInvalidIcon = IconLoader.getIcon((String)"/debugger/db_invalid_field_breakpoint.png");
    private static final Icon ourMutedInvalidIcon = IconLoader.getIcon((String)"/debugger/db_muted_invalid_field_breakpoint.png");
    private static final Icon ourVerifiedIcon = IconLoader.getIcon((String)"/debugger/db_verified_field_breakpoint.png");
    private static final Icon ourMutedVerifiedIcon = IconLoader.getIcon((String)"/debugger/db_muted_verified_field_breakpoint.png");
    private static final Icon ourVerifiedWarningIcon = IconLoader.getIcon((String)"/debugger/db_field_warning_breakpoint.png");
    private static final Icon ourMutedVerifiedWarningIcon = IconLoader.getIcon((String)"/debugger/db_muted_field_warning_breakpoint.png");
    @NonNls
    public static final Key<FieldBreakpoint> CATEGORY = BreakpointCategory.lookup("field_breakpoints");

    protected FieldBreakpoint(Project project) {
        super(project);
        this.WATCH_MODIFICATION = true;
        this.WATCH_ACCESS = false;
    }

    private FieldBreakpoint(Project project, RangeHighlighter highlighter, @NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/debugger/ui/breakpoints/FieldBreakpoint.<init> must not be null");
        }
        super(project, highlighter);
        this.WATCH_MODIFICATION = true;
        this.WATCH_ACCESS = false;
        this.myFieldName = fieldName;
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    public String getFieldName() {
        return this.myFieldName;
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (isMuted) {
            return master == null ? MUTED_DISABLED_ICON : MUTED_DISABLED_DEP_ICON;
        }
        return master == null ? DISABLED_ICON : DISABLED_DEP_ICON;
    }

    @Override
    protected Icon getSetIcon(boolean isMuted) {
        return isMuted ? MUTED_ICON : ICON;
    }

    @Override
    protected Icon getInvalidIcon(boolean isMuted) {
        return isMuted ? ourMutedInvalidIcon : ourInvalidIcon;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return isMuted ? ourMutedVerifiedIcon : ourVerifiedIcon;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return isMuted ? ourMutedVerifiedWarningIcon : ourVerifiedWarningIcon;
    }

    public Key<FieldBreakpoint> getCategory() {
        return CATEGORY;
    }

    public PsiField getPsiField() {
        final SourcePosition sourcePosition = this.getSourcePosition();
        PsiField field = (PsiField)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiField>(){

            public PsiField compute() {
                PsiClass psiClass = BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
                return psiClass != null ? psiClass.findFieldByName(FieldBreakpoint.this.myFieldName, true) : null;
            }
        });
        if (field != null) {
            return field;
        }
        return PositionUtil.getPsiElementAt(this.getProject(), PsiField.class, sourcePosition);
    }

    @Override
    protected void reload(PsiFile psiFile) {
        super.reload(psiFile);
        PsiField field = PositionUtil.getPsiElementAt(this.getProject(), PsiField.class, this.getSourcePosition());
        if (field != null) {
            this.myFieldName = field.getName();
            this.myIsStatic = field.hasModifierProperty("static");
        }
        if (this.myIsStatic) {
            this.INSTANCE_FILTERS_ENABLED = false;
        }
    }

    @Override
    public boolean moveTo(SourcePosition position) {
        PsiField field = PositionUtil.getPsiElementAt(this.getProject(), PsiField.class, position);
        return field != null && super.moveTo(SourcePosition.createFromElement((PsiElement)field));
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        AccessWatchpointEvent accessEvent;
        ObjectReference reference;
        if (event instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent modificationEvent = (ModificationWatchpointEvent)event;
            ObjectReference reference2 = modificationEvent.object();
            if (reference2 != null) {
                return reference2;
            }
        } else if (event instanceof AccessWatchpointEvent && (reference = (accessEvent = (AccessWatchpointEvent)event).object()) != null) {
            return reference;
        }
        return super.getThisObject(context, event);
    }

    @Override
    public void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType refType) {
        VirtualMachineProxyImpl vm = debugProcess.getVirtualMachineProxy();
        try {
            WatchpointRequest request;
            Field field = refType.fieldByName(this.myFieldName);
            if (field == null) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.missing.field.in.class", (Object[])new Object[]{this.myFieldName, refType.name()}));
                return;
            }
            RequestManagerImpl manager = debugProcess.getRequestsManager();
            if (this.WATCH_MODIFICATION && vm.canWatchFieldModification()) {
                request = manager.createModificationWatchpointRequest(this, field);
                debugProcess.getRequestsManager().enableRequest(request);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Modification request added");
                }
            }
            if (this.WATCH_ACCESS && vm.canWatchFieldAccess()) {
                request = manager.createAccessWatchpointRequest(this, field);
                debugProcess.getRequestsManager().enableRequest(request);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Access request added field = " + field.name() + "; refType = " + refType.name());
                }
            }
        }
        catch (ObjectCollectedException ex) {
            LOG.debug((Throwable)ex);
        }
        catch (Exception ex) {
            LOG.debug((Throwable)ex);
        }
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        Location location = event.location();
        String locationQName = location.declaringType().name() + "." + location.method().name();
        String locationFileName = "";
        try {
            locationFileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            locationFileName = this.getSourcePosition().getFile().getName();
        }
        int locationLine = location.lineNumber();
        if (event instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent modificationEvent = (ModificationWatchpointEvent)event;
            ObjectReference object = modificationEvent.object();
            Field field = modificationEvent.field();
            if (object != null) {
                return DebuggerBundle.message((String)"status.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationEvent.valueCurrent(), modificationEvent.valueToBe(), locationQName, locationFileName, locationLine, object.uniqueID()});
            }
            return DebuggerBundle.message((String)"status.static.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationEvent.valueCurrent(), modificationEvent.valueToBe(), locationQName, locationFileName, locationLine});
        }
        if (event instanceof AccessWatchpointEvent) {
            AccessWatchpointEvent accessEvent = (AccessWatchpointEvent)event;
            ObjectReference object = accessEvent.object();
            Field field = accessEvent.field();
            if (object != null) {
                return DebuggerBundle.message((String)"status.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), locationQName, locationFileName, locationLine, object.uniqueID()});
            }
            return DebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), locationQName, locationFileName, locationLine});
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        String className = this.getClassName();
        return className != null && className.length() > 0 ? className + "." + this.myFieldName : this.myFieldName;
    }

    public static FieldBreakpoint create(Project project, Document document, int lineIndex, String fieldName) {
        FieldBreakpoint breakpoint = new FieldBreakpoint(project, FieldBreakpoint.createHighlighter(project, document, lineIndex), fieldName);
        return (FieldBreakpoint)breakpoint.init();
    }

    @Override
    public boolean canMoveTo(SourcePosition position) {
        return super.canMoveTo(position) && PositionUtil.getPsiElementAt(this.getProject(), PsiField.class, position) != null;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getPsiField() != null;
    }

    @Override
    public boolean isAt(Document document, int offset) {
        PsiField field = FieldBreakpoint.findField(this.myProject, document, offset);
        return field == this.getPsiField();
    }

    protected static FieldBreakpoint create(Project project, Field field, ObjectReference object) {
        String fieldName = field.name();
        int line = 0;
        Document document = null;
        try {
            List<Location> locations = field.declaringType().allLineLocations();
            if (!locations.isEmpty()) {
                PsiFile psiFile;
                Location location = locations.get(0);
                line = location.lineNumber();
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(location.sourcePath());
                if (file != null && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null) {
                    document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                }
            }
        }
        catch (AbsentInformationException e) {
            LOG.debug((Throwable)e);
        }
        catch (InternalError e) {
            LOG.debug((Throwable)e);
        }
        if (document == null) {
            return null;
        }
        FieldBreakpoint fieldBreakpoint = new FieldBreakpoint(project, FieldBreakpoint.createHighlighter(project, document, line), fieldName);
        if (!fieldBreakpoint.isStatic()) {
            fieldBreakpoint.addInstanceFilter(object.uniqueID());
        }
        return (FieldBreakpoint)fieldBreakpoint.init();
    }

    public static PsiField findField(Project project, Document document, int offset) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
        int line = document.getLineNumber(offset);
        if (field == null) {
            final PsiField[] fld = new PsiField[]{null};
            XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)new Processor<PsiElement>(){

                public boolean process(PsiElement element) {
                    PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
                    if (field != null) {
                        fld[0] = field;
                        return false;
                    }
                    return true;
                }
            });
            field = fld[0];
        }
        return field;
    }

    @Override
    public void readExternal(Element breakpointNode) throws InvalidDataException {
        super.readExternal(breakpointNode);
        this.myFieldName = breakpointNode.getAttributeValue("field_name");
        if (this.myFieldName == null) {
            throw new InvalidDataException("No field name for field breakpoint");
        }
    }

    @Override
    public void writeExternal(Element parentNode) throws WriteExternalException {
        super.writeExternal(parentNode);
        parentNode.setAttribute("field_name", this.getFieldName());
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }
}

