/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class FilteredRequestor
implements LocatableEventRequestor,
JDOMExternalizable {
    public String SUSPEND_POLICY = "SuspendAll";
    public boolean COUNT_FILTER_ENABLED = false;
    public int COUNT_FILTER = 0;
    public boolean CONDITION_ENABLED = false;
    private TextWithImports myCondition;
    public boolean CLASS_FILTERS_ENABLED = false;
    private ClassFilter[] myClassFilters = ClassFilter.EMPTY_ARRAY;
    private ClassFilter[] myClassExclusionFilters = ClassFilter.EMPTY_ARRAY;
    public boolean INSTANCE_FILTERS_ENABLED = false;
    private InstanceFilter[] myInstanceFilters = InstanceFilter.EMPTY_ARRAY;
    @NonNls
    private static final String FILTER_OPTION_NAME = "filter";
    @NonNls
    private static final String EXCLUSION_FILTER_OPTION_NAME = "exclusion_filter";
    @NonNls
    private static final String INSTANCE_ID_OPTION_NAME = "instance_id";
    @NonNls
    private static final String CONDITION_OPTION_NAME = "CONDITION";
    protected final Project myProject;

    public FilteredRequestor(Project project) {
        this.myProject = project;
        this.myCondition = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
    }

    public InstanceFilter[] getInstanceFilters() {
        return this.myInstanceFilters;
    }

    public void setInstanceFilters(InstanceFilter[] instanceFilters) {
        this.myInstanceFilters = instanceFilters != null ? instanceFilters : InstanceFilter.EMPTY_ARRAY;
    }

    @Override
    public String getSuspendPolicy() {
        return this.SUSPEND_POLICY;
    }

    private boolean hasObjectID(long id) {
        for (InstanceFilter instanceFilter : this.myInstanceFilters) {
            if (instanceFilter.getId() != id) continue;
            return true;
        }
        return false;
    }

    protected void addInstanceFilter(long l) {
        InstanceFilter[] filters = new InstanceFilter[this.myInstanceFilters.length + 1];
        System.arraycopy(this.myInstanceFilters, 0, filters, 0, this.myInstanceFilters.length);
        filters[this.myInstanceFilters.length] = InstanceFilter.create(String.valueOf(l));
        this.myInstanceFilters = filters;
    }

    public final ClassFilter[] getClassFilters() {
        return this.myClassFilters;
    }

    public final void setClassFilters(ClassFilter[] classFilters) {
        this.myClassFilters = classFilters != null ? classFilters : ClassFilter.EMPTY_ARRAY;
    }

    public ClassFilter[] getClassExclusionFilters() {
        return this.myClassExclusionFilters;
    }

    public void setClassExclusionFilters(ClassFilter[] classExclusionFilters) {
        this.myClassExclusionFilters = classExclusionFilters != null ? classExclusionFilters : ClassFilter.EMPTY_ARRAY;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)parentNode);
        String condition = JDOMExternalizerUtil.readField((Element)parentNode, (String)CONDITION_OPTION_NAME);
        if (condition != null) {
            this.setCondition(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, condition));
        }
        this.myClassFilters = DebuggerUtilsEx.readFilters(parentNode.getChildren(FILTER_OPTION_NAME));
        this.myClassExclusionFilters = DebuggerUtilsEx.readFilters(parentNode.getChildren(EXCLUSION_FILTER_OPTION_NAME));
        ClassFilter[] instanceFilters = DebuggerUtilsEx.readFilters(parentNode.getChildren(INSTANCE_ID_OPTION_NAME));
        ArrayList<InstanceFilter> iFilters = new ArrayList<InstanceFilter>(instanceFilters.length);
        for (ClassFilter instanceFilter : instanceFilters) {
            try {
                iFilters.add(InstanceFilter.create(instanceFilter));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.myInstanceFilters = iFilters.isEmpty() ? InstanceFilter.EMPTY_ARRAY : iFilters.toArray(new InstanceFilter[iFilters.size()]);
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)parentNode);
        JDOMExternalizerUtil.writeField((Element)parentNode, (String)CONDITION_OPTION_NAME, (String)this.getCondition().toString());
        DebuggerUtilsEx.writeFilters(parentNode, FILTER_OPTION_NAME, this.myClassFilters);
        DebuggerUtilsEx.writeFilters(parentNode, EXCLUSION_FILTER_OPTION_NAME, this.myClassExclusionFilters);
        DebuggerUtilsEx.writeFilters(parentNode, INSTANCE_ID_OPTION_NAME, InstanceFilter.createClassFilters(this.myInstanceFilters));
    }

    public boolean evaluateCondition(final EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        ObjectReference reference;
        Value value;
        if (this.COUNT_FILTER_ENABLED) {
            context.getDebugProcess().getVirtualMachineProxy().suspend();
            context.getDebugProcess().getRequestsManager().deleteRequest(this);
            ((Breakpoint)this).createRequest(context.getDebugProcess());
            context.getDebugProcess().getVirtualMachineProxy().resume();
        }
        if (this.INSTANCE_FILTERS_ENABLED && (value = context.getThisObject()) != null && !this.hasObjectID((reference = (ObjectReference)value).uniqueID())) {
            return false;
        }
        if (this.CONDITION_ENABLED && this.getCondition() != null && !"".equals(this.getCondition().getText())) {
            try {
                ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(context.getProject(), new EvaluatingComputable<ExpressionEvaluator>(){

                    @Override
                    public ExpressionEvaluator compute() throws EvaluateException {
                        return EvaluatorBuilderImpl.getInstance().build(FilteredRequestor.this.getCondition(), FilteredRequestor.this.getEvaluationElement(), ContextUtil.getSourcePosition((StackFrameContext)context));
                    }
                });
                Value value2 = evaluator.evaluate(context);
                if (!(value2 instanceof BooleanValue)) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
                }
                if (!((BooleanValue)value2).booleanValue()) {
                    return false;
                }
            }
            catch (EvaluateException ex) {
                if (ex.getCause() instanceof VMDisconnectedException) {
                    return false;
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.failed.evaluating.breakpoint.condition", (Object[])new Object[]{this.getCondition(), ex.getMessage()}));
            }
            return true;
        }
        return true;
    }

    public abstract PsiElement getEvaluationElement();

    public TextWithImports getCondition() {
        return this.myCondition;
    }

    public void setCondition(TextWithImports condition) {
        this.myCondition = condition;
    }

    public Project getProject() {
        return this.myProject;
    }
}

