/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.AddToWatchActionHandler;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.WatchPanel;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeInplaceEditor;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DropActionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ListenerUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class MainWatchPanel
extends WatchPanel
implements DataProvider {
    private final KeyStroke myRemoveWatchAccelerator = KeyStroke.getKeyStroke(127, 0);
    private final KeyStroke myNewWatchAccelerator = KeyStroke.getKeyStroke(155, 0);
    private final KeyStroke myEditWatchAccelerator = KeyStroke.getKeyStroke(113, 0);

    public MainWatchPanel(Project project, DebuggerStateManager stateManager) {
        super(project, stateManager);
        final WatchDebuggerTree watchTree = this.getWatchTree();
        final AnAction removeWatchesAction = ActionManager.getInstance().getAction("Debugger.RemoveWatch");
        removeWatchesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(this.myRemoveWatchAccelerator), (JComponent)((Object)watchTree));
        final AnAction newWatchAction = ActionManager.getInstance().getAction("Debugger.NewWatch");
        newWatchAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(this.myNewWatchAccelerator), (JComponent)((Object)watchTree));
        final MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    AnAction editWatchAction = ActionManager.getInstance().getAction("Debugger.EditWatch");
                    Presentation presentation = (Presentation)editWatchAction.getTemplatePresentation().clone();
                    DataContext context = DataManager.getInstance().getDataContext((Component)((Object)watchTree));
                    AnActionEvent actionEvent = new AnActionEvent(null, context, "WATCH_TREE", presentation, ActionManager.getInstance(), 0);
                    editWatchAction.actionPerformed(actionEvent);
                }
            }
        };
        ListenerUtil.addMouseListener((Component)((Object)watchTree), mouseListener);
        final AnAction editWatchAction = ActionManager.getInstance().getAction("Debugger.EditWatch");
        editWatchAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(this.myEditWatchAccelerator), (JComponent)((Object)watchTree));
        this.registerDisposable(new Disposable(){

            public void dispose() {
                ListenerUtil.removeMouseListener((Component)((Object)watchTree), mouseListener);
                removeWatchesAction.unregisterCustomShortcutSet((JComponent)((Object)watchTree));
                newWatchAction.unregisterCustomShortcutSet((JComponent)((Object)watchTree));
                editWatchAction.unregisterCustomShortcutSet((JComponent)((Object)watchTree));
            }
        });
        DnDManager.getInstance().registerTarget((DnDTarget)new DnDNativeTarget(){

            public boolean update(DnDEvent aEvent) {
                DnDNativeTarget.EventInfo info;
                String text;
                Object object = aEvent.getAttachedObject();
                if (object == null) {
                    return true;
                }
                String add = DebuggerBundle.message((String)"watchs.add.text", (Object[])new Object[0]);
                if (object.getClass().isArray()) {
                    Class<?> type = object.getClass().getComponentType();
                    if (DebuggerTreeNodeImpl.class.isAssignableFrom(type)) {
                        aEvent.setHighlighting((Component)((Object)MainWatchPanel.this.myTree), 17);
                        aEvent.setDropPossible(add, new DropActionHandler(){

                            public void performDrop(DnDEvent aEvent) {
                                MainWatchPanel.this.addWatchesFrom((DebuggerTreeNodeImpl[])aEvent.getAttachedObject());
                            }
                        });
                    }
                } else if (object instanceof DnDNativeTarget.EventInfo && (text = (info = (DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
                    aEvent.setHighlighting((Component)((Object)MainWatchPanel.this.myTree), 17);
                    aEvent.setDropPossible(add, new DropActionHandler(){

                        public void performDrop(DnDEvent aEvent) {
                            MainWatchPanel.this.addWatchesFrom(text);
                        }
                    });
                }
                return true;
            }

            public void drop(DnDEvent aEvent) {
            }

            public void cleanUpOnLeave() {
            }

            public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
            }
        }, (JComponent)((Object)this.myTree));
    }

    private void addWatchesFrom(DebuggerTreeNodeImpl[] nodes) {
        AddToWatchActionHandler.addFromNodes(this.getContext(), this, nodes);
    }

    private void addWatchesFrom(String text) {
        AddToWatchActionHandler.doAddWatch(this, new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text), null);
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Debugger.WatchesPanelPopup");
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("Debugger.WatchesPanelPopup", group);
        return popupMenu;
    }

    public void newWatch() {
        DebuggerTreeNodeImpl node = this.getWatchTree().addWatch(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, ""));
        this.editNode(node);
    }

    public void editNode(final DebuggerTreeNodeImpl node) {
        DebuggerContextImpl context = this.getContext();
        final DebuggerExpressionComboBox comboBox = new DebuggerExpressionComboBox(this.getProject(), PositionUtil.getContextElement((StackFrameContext)context), "evaluation", DefaultCodeFragmentFactory.getInstance());
        comboBox.setText(((WatchItemDescriptor)node.getDescriptor()).getEvaluationText());
        comboBox.selectAll();
        DebuggerTreeInplaceEditor editor = new DebuggerTreeInplaceEditor(node){

            @Override
            public JComponent createInplaceEditorComponent() {
                return comboBox;
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                return comboBox.getPreferredFocusedComponent();
            }

            @Override
            public Editor getEditor() {
                return comboBox.getEditor();
            }

            @Override
            public JComponent getEditorComponent() {
                return comboBox.getEditorComponent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doOKAction() {
                TextWithImports text = comboBox.getText();
                WatchDebuggerTree.setWatchNodeText(node, text);
                comboBox.addRecent(text);
                try {
                    super.doOKAction();
                }
                finally {
                    comboBox.dispose();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelEditing() {
                try {
                    super.cancelEditing();
                }
                finally {
                    comboBox.dispose();
                }
            }
        };
        editor.show();
    }
}

