/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueMarkup;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidStackFrameException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class NodeDescriptorImpl
implements NodeDescriptor {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl");
    public static final String UNKNOWN_VALUE_MESSAGE = "";
    public boolean myIsExpanded = false;
    public boolean myIsSelected = false;
    public boolean myIsVisible = false;
    public boolean myIsSynthetic = false;
    private EvaluateException myEvaluateException;
    private String myLabel = "";
    private HashMap<Key, Object> myUserData;
    private final List<NodeDescriptorImpl> myChildren = new ArrayList<NodeDescriptorImpl>();
    private static final Key<Map<Long, ValueMarkup>> MARKUP_MAP_KEY = new Key("ValueMarkupMap");

    @Override
    public String getName() {
        return null;
    }

    @Override
    public <T> T getUserData(Key<T> key) {
        if (this.myUserData == null) {
            return null;
        }
        return (T)this.myUserData.get(key);
    }

    @Override
    public <T> void putUserData(Key<T> key, T value) {
        if (this.myUserData == null) {
            this.myUserData = new HashMap();
        }
        this.myUserData.put(key, value);
    }

    public void updateRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        this.updateRepresentationNoNotify(context, labelListener);
        labelListener.labelChanged();
    }

    protected void updateRepresentationNoNotify(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        try {
            try {
                this.myEvaluateException = null;
                this.myLabel = this.calcRepresentation(context, labelListener);
            }
            catch (RuntimeException e) {
                LOG.debug((Throwable)e);
                throw this.processException(e);
            }
        }
        catch (EvaluateException e) {
            this.setFailed(e);
        }
    }

    protected abstract String calcRepresentation(EvaluationContextImpl var1, DescriptorLabelListener var2) throws EvaluateException;

    private EvaluateException processException(Exception e) {
        if (e instanceof InconsistentDebugInfoException) {
            return new EvaluateException(DebuggerBundle.message((String)"error.inconsistent.debug.info", (Object[])new Object[0]), null);
        }
        if (e instanceof InvalidStackFrameException) {
            return new EvaluateException(DebuggerBundle.message((String)"error.invalid.stackframe", (Object[])new Object[0]), null);
        }
        return EvaluateExceptionUtil.DEBUG_INFO_UNAVAILABLE;
    }

    @Override
    public void displayAs(NodeDescriptor descriptor) {
        if (descriptor instanceof NodeDescriptorImpl) {
            NodeDescriptorImpl that = (NodeDescriptorImpl)descriptor;
            this.myIsExpanded = that.myIsExpanded;
            this.myIsSelected = that.myIsSelected;
            this.myIsVisible = that.myIsVisible;
            this.myUserData = that.myUserData != null ? new HashMap(that.myUserData) : null;
        }
    }

    public abstract boolean isExpandable();

    public abstract void setContext(EvaluationContextImpl var1);

    public EvaluateException getEvaluateException() {
        return this.myEvaluateException;
    }

    @Override
    public String getLabel() {
        return this.myLabel;
    }

    public String toString() {
        return this.getLabel();
    }

    protected String setFailed(EvaluateException e) {
        this.myEvaluateException = e;
        return e.getMessage();
    }

    protected String setLabel(String customLabel) {
        this.myLabel = customLabel;
        return this.myLabel;
    }

    public void clear() {
        this.myEvaluateException = null;
        this.myLabel = UNKNOWN_VALUE_MESSAGE;
    }

    public List<NodeDescriptorImpl> getChildren() {
        return this.myChildren;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        this.displayAs(oldDescriptor);
    }

    @Nullable
    public static Map<Long, ValueMarkup> getMarkupMap(DebugProcess process) {
        if (process == null) {
            return null;
        }
        java.util.HashMap map = (java.util.HashMap)process.getUserData(MARKUP_MAP_KEY);
        if (map == null) {
            map = new java.util.HashMap();
            process.putUserData(MARKUP_MAP_KEY, map);
        }
        return map;
    }
}

