/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class DialogAppender
extends AppenderSkeleton {
    private static final DefaultIdeaErrorLogger DEFAULT_LOGGER = new DefaultIdeaErrorLogger();
    private Runnable myDialogRunnable = null;

    protected synchronized void append(final LoggingEvent event) {
        if (!event.level.isGreaterOrEqual(Priority.ERROR)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<Object> loggers = new ArrayList<Object>();
                loggers.add(DEFAULT_LOGGER);
                Application application = ApplicationManager.getApplication();
                if (application != null) {
                    if (application.isHeadlessEnvironment() || application.isDisposed()) {
                        return;
                    }
                    loggers.addAll(Arrays.asList(application.getComponents(ErrorLogger.class)));
                }
                DialogAppender.this.appendToLoggers(event, loggers.toArray(new ErrorLogger[loggers.size()]));
            }
        });
    }

    void appendToLoggers(LoggingEvent event, ErrorLogger[] errorLoggers) {
        if (this.myDialogRunnable != null) {
            return;
        }
        ThrowableInformation throwable = event.getThrowableInformation();
        if (throwable == null) {
            return;
        }
        Object message = event.getMessage();
        final IdeaLoggingEvent ideaEvent = new IdeaLoggingEvent(message == null ? "<null> " : message.toString(), throwable.getThrowable());
        for (int i = errorLoggers.length - 1; i >= 0; --i) {
            final ErrorLogger logger = errorLoggers[i];
            if (!logger.canHandle(ideaEvent)) continue;
            this.myDialogRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        logger.handle(ideaEvent);
                    }
                    finally {
                        DialogAppender.this.myDialogRunnable = null;
                    }
                }
            };
            Application app = ApplicationManager.getApplication();
            if (app == null) {
                new Thread(this.myDialogRunnable).start();
                break;
            }
            app.executeOnPooledThread(this.myDialogRunnable);
            break;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }
}

