/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.EAPSendErrorDialog;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.errorreport.ErrorReportSender;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.bean.NotifierBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NewBuildException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.net.IOExceptionDialog;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;

public class ITNReporter
extends ErrorReportSubmitter {
    private static int previousExceptionThreadId = 0;
    private static boolean wasException = false;
    @NonNls
    private static final String URL_HEADER = "http://www.intellij.net/tracker/idea/viewSCR?publicId=";

    public String getReportActionText() {
        return DiagnosticBundle.message("error.report.to.jetbrains.action", new Object[0]);
    }

    public SubmittedReportInfo submit(IdeaLoggingEvent[] events, Component parentComponent) {
        return ITNReporter.sendError(events[0], parentComponent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SubmittedReportInfo sendError(IdeaLoggingEvent event, Component parentComponent) {
        NotifierBean notifierBean = new NotifierBean();
        ErrorBean errorBean = new ErrorBean();
        errorBean.autoInit();
        errorBean.setLastAction(IdeaLogger.ourLastActionId);
        int threadId = 0;
        SubmittedReportInfo.SubmissionStatus submissionStatus = SubmittedReportInfo.SubmissionStatus.FAILED;
        DataContext dataContext = DataManager.getInstance().getDataContext(parentComponent);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        String description = "";
        while (true) {
            try {
                IdeaPluginDescriptor ideaPluginDescriptor;
                PluginId pluginId;
                Throwable t;
                ErrorReportSender sender = ErrorReportSender.getInstance();
                sender.prepareError(project, event.getThrowable());
                EAPSendErrorDialog dlg = new EAPSendErrorDialog();
                dlg.setErrorDescription(description);
                dlg.show();
                String itnLogin = ErrorReportConfigurable.getInstance().ITN_LOGIN;
                String itnPassword = ErrorReportConfigurable.getInstance().getPlainItnPassword();
                if (itnLogin.trim().length() == 0 && itnPassword.trim().length() == 0) {
                    itnLogin = "idea_anonymous";
                    itnPassword = "guest";
                }
                notifierBean.setItnLogin(itnLogin);
                notifierBean.setItnPassword(itnPassword);
                description = dlg.getErrorDescription();
                String message = event.getMessage();
                StringBuilder descBuilder = new StringBuilder();
                if (description.length() > 0) {
                    descBuilder.append("User description: ").append(description).append("\n");
                }
                if (message != null) {
                    descBuilder.append("Error message: ").append(message).append("\n");
                }
                if ((t = event.getThrowable()) != null && (pluginId = IdeErrorsDialog.findPluginId(t)) != null && (ideaPluginDescriptor = ApplicationManager.getApplication().getPlugin(pluginId)) != null && !ideaPluginDescriptor.isBundled()) {
                    descBuilder.append("Plugin ").append(ideaPluginDescriptor.getName()).append(" version: ").append(ideaPluginDescriptor.getVersion()).append("\n");
                }
                if (previousExceptionThreadId != 0) {
                    descBuilder.append("Previous exception is: ").append(URL_HEADER).append(previousExceptionThreadId).append("\n");
                }
                if (wasException) {
                    descBuilder.append("There was at least one exception before this one.\n");
                }
                errorBean.setDescription(descBuilder.toString());
                if (!dlg.isShouldSend()) return new SubmittedReportInfo(submissionStatus != SubmittedReportInfo.SubmissionStatus.FAILED ? URL_HEADER + threadId : null, String.valueOf(threadId), submissionStatus);
                previousExceptionThreadId = threadId = sender.sendError(notifierBean, errorBean);
                wasException = true;
                submissionStatus = SubmittedReportInfo.SubmissionStatus.NEW_ISSUE;
                Messages.showInfoMessage((Component)parentComponent, (String)DiagnosticBundle.message("error.report.confirmation", new Object[0]), (String)ReportMessages.ERROR_REPORT);
                return new SubmittedReportInfo(submissionStatus != SubmittedReportInfo.SubmissionStatus.FAILED ? URL_HEADER + threadId : null, String.valueOf(threadId), submissionStatus);
            }
            catch (NoSuchEAPUserException e) {
                if (Messages.showYesNoDialog((Component)parentComponent, (String)DiagnosticBundle.message("error.report.authentication.failed", new Object[0]), (String)ReportMessages.ERROR_REPORT, (Icon)Messages.getErrorIcon()) == 0) continue;
                return new SubmittedReportInfo(submissionStatus != SubmittedReportInfo.SubmissionStatus.FAILED ? URL_HEADER + threadId : null, String.valueOf(threadId), submissionStatus);
            }
            catch (InternalEAPException e) {
                if (Messages.showYesNoDialog((Component)parentComponent, (String)DiagnosticBundle.message("error.report.posting.failed", e.getMessage()), (String)ReportMessages.ERROR_REPORT, (Icon)Messages.getErrorIcon()) == 0) continue;
                return new SubmittedReportInfo(submissionStatus != SubmittedReportInfo.SubmissionStatus.FAILED ? URL_HEADER + threadId : null, String.valueOf(threadId), submissionStatus);
            }
            catch (IOException e) {
                if (IOExceptionDialog.showErrorDialog((String)DiagnosticBundle.message("error.report.exception.title", new Object[0]), (String)DiagnosticBundle.message("error.report.failure.message", new Object[0]))) continue;
                return new SubmittedReportInfo(submissionStatus != SubmittedReportInfo.SubmissionStatus.FAILED ? URL_HEADER + threadId : null, String.valueOf(threadId), submissionStatus);
            }
            catch (NewBuildException e) {
                Messages.showMessageDialog((Component)parentComponent, (String)DiagnosticBundle.message("error.report.new.eap.build.message", e.getMessage()), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon());
                return new SubmittedReportInfo(submissionStatus != SubmittedReportInfo.SubmissionStatus.FAILED ? URL_HEADER + threadId : null, String.valueOf(threadId), submissionStatus);
            }
            catch (Exception e) {
                if (Messages.showYesNoDialog((Component)JOptionPane.getRootFrame(), (String)DiagnosticBundle.message("error.report.sending.failure", new Object[0]), (String)ReportMessages.ERROR_REPORT, (Icon)Messages.getErrorIcon()) != 0) return new SubmittedReportInfo(submissionStatus != SubmittedReportInfo.SubmissionStatus.FAILED ? URL_HEADER + threadId : null, String.valueOf(threadId), submissionStatus);
                continue;
            }
            break;
        }
    }
}

