/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import com.intellij.ui.LightColors;
import com.intellij.ui.popup.NotificationPopup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class IdeMessagePanel
extends JPanel
implements MessagePoolListener,
StatusBarPatch {
    private final IconPane myIdeFatal;
    private final IconPane[] myIcons;
    private static final String INTERNAL_ERROR_NOTICE = DiagnosticBundle.message("error.notification.tooltip", new Object[0]);
    private long myPreviousExceptionTimeStamp;
    private IdeErrorsDialog myDialog;
    private boolean myOpeningInProgress;
    private final MessagePool myMessagePool;
    private boolean myNotificationPopupAlreadyShown = false;
    private final Icon myIcon = IconLoader.getIcon((String)"/general/ideFatalError.png");

    public IdeMessagePanel(MessagePool messagePool) {
        super(new BorderLayout());
        this.myIdeFatal = new IconPane(this.myIcon, DiagnosticBundle.message("error.notification.empty.text", new Object[0]), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeMessagePanel.this.openFatals();
            }
        });
        this.myIdeFatal.setVerticalAlignment(0);
        this.myIcons = new IconPane[]{this.myIdeFatal};
        this.add((Component)this.myIdeFatal, "Center");
        this.myMessagePool = messagePool;
        messagePool.addListener(this);
        JobScheduler.getScheduler().scheduleAtFixedRate(new Blinker(), 1L, 1L, TimeUnit.SECONDS);
        this.updateFatalErrorsIcon();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String updateStatusBar(Editor selected, JComponent componentSelected) {
        return null;
    }

    @Override
    public void clear() {
    }

    private void openFatals() {
        if (this.myDialog != null) {
            return;
        }
        if (this.myOpeningInProgress) {
            return;
        }
        this.myOpeningInProgress = true;
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (IdeMessagePanel.this.isOtherModalWindowActive()) {
                    if (IdeMessagePanel.this.myDialog == null) {
                        JobScheduler.getScheduler().schedule(this, 300L, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                try {
                    IdeMessagePanel.this._openFatals();
                }
                finally {
                    IdeMessagePanel.this.myOpeningInProgress = false;
                }
            }
        };
        task.run();
    }

    private void _openFatals() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeMessagePanel.this.myDialog = new IdeErrorsDialog(IdeMessagePanel.this.myMessagePool){

                    @Override
                    protected void doOKAction() {
                        super.doOKAction();
                        IdeMessagePanel.this.disposeDialog(this);
                    }

                    @Override
                    public void doCancelAction() {
                        super.doCancelAction();
                        IdeMessagePanel.this.disposeDialog(this);
                    }
                };
                IdeMessagePanel.this.myMessagePool.addListener(IdeMessagePanel.this.myDialog);
                if (!IdeMessagePanel.this.isOtherModalWindowActive()) {
                    IdeMessagePanel.this.myDialog.show();
                } else {
                    IdeMessagePanel.this.myDialog.close(0);
                    IdeMessagePanel.this.disposeDialog(IdeMessagePanel.this.myDialog);
                }
            }
        });
    }

    private void disposeDialog(IdeErrorsDialog listDialog) {
        this.myMessagePool.removeListener(listDialog);
        this.updateFatalErrorsIcon();
        this.myDialog = null;
    }

    @Override
    public void newEntryAdded() {
        this.updateFatalErrorsIcon();
        long lastExceptionTimestamp = System.currentTimeMillis();
        if (lastExceptionTimestamp - this.myPreviousExceptionTimeStamp > 1000L && this.myMessagePool.hasUnreadMessages()) {
            this.showErrorCallout();
        }
        this.myPreviousExceptionTimeStamp = lastExceptionTimestamp;
    }

    private void showErrorCallout() {
        if (PropertiesComponent.getInstance().isTrueValue("IMMEDIATE_FATAL_ERROR_POPUP")) {
            this.openFatals();
        }
    }

    @Override
    public void poolCleared() {
        this.updateFatalErrorsIcon();
    }

    private boolean isOtherModalWindowActive() {
        Window window = IdeMessagePanel.getActiveModalWindow();
        if (window == null) {
            return false;
        }
        return this.myDialog == null || this.myDialog.getWindow() != window;
    }

    private static Window getActiveModalWindow() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = manager.getActiveWindow();
        if (activeWindow instanceof JDialog && ((JDialog)activeWindow).isModal()) {
            return activeWindow;
        }
        return null;
    }

    private void updateFatalErrorsIcon() {
        if (this.myMessagePool.getFatalErrors(true, true).isEmpty()) {
            this.myNotificationPopupAlreadyShown = false;
            this.myIdeFatal.deactivate();
        } else {
            this.myIdeFatal.activate(INTERNAL_ERROR_NOTICE);
            if (!this.myNotificationPopupAlreadyShown) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JLabel label = new JLabel(INTERNAL_ERROR_NOTICE);
                        label.setIcon(IdeMessagePanel.this.myIcon);
                        new NotificationPopup(IdeMessagePanel.this, label, LightColors.RED, false, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                IdeMessagePanel.this._openFatals();
                            }
                        }, true);
                    }
                });
                this.myNotificationPopupAlreadyShown = true;
            }
        }
    }

    private class IconWrapper
    implements Icon {
        private final Icon myIcon;
        private boolean myEnabled;
        private boolean myShouldPaint = true;

        public IconWrapper(Icon aIcon) {
            this.myIcon = aIcon;
        }

        public void setIconPainted(boolean aPainted) {
            this.myEnabled = aPainted;
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.myEnabled && this.myShouldPaint) {
                this.myIcon.paintIcon(c, g, x, y);
            }
        }

        public void setVisible(boolean visible) {
            if (this.myShouldPaint != visible) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeMessagePanel.this.repaint();
                    }
                });
            }
            this.myShouldPaint = visible;
        }
    }

    private class IconPane
    extends JLabel {
        private final IconWrapper myIcon;
        private final String myEmptyText;
        private boolean myIsActive;
        private final ActionListener myListener;

        public IconPane(Icon aIcon, String aEmptyText, ActionListener aListener) {
            this.myIcon = new IconWrapper(aIcon);
            this.myEmptyText = aEmptyText;
            this.myListener = aListener;
            this.setIcon(this.myIcon);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (IconPane.this.myIsActive) {
                        IconPane.this.myListener.actionPerformed(null);
                    }
                }
            });
            this.deactivate();
        }

        public IconWrapper getIconWrapper() {
            return this.myIcon;
        }

        public void activate(String aDisplayingText) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.myIsActive = true;
            this.myIcon.setIconPainted(true);
            this.setToolTipText(aDisplayingText);
            this.repaint();
        }

        public void deactivate() {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.myIsActive = false;
            this.myIcon.setIconPainted(false);
            this.setToolTipText(this.myEmptyText);
            this.repaint();
        }

        public boolean shouldBlink() {
            return IdeMessagePanel.this.myMessagePool.hasUnreadMessages();
        }
    }

    private class Blinker
    implements Runnable {
        boolean myVisible = false;

        private Blinker() {
        }

        @Override
        public void run() {
            this.myVisible = !this.myVisible;
            this.setBlinkedIconsVisibilityTo(this.myVisible);
        }

        private void setBlinkedIconsVisibilityTo(boolean aVisible) {
            for (IconPane each : IdeMessagePanel.this.myIcons) {
                each.getIconWrapper().setVisible(aVisible || !each.shouldBlink());
            }
        }
    }
}

