/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;

public class DisposedPsiManagerCheck {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.DisposedPsiManagerCheck");
    private final Throwable myAllocationPlace;
    private final Project myProject;

    public DisposedPsiManagerCheck(Project project) {
        this.myProject = project;
        this.myAllocationPlace = new Throwable();
    }

    public void performCheck() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager == null) {
            this.log("Is null");
        } else if (psiManager.isDisposed()) {
            this.log("Disposed");
        }
    }

    private void log(@NonNls String message) {
        LOG.error(message + "\n" + StringUtil.getThrowableText((Throwable)this.myAllocationPlace));
    }
}

