/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.Parameterized;

public class JUnitUtil {
    @NonNls
    private static final String TESTCASE_CLASS = "junit.framework.TestCase";
    @NonNls
    private static final String TEST_INTERFACE = "junit.framework.Test";
    @NonNls
    private static final String TESTSUITE_CLASS = "junit.framework.TestSuite";
    @NonNls
    private static final String TEST_ANNOTATION = "org.junit.Test";
    @NonNls
    public static final String RUN_WITH = "org.junit.runner.RunWith";

    public static boolean isSuiteMethod(PsiMethod psiMethod) {
        PsiType testType;
        if (psiMethod == null) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (!(returnType == null || returnType.equalsToText(TEST_INTERFACE) || returnType.equalsToText(TESTSUITE_CLASS) || TypeConversionUtil.isAssignable((PsiType)(testType = JavaPsiFacade.getInstance((Project)psiMethod.getProject()).getElementFactory().createTypeFromText(TEST_INTERFACE, null)), (PsiType)returnType))) {
            return false;
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        return parameters.length == 0;
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location) {
        PsiClass aClass;
        PsiMethod psiMethod = (PsiMethod)location.getPsiElement();
        PsiClass psiClass = aClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : psiMethod.getContainingClass();
        if (aClass == null || !JUnitUtil.isTestClass(aClass)) {
            return false;
        }
        if (JUnitUtil.isTestAnnotated(psiMethod)) {
            return true;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (psiMethod.hasModifierProperty("abstract")) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)RUN_WITH, (boolean)true)) {
            return true;
        }
        if (psiMethod.getParameterList().getParametersCount() > 0) {
            return false;
        }
        if (psiMethod.hasModifierProperty("static") && "suite".equals(psiMethod.getName())) {
            return false;
        }
        if (!psiMethod.getName().startsWith("test")) {
            return false;
        }
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(location);
        return testCaseClass != null && psiMethod.getContainingClass().isInheritor(testCaseClass, true);
    }

    private static boolean isTestCaseInheritor(PsiClass aClass) {
        if (!aClass.isValid()) {
            return false;
        }
        Location location = PsiLocation.fromPsiElement((PsiElement)aClass);
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(location);
        return testCaseClass != null && aClass.isInheritor(testCaseClass, true);
    }

    private static boolean isTestClass(Location<? extends PsiClass> aClassLocation) {
        return JUnitUtil.isTestClass((PsiClass)aClassLocation.getPsiElement());
    }

    public static boolean isTestClass(PsiClass psiClass) {
        return JUnitUtil.isTestClass(psiClass, true, true);
    }

    private static boolean isTestClass(PsiClass psiClass, boolean checkAbstract, boolean checkForTestCaseInheritance) {
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        if (checkForTestCaseInheritance && JUnitUtil.isTestCaseInheritor(psiClass)) {
            return true;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (boolean)true)) {
            return true;
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (JUnitUtil.isSuiteMethod(method)) {
                return true;
            }
            if (!JUnitUtil.isTestAnnotated(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJUnit3TestClass(PsiClass clazz) {
        return JUnitUtil.isTestCaseInheritor(clazz);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass) {
        return JUnitUtil.isJUnit4TestClass(psiClass, true);
    }

    private static boolean isJUnit4TestClass(PsiClass psiClass, boolean checkAbstract) {
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (boolean)true)) {
            return true;
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (!JUnitUtil.isTestAnnotated(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestAnnotated(PsiMethod method) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)TEST_ANNOTATION, (boolean)false)) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method.getContainingClass(), Collections.singleton(RUN_WITH));
            if (annotation != null) {
                PsiNameValuePair[] attributes;
                for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
                    PsiTypeElement typeElement;
                    PsiAnnotationMemberValue value = attribute.getValue();
                    if (!(value instanceof PsiClassObjectAccessExpression) || !(typeElement = ((PsiClassObjectAccessExpression)value).getOperand()).getType().getCanonicalText().equals(Parameterized.class.getName())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static PsiClass getTestCaseClassOrNull(Location<?> location) {
        Location ancestorOrSelf = location.getAncestorOrSelf(PsiClass.class);
        PsiClass aClass = (PsiClass)ancestorOrSelf.getPsiElement();
        Module module = JavaExecutionUtil.findModule((PsiClass)aClass);
        if (module == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        return JUnitUtil.getTestCaseClassOrNull(scope, module.getProject());
    }

    public static PsiClass getTestCaseClass(Module module) throws NoJUnitException {
        if (module == null) {
            throw new NoJUnitException();
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        return JUnitUtil.getTestCaseClass(scope, module.getProject());
    }

    public static PsiClass getTestCaseClass(SourceScope scope) throws NoJUnitException {
        if (scope == null) {
            throw new NoJUnitException();
        }
        return JUnitUtil.getTestCaseClass(scope.getLibrariesScope(), scope.getProject());
    }

    private static PsiClass getTestCaseClass(GlobalSearchScope scope, Project project) throws NoJUnitException {
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(scope, project);
        if (testCaseClass == null) {
            throw new NoJUnitException(scope.getDisplayName());
        }
        return testCaseClass;
    }

    private static PsiClass getTestCaseClassOrNull(GlobalSearchScope scope, Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass(TESTCASE_CLASS, scope);
    }

    public static boolean isTestMethodOrConfig(PsiMethod psiMethod) {
        if (JUnitUtil.getTestMethod((PsiElement)psiMethod) != null) {
            return true;
        }
        String name = psiMethod.getName();
        if (psiMethod.hasModifierProperty("public") && !psiMethod.hasModifierProperty("abstract")) {
            if ("suite".equals(name) || "setUp".equals(name) || "tearDown".equals(name)) {
                return true;
            }
            if (psiMethod.hasModifierProperty("static") ? AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, Arrays.asList(BeforeClass.class.getName(), AfterClass.class.getName(), Parameterized.Parameters.class.getName().replace('$', '.'))) : AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, Arrays.asList(Before.class.getName(), After.class.getName()))) {
                return true;
            }
        }
        return false;
    }

    public static PsiClass findPsiClass(String qualifiedName, Module module, Project project) {
        GlobalSearchScope scope = module == null ? GlobalSearchScope.projectScope((Project)project) : GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        return JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, scope);
    }

    public static PsiPackage getContainingPackage(PsiClass psiClass) {
        return JavaDirectoryService.getInstance().getPackage(psiClass.getContainingFile().getContainingDirectory());
    }

    public static PsiClass getTestClass(PsiElement element) {
        return JUnitUtil.getTestClass(PsiLocation.fromPsiElement((PsiElement)element));
    }

    public static PsiClass getTestClass(Location<?> location) {
        PsiClass[] classes;
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            Location classLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestClass((Location<? extends PsiClass>)classLocation)) continue;
            return (PsiClass)classLocation.getPsiElement();
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiJavaFile && (classes = ((PsiJavaFile)element).getClasses()).length == 1) {
            return classes[0];
        }
        return null;
    }

    public static PsiMethod getTestMethod(PsiElement element) {
        PsiManager manager = element.getManager();
        Location location = PsiLocation.fromPsiElement((Project)manager.getProject(), (PsiElement)element);
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location<? extends PsiMethod>)methodLocation)) continue;
            return (PsiMethod)methodLocation.getPsiElement();
        }
        return null;
    }

    public static <T> Collection<T> findMaximums(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> maximums = new ArrayList<T>();
        block0: for (T candidate : collection) {
            for (T element : collection) {
                if (comparator.compare(element, candidate) <= 0) continue;
                continue block0;
            }
            maximums.add(candidate);
        }
        return maximums;
    }

    public static class NoJUnitException
    extends CantRunException {
        public NoJUnitException() {
            super(ExecutionBundle.message((String)"no.junit.error.message", (Object[])new Object[0]));
        }

        public NoJUnitException(String message) {
            super(ExecutionBundle.message((String)"no.junit.in.scope.error.message", (Object[])new Object[]{message}));
        }
    }

    public static class ModuleOfClass
    implements Convertor<PsiClass, Module> {
        public Module convert(PsiClass psiClass) {
            if (psiClass == null || !psiClass.isValid()) {
                return null;
            }
            return ModuleUtil.findModuleForPsiElement((PsiElement)psiClass);
        }
    }

    public static class TestMethodFilter
    implements Condition<PsiMethod> {
        private final PsiClass myClass;

        public TestMethodFilter(PsiClass aClass) {
            this.myClass = aClass;
        }

        public boolean value(PsiMethod method) {
            return JUnitUtil.isTestMethod(MethodLocation.elementInClass(method, this.myClass));
        }
    }
}

