/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new RemoteConfiguration("", project, this);
        }
    };
    private static final Icon ICON = IconLoader.getIcon((String)"/runConfigurations/remote.png");

    public String getDisplayName() {
        return ExecutionBundle.message((String)"remote.debug.configuration.display.name", (Object[])new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return ExecutionBundle.message((String)"remote.debug.configuration.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        if ("Remote" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/remote/RemoteConfigurationType.getId must not return null");
        }
        return "Remote";
    }

    @Nullable
    public static RemoteConfigurationType getInstance() {
        return (RemoteConfigurationType)ContainerUtil.findInstance((Object[])Extensions.getExtensions((ExtensionPointName)CONFIGURATION_TYPE_EP), RemoteConfigurationType.class);
    }
}

