/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.GridCell;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.actions.MinimizeViewAction;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MutualMap;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellImpl
implements GridCell,
Disposable {
    private final GridImpl myContainer;
    private final MutualMap<Content, TabInfo> myContents;
    private final Set<Content> myMinimizedContents;
    private final JBTabs myTabs;
    private final GridImpl.Placeholder myPlaceholder;
    private final PlaceInGrid myPlaceInGrid;
    private final ViewContextEx myContext;
    private CellTransform.Restore.List myRestoreFromDetach;
    private JBPopup myPopup;
    private boolean myDisposed;

    public GridCellImpl(ViewContextEx context, @NotNull GridImpl container, GridImpl.Placeholder placeholder, PlaceInGrid placeInGrid) {
        if (container == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ui/layout/impl/GridCellImpl.<init> must not be null");
        }
        this.myContents = new MutualMap(true);
        this.myMinimizedContents = new HashSet();
        this.myContext = context;
        this.myContainer = container;
        Disposer.register((Disposable)container, (Disposable)this);
        this.myPlaceInGrid = placeInGrid;
        this.myPlaceholder = placeholder;
        this.myTabs = new JBTabsImpl(this.myContext.getProject(), this.myContext.getActionManager(), this.myContext.getFocusManager(), (Disposable)container).setDataProvider(new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (ViewContext.CONTENT_KEY.is(dataId)) {
                    TabInfo target = GridCellImpl.this.myTabs.getTargetInfo();
                    if (target != null) {
                        return new Content[]{GridCellImpl.this.getContentFor(target)};
                    }
                } else if (ViewContext.CONTEXT_KEY.is(dataId)) {
                    return GridCellImpl.this.myContext;
                }
                return null;
            }
        });
        this.myTabs.getPresentation().setUiDecorator(new UiDecorator(){

            @NotNull
            public UiDecorator.UiDecoration getDecoration() {
                UiDecorator.UiDecoration uiDecoration = new UiDecorator.UiDecoration(null, new Insets(1, -1, 1, -1));
                if (uiDecoration == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/GridCellImpl$2.getDecoration must not return null");
                }
                return uiDecoration;
            }
        }).setSideComponentVertical(!context.getLayoutSettings().isToolbarHorizontal()).setStealthTabMode(true).setFocusCycle(false).setPaintFocus(true);
        this.myTabs.addTabMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UIUtil.isCloseClick((MouseEvent)e)) {
                    if (GridCellImpl.this.isDetached()) {
                        GridCellImpl.this.myPopup.cancel();
                    } else {
                        GridCellImpl.this.minimize(e);
                    }
                }
            }
        });
        this.rebuildPopupGroup();
        this.myTabs.addListener(new TabsListener(){

            public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (oldSelection != null && GridCellImpl.this.myContext.isStateBeingRestored()) {
                    GridCellImpl.this.saveUiState();
                }
            }

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                GridCellImpl.this.updateSelection(GridCellImpl.this.myTabs.getComponent().isShowing());
                if (!GridCellImpl.this.myTabs.getComponent().isShowing()) {
                    return;
                }
                if (newSelection != null) {
                    newSelection.stopAlerting();
                }
            }
        });
    }

    public void rebuildPopupGroup() {
        this.myTabs.setPopupGroup(this.myContext.getCellPopupGroup("debuggerCellPopup"), "debuggerCellPopup", true);
    }

    public PlaceInGrid getPlaceInGrid() {
        return this.myPlaceInGrid;
    }

    void add(final Content content) {
        if (this.myContents.containsKey((Object)content)) {
            return;
        }
        this.myContents.put((Object)content, null);
        this.revalidateCell(new Runnable(){

            @Override
            public void run() {
                GridCellImpl.this.myTabs.addTab(GridCellImpl.this.createTabInfoFor(content));
            }
        });
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
    }

    void remove(Content content) {
        if (!this.myContents.containsKey((Object)content)) {
            return;
        }
        final TabInfo info = this.getTabFor(content);
        this.myContents.remove((Object)content);
        this.revalidateCell(new Runnable(){

            @Override
            public void run() {
                GridCellImpl.this.myTabs.removeTab(info);
            }
        });
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
    }

    private void revalidateCell(Runnable contentAction) {
        if (this.myContents.size() == 0) {
            this.myPlaceholder.removeAll();
            this.myTabs.removeAllTabs();
        } else {
            if (this.myPlaceholder.isNull() && !this.isDetached()) {
                this.myPlaceholder.setContent(this.myTabs.getComponent());
            }
            contentAction.run();
        }
        this.restoreProportions();
        this.myTabs.getComponent().revalidate();
        this.myTabs.getComponent().repaint();
    }

    void setHideTabs(boolean hide) {
        this.myTabs.getPresentation().setHideTabs(hide);
    }

    private TabInfo createTabInfoFor(Content content) {
        JComponent c = content.getComponent();
        TabInfo tabInfo = GridCellImpl.updatePresentation(new TabInfo((JComponent)((Object)new ProviderWrapper(content, this.myContext))), content).setObject((Object)content).setPreferredFocusableComponent(content.getPreferredFocusableComponent()).setActionsContextComponent(content.getActionsContextComponent());
        this.myContents.remove((Object)content);
        this.myContents.put((Object)content, (Object)tabInfo);
        ActionGroup group = (ActionGroup)this.myContext.getActionManager().getAction("Runner.View.Toolbar");
        tabInfo.setTabLabelActions(group, "debuggerCellToolbar");
        return tabInfo;
    }

    @Nullable
    private static TabInfo updatePresentation(TabInfo info, Content content) {
        if (info == null) {
            return info;
        }
        return info.setIcon(content.getIcon()).setText(content.getDisplayName()).setActions(content.getActions(), content.getPlace());
    }

    public ActionCallback select(Content content, boolean requestFocus) {
        TabInfo tabInfo = (TabInfo)this.myContents.getValue((Object)content);
        return tabInfo != null ? this.myTabs.select(tabInfo, requestFocus) : new ActionCallback.Done();
    }

    public void processAlert(Content content, boolean activate) {
        if (this.myMinimizedContents.contains(content)) {
            return;
        }
        TabInfo tab = this.getTabFor(content);
        if (tab == null) {
            return;
        }
        if (this.myTabs.getSelectedInfo() != tab) {
            if (activate) {
                tab.fireAlert();
            } else {
                tab.stopAlerting();
            }
        }
    }

    public void updateTabPresentation(Content content) {
        GridCellImpl.updatePresentation(this.myTabs.findInfo((Object)content), content);
    }

    public boolean isMinimized(Content content) {
        return this.myMinimizedContents.contains(content);
    }

    @Nullable
    private TabInfo getTabFor(Content content) {
        return (TabInfo)this.myContents.getValue((Object)content);
    }

    @NotNull
    private Content getContentFor(TabInfo tab) {
        Content content = (Content)this.myContents.getKey((Object)tab);
        if (content == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/GridCellImpl.getContentFor must not return null");
        }
        return content;
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myTabs.getPresentation().setSideComponentVertical(!horizontal);
    }

    public ActionCallback restoreLastUiState() {
        Content[] contents;
        ActionCallback result = new ActionCallback();
        this.restoreProportions();
        for (Content each : contents = this.getContents()) {
            if (!this.myContainer.getStateFor(each).isMinimizedInGrid()) continue;
            this.minimize(each);
        }
        if (!this.isRestoringFromDetach() && this.myContainer.getTab().isDetached(this.myPlaceInGrid)) {
            this._detach(!this.myContext.isStateBeingRestored()).notifyWhenDone(result);
        } else {
            result.setDone();
        }
        return result;
    }

    private Content[] getContents() {
        return this.myContents.getKeys().toArray(new Content[this.myContents.size()]);
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    public void saveUiState() {
        this.saveProportions();
        for (Content each : this.myContents.getKeys()) {
            this.saveState(each, false);
        }
        for (Content each : this.myMinimizedContents) {
            this.saveState(each, true);
        }
    }

    public void saveProportions() {
        this.myContainer.saveSplitterProportions(this.myPlaceInGrid);
    }

    private void saveState(Content content, boolean minimized) {
        View state = this.myContext.getStateFor(content);
        state.setMinimizedInGrid(minimized);
        state.setPlaceInGrid(this.myPlaceInGrid);
        state.assignTab(this.myContainer.getTabIndex());
        state.getTab().setDetached(this.myPlaceInGrid, this.isDetached());
    }

    public void restoreProportions() {
        this.myContainer.restoreLastSplitterProportions(this.myPlaceInGrid);
    }

    public void updateSelection(boolean isShowing) {
        for (Content each : this.myContents.getKeys()) {
            boolean isSelected;
            TabInfo eachTab = this.getTabFor(each);
            boolean bl = isSelected = eachTab != null && this.myTabs.getSelectedInfo() == eachTab;
            if (isSelected && (isShowing || this.isDetached())) {
                this.myContext.getContentManager().addSelectedContent(each);
                continue;
            }
            this.myContext.getContentManager().removeFromSelection(each);
        }
        for (Content each : this.myMinimizedContents) {
            this.myContext.getContentManager().removeFromSelection(each);
        }
    }

    public void minimize(Content[] contents) {
        this.myContext.saveUiState();
        for (final Content each : contents) {
            this.myMinimizedContents.add(each);
            this.remove(each);
            boolean isShowing = this.myTabs.getComponent().getRootPane() != null;
            this.updateSelection(isShowing);
            this.myContainer.minimize(each, new CellTransform.Restore(){

                public ActionCallback restoreInGrid() {
                    return GridCellImpl.this.restore(each);
                }
            });
        }
    }

    public ActionCallback detach() {
        return this._detach(true);
    }

    private ActionCallback _detach(final boolean requestFocus) {
        this.myContext.saveUiState();
        DimensionService dimService = DimensionService.getInstance();
        Point storedLocation = dimService.getLocation(this.getDimensionKey(), this.myContext.getProject());
        Dimension storedSize = dimService.getSize(this.getDimensionKey(), this.myContext.getProject());
        IdeFrame frame = WindowManager.getInstance().getIdeFrame(this.myContext.getProject());
        final Rectangle targetBounds = frame.suggestChildFrameBounds();
        if (storedLocation != null && storedSize != null) {
            targetBounds.setLocation(storedLocation);
            targetBounds.setSize(storedSize);
        }
        final ActionCallback result = new ActionCallback();
        if ((storedLocation == null || storedSize == null) && this.myContents.size() > 0) {
            this.myContext.validate((Content)this.myContents.getKeys().iterator().next(), new ActiveRunnable(){

                public ActionCallback run() {
                    if (!GridCellImpl.this.myTabs.getComponent().isShowing()) {
                        GridCellImpl.this.detachTo(targetBounds.getLocation(), targetBounds.getSize(), false, requestFocus).notifyWhenDone(result);
                    } else {
                        GridCellImpl.this.detachForShowingTabs(requestFocus).notifyWhenDone(result);
                    }
                    return new ActionCallback.Done();
                }
            });
            return result;
        }
        this.detachTo(targetBounds.getLocation(), targetBounds.getSize(), false, requestFocus).notifyWhenDone(result);
        return result;
    }

    private ActionCallback detachForShowingTabs(boolean requestFocus) {
        return this.detachTo(this.myTabs.getComponent().getLocationOnScreen(), this.myTabs.getComponent().getSize(), false, requestFocus);
    }

    private ActionCallback detachTo(Point screenPoint, Dimension size, boolean dragging, boolean requestFocus) {
        if (this.isDetached()) {
            return new ActionCallback.Done();
        }
        Content[] contents = this.getContents();
        this.myRestoreFromDetach = new CellTransform.Restore.List();
        this.myRestoreFromDetach.add(this.myPlaceholder.detach());
        this.myRestoreFromDetach.add(this.myContainer.detach(contents));
        this.myRestoreFromDetach.add(new CellTransform.Restore(){

            public ActionCallback restoreInGrid() {
                GridCellImpl.this.ensureVisible();
                return new ActionCallback.Done();
            }
        });
        this.myPopup = this.createPopup(dragging, requestFocus);
        this.myPopup.setSize(size);
        this.myPopup.setLocation(screenPoint);
        this.myPopup.show((Component)this.myContext.getContentManager().getComponent());
        this.myContext.saveUiState();
        this.myTabs.updateTabActions(true);
        return new ActionCallback.Done();
    }

    private void ensureVisible() {
        if (this.myTabs.getSelectedInfo() != null) {
            this.myContext.select(this.getContentFor(this.myTabs.getSelectedInfo()), true);
        }
    }

    private JBPopup createPopup(boolean dragging, boolean requestFocus) {
        Wrapper wrapper = new Wrapper(this.myTabs.getComponent());
        wrapper.setBorder((Border)new EmptyBorder(1, 0, 0, 0));
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)wrapper, this.myTabs.getComponent()).setTitle(this.myContainer.getSessionName()).setMovable(true).setRequestFocus(requestFocus).setFocusable(true).setResizable(true).setDimensionServiceKey(this.myContext.getProject(), this.getDimensionKey(), true).setCancelOnOtherWindowOpen(false).setCancelOnClickOutside(false).setCancelKeyEnabled(true).setLocateByContent(dragging).setLocateWithinScreenBounds(!dragging).setCancelKeyEnabled(false).setBelongsToGlobalPopupStack(false).setModalContext(false).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (GridCellImpl.this.myDisposed) {
                    return Boolean.TRUE;
                }
                GridCellImpl.this.myRestoreFromDetach.restoreInGrid();
                GridCellImpl.this.myRestoreFromDetach = null;
                GridCellImpl.this.myContext.saveUiState();
                GridCellImpl.this.myTabs.updateTabActions(true);
                return Boolean.TRUE;
            }
        });
        return builder.createPopup();
    }

    public void attach() {
        if (this.isDetached()) {
            this.myPopup.cancel();
        }
    }

    public boolean isDetached() {
        return this.myRestoreFromDetach != null && !this.myRestoreFromDetach.isRestoringNow();
    }

    public boolean isRestoringFromDetach() {
        return this.myRestoreFromDetach != null && this.myRestoreFromDetach.isRestoringNow();
    }

    private String getDimensionKey() {
        return "GridCell.Tab." + this.myContainer.getTab().getIndex() + "." + this.myPlaceInGrid.name();
    }

    public boolean isValidForCalculatePropertions() {
        return !this.isDetached() && this.getContentCount() > 0;
    }

    public void minimize(Content content) {
        this.minimize(new Content[]{content});
    }

    public void minimize(MouseEvent e) {
        if (!MinimizeViewAction.isEnabled(this.myContext, this.getContents(), "debuggerCellToolbar")) {
            return;
        }
        TabInfo tabInfo = this.myTabs.findInfo(e);
        if (tabInfo != null) {
            this.minimize(this.getContentFor(tabInfo));
        }
    }

    private ActionCallback restore(Content content) {
        this.myMinimizedContents.remove(content);
        this.add(content);
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
        return new ActionCallback.Done();
    }

    public void dispose() {
        this.myDisposed = true;
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    private static class ProviderWrapper
    extends NonOpaquePanel
    implements DataProvider {
        Content myContent;
        ViewContext myContext;

        private ProviderWrapper(Content content, ViewContext context) {
            this.myContent = content;
            this.myContext = context;
            this.setLayout(new BorderLayout());
            this.add(content.getComponent(), "Center");
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (ViewContext.CONTENT_KEY.is(dataId)) {
                return new Content[]{this.myContent};
            }
            if (ViewContext.CONTEXT_KEY.is(dataId)) {
                return this.myContext;
            }
            return null;
        }
    }
}

