/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.autodetecting.UnderlyingFacetSelector;
import com.intellij.facet.impl.autodetecting.FacetDetectorForWizardRegistry;
import com.intellij.facet.impl.autodetecting.FacetDetectorRegistryEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FacetDetectionProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ui.FacetDetectionProcessor");
    private final Map<FacetConfiguration, DetectedInWizardFacetInfo> myDetectedFacets = new LinkedHashMap<FacetConfiguration, DetectedInWizardFacetInfo>();
    private final Map<FacetTypeId, List<FacetConfiguration>> myDetectedConfigurations = new HashMap<FacetTypeId, List<FacetConfiguration>>();
    private final ProgressIndicator myProgressIndicator;
    private final FileTypeManager myFileTypeManager;
    private final List<MultiValuesMap<FileType, MyFacetDetectorWrapper>> myDetectors = new ArrayList<MultiValuesMap<FileType, MyFacetDetectorWrapper>>();

    public FacetDetectionProcessor(ProgressIndicator progressIndicator, ModuleType moduleType) {
        FacetType[] types;
        this.myProgressIndicator = progressIndicator;
        this.myFileTypeManager = FileTypeManager.getInstance();
        for (FacetType type : types = FacetTypeRegistry.getInstance().getFacetTypes()) {
            if (!type.isSuitableModuleType(moduleType)) continue;
            this.registerDetectors(type);
            this.myDetectedConfigurations.put(type.getId(), new ArrayList());
        }
    }

    private <C extends FacetConfiguration> void registerDetectors(FacetType<?, C> type) {
        type.registerDetectors(new FacetDetectorRegistryEx<C>(new MyFacetDetectorRegistry<C>(type), null));
    }

    public void process(File root) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(root);
        if (virtualFile == null) {
            return;
        }
        for (int i = 0; i < this.myDetectors.size(); ++i) {
            MultiValuesMap<FileType, MyFacetDetectorWrapper> map = this.myDetectors.get(i);
            if (i > 0) {
                ArrayList<MyFacetDetectorWrapper> toRemove = new ArrayList<MyFacetDetectorWrapper>();
                for (MyFacetDetectorWrapper detector : map.values()) {
                    FacetTypeId typeId = detector.getFacetType().getUnderlyingFacetType();
                    LOG.assertTrue(typeId != null);
                    List<FacetConfiguration> list = this.myDetectedConfigurations.get(typeId);
                    if (list != null && !list.isEmpty()) continue;
                    toRemove.add(detector);
                }
                for (MyFacetDetectorWrapper detectorWrapper : toRemove) {
                    map.remove((Object)detectorWrapper.getFileType(), (Object)detectorWrapper);
                }
            }
            if (map.isEmpty()) break;
            this.process(virtualFile, map);
        }
    }

    private void process(VirtualFile file, MultiValuesMap<FileType, MyFacetDetectorWrapper> detectorsMap) {
        if (this.myProgressIndicator.isCanceled()) {
            return;
        }
        if (file.isDirectory()) {
            VirtualFile[] children;
            file.getChildren();
            file.refresh(false, false);
            for (VirtualFile child : children = file.getChildren()) {
                this.process(child, detectorsMap);
            }
            return;
        }
        this.myProgressIndicator.setText2(file.getPresentableUrl());
        FileType fileType = this.myFileTypeManager.getFileTypeByFile(file);
        Collection detectors = detectorsMap.get((Object)fileType);
        if (detectors == null) {
            return;
        }
        for (MyFacetDetectorWrapper detector : detectors) {
            detector.detectFacet(file);
        }
    }

    public List<DetectedInWizardFacetInfo> getDetectedFacetsInfos() {
        return new ArrayList<DetectedInWizardFacetInfo>(this.myDetectedFacets.values());
    }

    public List<FacetInfo> getDetectedFacets() {
        ArrayList<FacetInfo> list = new ArrayList<FacetInfo>();
        for (DetectedInWizardFacetInfo info : this.myDetectedFacets.values()) {
            list.add(info.getFacetInfo());
        }
        return list;
    }

    public static class DetectedInWizardFacetInfo {
        private final FacetInfo myFacetInfo;
        private final VirtualFile myFile;
        private final FacetDetector myFacetDetector;

        public DetectedInWizardFacetInfo(FacetInfo facetInfo, VirtualFile file, FacetDetector facetDetector) {
            this.myFacetInfo = facetInfo;
            this.myFile = file;
            this.myFacetDetector = facetDetector;
        }

        public FacetInfo getFacetInfo() {
            return this.myFacetInfo;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public FacetDetector getFacetDetector() {
            return this.myFacetDetector;
        }
    }

    private class MyFacetDetectorRegistry<C extends FacetConfiguration>
    implements FacetDetectorForWizardRegistry<C> {
        private final FacetType<?, C> myFacetType;
        private final int myLevel;

        public MyFacetDetectorRegistry(FacetType<?, C> facetType) {
            this.myFacetType = facetType;
            int level = 0;
            FacetTypeId typeId = facetType.getUnderlyingFacetType();
            HashSet<FacetTypeId> parentTypes = new HashSet<FacetTypeId>();
            parentTypes.add(facetType.getId());
            while (typeId != null) {
                ++level;
                FacetType underlying = FacetTypeRegistry.getInstance().findFacetType(typeId);
                LOG.assertTrue(underlying != null, (Object)("Cannot find underlying facet type by id: " + typeId + " (for facet " + facetType.getId() + ")"));
                typeId = underlying.getUnderlyingFacetType();
                if (parentTypes.add(typeId)) continue;
                LOG.error("Circular dependency between facets: " + parentTypes);
                break;
            }
            this.myLevel = level;
        }

        @Override
        public void register(@NotNull FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, @NotNull FacetDetector<VirtualFile, C> facetDetector) {
            if (fileType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/FacetDetectionProcessor$MyFacetDetectorRegistry.register must not be null");
            }
            if (virtualFileFilter == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/FacetDetectionProcessor$MyFacetDetectorRegistry.register must not be null");
            }
            if (facetDetector == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/FacetDetectionProcessor$MyFacetDetectorRegistry.register must not be null");
            }
            LOG.assertTrue(this.myFacetType.getUnderlyingFacetType() == null, (Object)"This method must not be used for sub-facets");
            this.getDetectorsMap().put((Object)fileType, new MyFacetDetectorWrapper(this.myFacetType, fileType, virtualFileFilter, facetDetector, null));
        }

        private MultiValuesMap<FileType, MyFacetDetectorWrapper> getDetectorsMap() {
            while (this.myLevel >= FacetDetectionProcessor.this.myDetectors.size()) {
                FacetDetectionProcessor.this.myDetectors.add(new MultiValuesMap());
            }
            return (MultiValuesMap)FacetDetectionProcessor.this.myDetectors.get(this.myLevel);
        }

        @Override
        public <U extends FacetConfiguration> void register(FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, FacetDetector<VirtualFile, C> facetDetector, UnderlyingFacetSelector<VirtualFile, U> underlyingFacetSelector) {
            if (virtualFileFilter == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/FacetDetectionProcessor$MyFacetDetectorRegistry.register must not be null");
            }
            LOG.assertTrue(this.myFacetType.getUnderlyingFacetType() != null, (Object)"This method can be used only for sub-facets");
            MyFacetDetectorWrapper<C, U> detector = new MyFacetDetectorWrapper<C, U>(this.myFacetType, fileType, virtualFileFilter, facetDetector, underlyingFacetSelector);
            this.getDetectorsMap().put((Object)fileType, detector);
        }
    }

    private class MyFacetDetectorWrapper<C extends FacetConfiguration, U extends FacetConfiguration> {
        private final FacetType<?, C> myFacetType;
        private final FileType myFileType;
        private final VirtualFileFilter myVirtualFileFilter;
        private final FacetDetector<VirtualFile, C> myDetector;
        private final UnderlyingFacetSelector<VirtualFile, U> myUnderlyingFacetSelector;

        public MyFacetDetectorWrapper(FacetType<?, C> facetType, FileType fileType, VirtualFileFilter virtualFileFilter, FacetDetector<VirtualFile, C> detector, UnderlyingFacetSelector<VirtualFile, U> underlyingFacetSelector) {
            this.myUnderlyingFacetSelector = underlyingFacetSelector;
            this.myFacetType = facetType;
            this.myFileType = fileType;
            this.myVirtualFileFilter = virtualFileFilter;
            this.myDetector = detector;
        }

        public FileType getFileType() {
            return this.myFileType;
        }

        public FacetType<?, C> getFacetType() {
            return this.myFacetType;
        }

        public void detectFacet(VirtualFile file) {
            List configurations;
            FacetConfiguration newConfiguration;
            if (!this.myVirtualFileFilter.accept(file)) {
                return;
            }
            FacetInfo underlyingFacet = null;
            if (this.myUnderlyingFacetSelector != null) {
                List list = (List)FacetDetectionProcessor.this.myDetectedConfigurations.get(this.myFacetType.getUnderlyingFacetType());
                FacetConfiguration underlying = this.myUnderlyingFacetSelector.selectUnderlyingFacet((Object)file, (Collection)list);
                if (underlying == null) {
                    return;
                }
                underlyingFacet = ((DetectedInWizardFacetInfo)FacetDetectionProcessor.this.myDetectedFacets.get(underlying)).getFacetInfo();
            }
            if ((newConfiguration = this.myDetector.detectFacet((Object)file, (Collection)(configurations = (List)FacetDetectionProcessor.this.myDetectedConfigurations.get(this.myFacetType.getId())))) == null || configurations.contains(newConfiguration)) {
                return;
            }
            FacetInfo facetInfo = new FacetInfo(this.myFacetType, this.generateFacetName(), newConfiguration, underlyingFacet);
            configurations.add(newConfiguration);
            FacetDetectionProcessor.this.myDetectedFacets.put(newConfiguration, new DetectedInWizardFacetInfo(facetInfo, file, this.myDetector));
        }

        private String generateFacetName() {
            String baseName;
            String name = baseName = this.myFacetType.getDefaultFacetName();
            int i = 2;
            while (this.isUsed(name)) {
                name = baseName + i;
                ++i;
            }
            return name;
        }

        private boolean isUsed(String name) {
            List configurations = (List)FacetDetectionProcessor.this.myDetectedConfigurations.get(this.myFacetType.getId());
            if (configurations != null) {
                for (FacetConfiguration configuration : configurations) {
                    if (!name.equals(((DetectedInWizardFacetInfo)FacetDetectionProcessor.this.myDetectedFacets.get(configuration)).getFacetInfo().getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

