/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;
import java.util.List;

public class FileEntry
extends Entry {
    private long myTimestamp;
    private boolean isReadOnly;
    private Content myContent;

    public FileEntry(int id, String name, Content content, long timestamp, boolean isReadOnly) {
        super(id, name);
        this.myTimestamp = timestamp;
        this.isReadOnly = isReadOnly;
        this.myContent = content;
    }

    public FileEntry(Stream s) throws IOException {
        super(s);
        this.myTimestamp = s.readLong();
        this.isReadOnly = s.readBoolean();
        this.myContent = s.readContent();
    }

    @Override
    public void write(Stream s) throws IOException {
        super.write(s);
        s.writeLong(this.myTimestamp);
        s.writeBoolean(this.isReadOnly);
        s.writeContent(this.myContent);
    }

    @Override
    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Content getContent() {
        return this.myContent;
    }

    @Override
    public boolean hasUnavailableContent(List<Entry> entriesWithUnavailableContent) {
        if (this.myContent.isAvailable()) {
            return false;
        }
        entriesWithUnavailableContent.add(this);
        return true;
    }

    @Override
    public FileEntry copy() {
        return new FileEntry(this.myId, this.myName, this.myContent, this.myTimestamp, this.isReadOnly);
    }

    @Override
    public void changeContent(Content newContent, long newTimestamp) {
        this.myContent = newContent;
        this.myTimestamp = newTimestamp;
    }

    @Override
    public void collectDifferencesWith(Entry e, List<Difference> result) {
        if (this.getPath().equals(e.getPath()) && this.myContent.equals(e.getContent()) && this.isReadOnly == e.isReadOnly()) {
            return;
        }
        result.add(new Difference(true, this, e));
    }

    @Override
    protected void collectCreatedDifferences(List<Difference> result) {
        result.add(new Difference(true, null, this));
    }

    @Override
    protected void collectDeletedDifferences(List<Difference> result) {
        result.add(new Difference(true, this, null));
    }
}

