/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ExternalJavaDocAction
extends AnAction {
    public ExternalJavaDocAction() {
        this.setInjectedContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element == null) {
            Messages.showMessageDialog((Project)project, (String)IdeBundle.message((String)"message.please.select.element.for.javadoc", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.element.selected", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        PsiFile context = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        PsiElement originalElement = ExternalJavaDocAction.getOriginalElement(context, editor);
        DocumentationManager.storeOriginalElement(project, originalElement, element);
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        List urls = provider.getUrlFor(element, originalElement);
        assert (urls != null);
        assert (!urls.isEmpty());
        ExternalJavaDocAction.showExternalJavadoc(urls);
    }

    public static void showExternalJavadoc(List<String> urls) {
        HashSet<String> set = new HashSet<String>(urls);
        if (set.size() > 1) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("Choose javadoc root", ArrayUtil.toStringArray(set)){

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    BrowserUtil.launchBrowser((String)selectedValue);
                    return FINAL_CHOICE;
                }
            }).showInBestPositionFor(DataManager.getInstance().getDataContext());
        } else if (set.size() == 1) {
            BrowserUtil.launchBrowser((String)urls.get(0));
        }
    }

    @Nullable
    private static PsiElement getOriginalElement(PsiFile context, Editor editor) {
        return context != null && editor != null ? context.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    public void update(AnActionEvent event) {
        boolean enabled;
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiElement originalElement = ExternalJavaDocAction.getOriginalElement((PsiFile)LangDataKeys.PSI_FILE.getData(dataContext), editor);
        DocumentationManager.storeOriginalElement((Project)PlatformDataKeys.PROJECT.getData(dataContext), originalElement, element);
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
        List urls = provider.getUrlFor(element, originalElement);
        boolean bl = enabled = urls != null && !urls.isEmpty();
        if (editor != null) {
            presentation.setEnabled(enabled);
            if (event.getPlace().equals("MainMenu")) {
                presentation.setVisible(true);
            } else {
                presentation.setVisible(enabled);
            }
        } else {
            presentation.setEnabled(enabled);
            presentation.setVisible(true);
        }
    }
}

