/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;

public class FavoritesViewSelectInTarget
extends ProjectViewSelectInTarget {
    public FavoritesViewSelectInTarget(Project project) {
        super(project);
    }

    @Override
    public String toString() {
        return SelectInManager.FAVORITES;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file) {
        if (!super.canSelect(file)) {
            return false;
        }
        return FavoritesViewSelectInTarget.findSuitableFavoritesList(file.getVirtualFile(), this.myProject, null) != null;
    }

    public static String findSuitableFavoritesList(VirtualFile file, Project project, String currentSubId) {
        String[] lists;
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        if (currentSubId != null && favoritesManager.contains(currentSubId, file)) {
            return currentSubId;
        }
        for (String name : lists = favoritesManager.getAvailableFavoritesLists()) {
            if (!favoritesManager.contains(name, file)) continue;
            return name;
        }
        return null;
    }

    public String getMinorViewId() {
        return "Favorites";
    }

    public float getWeight() {
        return 6.0f;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }

    @Override
    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        FavoritesManager favoritesManager = FavoritesManager.getInstance(this.myProject);
        return favoritesManager.contains(subId, context.getVirtualFile());
    }
}

