/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;

public class AddNewFavoritesListAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project != null) {
            AddNewFavoritesListAction.doAddNewFavoritesList(project);
        }
    }

    public static String doAddNewFavoritesList(final Project project) {
        final FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        String name = Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.input.new.favorites.list.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.add.new.favorites.list", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)AddNewFavoritesListAction.getUniqueName(project), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            public boolean canClose(String inputString) {
                boolean isNew;
                boolean bl = isNew = ArrayUtil.find((Object[])favoritesManager.getAvailableFavoritesLists(), (Object)inputString.trim()) == -1;
                if (!isNew) {
                    Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.favorites.list.already.exists", (Object[])new Object[]{inputString.trim()}), (String)IdeBundle.message((String)"title.unable.to.add.favorites.list", (Object[])new Object[0]));
                    return false;
                }
                return inputString.trim().length() > 0;
            }
        });
        if (name == null || name.length() == 0) {
            return null;
        }
        favoritesManager.createNewList(name);
        return name;
    }

    private static String getUniqueName(Project project) {
        Object[] names = FavoritesManager.getInstance(project).getAvailableFavoritesLists();
        int i = 0;
        String newName;
        while (ArrayUtil.find((Object[])names, (Object)(newName = IdeBundle.message((String)"favorites.list.unnamed", (Object[])new Object[]{i > 0 ? Integer.valueOf(i) : ""}))) > -1) {
            ++i;
        }
        return newName;
    }
}

