/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplatePanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromTemplateDialog
extends DialogWrapper {
    @NotNull
    private final PsiDirectory myDirectory;
    @NotNull
    private final Project myProject;
    private PsiElement myCreatedElement;
    private final CreateFromTemplatePanel myAttrPanel;
    private final JComponent myAttrComponent;
    @NotNull
    private final FileTemplate myTemplate;
    private final Properties myDefaultProperties;

    public CreateFromTemplateDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull FileTemplate template, @Nullable AttributesDefaults attributesDefaults) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/fileTemplates/ui/CreateFromTemplateDialog.<init> must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/fileTemplates/ui/CreateFromTemplateDialog.<init> must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/fileTemplates/ui/CreateFromTemplateDialog.<init> must not be null");
        }
        super(project, true);
        this.myDirectory = directory;
        this.myProject = project;
        this.myTemplate = template;
        this.setTitle(IdeBundle.message((String)"title.new.from.template", (Object[])new Object[]{template.getName()}));
        this.myDefaultProperties = FileTemplateManager.getInstance().getDefaultProperties();
        FileTemplateUtil.fillDefaultProperties(this.myDefaultProperties, directory);
        String[] unsetAttributes = null;
        try {
            unsetAttributes = this.myTemplate.getUnsetAttributes(this.myDefaultProperties);
        }
        catch (ParseException e) {
            this.showErrorDialog((Exception)((Object)e));
        }
        if (unsetAttributes != null) {
            this.myAttrPanel = new CreateFromTemplatePanel(unsetAttributes, !this.myTemplate.isJavaClassTemplate(), attributesDefaults);
            this.myAttrComponent = this.myAttrPanel.getComponent();
            this.init();
        } else {
            this.myAttrPanel = null;
            this.myAttrComponent = null;
        }
    }

    public PsiElement create() {
        if (this.myAttrPanel != null) {
            if (this.myAttrPanel.hasSomethingToAsk()) {
                this.show();
            } else {
                this.doCreate(null);
            }
        }
        return this.myCreatedElement;
    }

    protected void doOKAction() {
        String fileName = this.myAttrPanel.getFileName();
        if (fileName != null && fileName.length() == 0) {
            Messages.showMessageDialog((Component)this.myAttrComponent, (String)IdeBundle.message((String)"error.please.enter.a.file.name", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        this.doCreate(fileName);
        if (this.myCreatedElement != null) {
            super.doOKAction();
        }
    }

    private void doCreate(String fileName) {
        try {
            this.myCreatedElement = FileTemplateUtil.createFromTemplate(this.myTemplate, fileName, this.myAttrPanel.getProperties(this.myDefaultProperties), this.myDirectory);
        }
        catch (Exception e) {
            this.showErrorDialog(e);
        }
    }

    private void showErrorDialog(Exception e) {
        Messages.showMessageDialog((Project)this.myProject, (String)this.filterMessage(e.getMessage()), (String)this.getErrorMessage(), (Icon)Messages.getErrorIcon());
    }

    private String getErrorMessage() {
        return this.myTemplate.isJavaClassTemplate() ? IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]) : IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    @Nullable
    private String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        if (message.startsWith(ioExceptionPrefix)) {
            message = message.substring(ioExceptionPrefix.length());
        }
        return IdeBundle.message((String)"error.unable.to.parse.template.message", (Object[])new Object[]{this.myTemplate.getName(), message});
    }

    protected JComponent createCenterPanel() {
        this.myAttrPanel.ensureFitToScreen(200, 200);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        centerPanel.add((Component)this.myAttrComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return centerPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myAttrComponent);
    }
}

