/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;

public final class OutputPathMacro
extends Macro {
    @Override
    public String getName() {
        return "OutputPath";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.output.path", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext) {
        ProjectFileIndex projectFileIndex;
        Module module;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file != null && (module = (projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex()).getModuleForFile(file)) != null) {
            String outputPathUrl;
            boolean isTest = projectFileIndex.isInTestSourceContent(file);
            String string = outputPathUrl = isTest ? CompilerModuleExtension.getInstance((Module)module).getCompilerOutputUrlForTests() : CompilerModuleExtension.getInstance((Module)module).getCompilerOutputUrl();
            if (outputPathUrl == null) {
                return null;
            }
            return VirtualFileManager.extractPath((String)outputPathUrl).replace('/', File.separatorChar);
        }
        Module[] allModules = ModuleManager.getInstance((Project)project).getSortedModules();
        if (allModules.length == 0) {
            return null;
        }
        String[] paths = CompilerPathsEx.getOutputPaths((Module[])allModules);
        StringBuffer outputPath = new StringBuffer();
        for (int idx = 0; idx < paths.length; ++idx) {
            String path = paths[idx];
            if (idx > 0) {
                outputPath.append(File.pathSeparator);
            }
            outputPath.append(path);
        }
        return outputPath.toString();
    }
}

