/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;

public class ProjectRootsUtil {
    private ProjectRootsUtil() {
    }

    public static boolean isSourceRoot(PsiDirectory psiDirectory) {
        return psiDirectory.getVirtualFile().equals(ProjectRootManager.getInstance((Project)psiDirectory.getProject()).getFileIndex().getSourceRootForFile(psiDirectory.getVirtualFile()));
    }

    public static boolean isInTestSource(VirtualFile directoryFile, Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInTestSourceContent(directoryFile);
    }

    public static boolean isSourceOrTestRoot(VirtualFile virtualFile, Project project) {
        ContentEntry[] contentEntries;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = projectFileIndex.getModuleForFile(virtualFile);
        if (module == null) {
            return false;
        }
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            SourceFolder[] sourceFolders;
            for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                if (virtualFile != sourceFolder.getFile()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLibraryRoot(VirtualFile directoryFile, Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (projectFileIndex.isInLibraryClasses(directoryFile)) {
            VirtualFile parent = directoryFile.getParent();
            return parent == null || !projectFileIndex.isInLibraryClasses(parent);
        }
        return false;
    }

    public static boolean isModuleContentRoot(VirtualFile directoryFile, Project project) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRootForFile = projectFileIndex.getContentRootForFile(directoryFile);
        return directoryFile.equals(contentRootForFile);
    }
}

