/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Icons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageElementNode
extends ProjectViewNode<PackageElement> {
    public PackageElementNode(Project project, PackageElement value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    public PackageElementNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (PackageElement)value, viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        PsiDirectory[] directories;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/PackageElementNode.contains must not be null");
        }
        if (!this.isUnderContent(file) || this.getValue() == null) {
            return false;
        }
        for (PsiDirectory directory : directories = ((PackageElement)this.getValue()).getPackage().getDirectories()) {
            if (!VfsUtil.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnderContent(VirtualFile file) {
        Module module;
        PackageElement element = (PackageElement)this.getValue();
        Module module2 = module = element == null ? null : element.getModule();
        if (module == null) {
            return ModuleUtil.projectContainsFile((Project)this.getProject(), (VirtualFile)file, (boolean)this.isLibraryElement());
        }
        return ModuleUtil.moduleContainsFile((Module)module, (VirtualFile)file, (boolean)this.isLibraryElement());
    }

    private boolean isLibraryElement() {
        return this.getValue() != null && ((PackageElement)this.getValue()).isLibraryElement();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        PsiDirectory[] dirs;
        List<AbstractTreeNode> list;
        PackageElement value = (PackageElement)this.getValue();
        if (value == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/PackageElementNode.getChildren must not return null");
            return list;
        }
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        Module module = value.getModule();
        PsiPackage aPackage = value.getPackage();
        if (!this.getSettings().isFlattenPackages()) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module, this.myProject, this.isLibraryElement())) {
                PackageUtil.addPackageAsChild(children, subpackage, module, this.getSettings(), this.isLibraryElement());
            }
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(this.myProject, module, this.isLibraryElement());
        for (PsiDirectory dir : dirs = aPackage.getDirectories(scopeToShow)) {
            children.addAll(ProjectViewDirectoryHelper.getInstance(this.myProject).getDirectoryChildren(dir, this.getSettings(), false));
        }
        list = children;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/PackageElementNode.getChildren must not return null");
    }

    protected void update(PresentationData presentation) {
        if (this.getValue() != null && ((PackageElement)this.getValue()).getPackage().isValid()) {
            this.updateValidData(presentation);
        } else {
            this.setValue(null);
        }
    }

    private void updateValidData(PresentationData presentation) {
        PackageElement value = (PackageElement)this.getValue();
        PsiPackage aPackage = value.getPackage();
        String qName = aPackage.getQualifiedName();
        if (!this.getSettings().isFlattenPackages() && this.getSettings().isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, value.getModule(), true, this.isLibraryElement())) {
            this.setValue(null);
            return;
        }
        PsiPackage parentPackage = this.getParentValue() instanceof PackageElement ? ((PackageElement)this.getParentValue()).getPackage() : null;
        String name = PackageUtil.getNodeName(this.getSettings(), aPackage, parentPackage, qName, this.showFQName(aPackage));
        presentation.setPresentableText(name);
        presentation.setOpenIcon(Icons.PACKAGE_OPEN_ICON);
        presentation.setClosedIcon(Icons.PACKAGE_ICON);
        for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
            decorator.decorate(this, presentation);
        }
    }

    private boolean showFQName(PsiPackage aPackage) {
        return this.getSettings().isFlattenPackages() && aPackage.getQualifiedName().length() > 0;
    }

    public String getTestPresentation() {
        PresentationData presentation = new PresentationData();
        this.update(presentation);
        return "PsiPackage: " + presentation.getPresentableText();
    }

    public boolean valueIsCut() {
        return this.getValue() != null && CopyPasteManager.getInstance().isCutElement((Object)((PackageElement)this.getValue()).getPackage());
    }

    public VirtualFile[] getVirtualFiles() {
        PsiDirectory[] directories = ((PackageElement)this.getValue()).getPackage().getDirectories(PackageUtil.getScopeToShow(this.getProject(), ((PackageElement)this.getValue()).getModule(), this.isLibraryElement()));
        VirtualFile[] result = new VirtualFile[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            PsiDirectory directory = directories[i];
            result[i] = directory.getVirtualFile();
        }
        return result;
    }

    public boolean canRepresent(Object element) {
        if (super.canRepresent(element)) {
            return true;
        }
        PackageElement value = (PackageElement)this.getValue();
        if (value == null) {
            return true;
        }
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            PsiPackage otherPackage = packageElement.getPackage();
            PsiPackage aPackage = value.getPackage();
            if (otherPackage != null && aPackage != null && Comparing.equal((String)otherPackage.getQualifiedName(), (String)aPackage.getQualifiedName())) {
                return true;
            }
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            return Arrays.asList(((PackageElement)this.getValue()).getPackage().getDirectories()).contains(directory);
        }
        return false;
    }

    public int getWeight() {
        return 0;
    }

    public String getTitle() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement != null) {
            return packageElement.getPackage().getQualifiedName();
        }
        return super.getTitle();
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement != null) {
            return packageElement.getPackage().getQualifiedName();
        }
        return null;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 4;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }
}

