/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.AddAllMembersProcessor;
import com.intellij.ide.structureView.impl.java.ClassInitializerTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.structureView.impl.java.PsiFieldTreeElement;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaClassTreeElement
extends JavaClassTreeElementBase<PsiClass> {
    public JavaClassTreeElement(PsiClass aClass, boolean inherited) {
        super(inherited, aClass);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        Collection<StructureViewTreeElement> collection = this.getClassChildren();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/JavaClassTreeElement.getChildrenBase must not return null");
        }
        return collection;
    }

    private Collection<StructureViewTreeElement> getClassChildren() {
        ArrayList<StructureViewTreeElement> array = new ArrayList<StructureViewTreeElement>();
        PsiClass aClass = (PsiClass)this.getElement();
        if (aClass == null) {
            return array;
        }
        List<PsiElement> children = Arrays.asList(aClass.getChildren());
        THashSet ownChildren = new THashSet();
        ownChildren.addAll(Arrays.asList(aClass.getFields()));
        ownChildren.addAll(Arrays.asList(aClass.getMethods()));
        ownChildren.addAll(Arrays.asList(aClass.getInnerClasses()));
        ownChildren.addAll(Arrays.asList(aClass.getInitializers()));
        LinkedHashSet<PsiElement> inherited = new LinkedHashSet<PsiElement>(children);
        aClass.processDeclarations((PsiScopeProcessor)new AddAllMembersProcessor(inherited, aClass), ResolveState.initial(), null, (PsiElement)aClass);
        for (PsiElement child : inherited) {
            boolean isInherited;
            if (!child.isValid()) continue;
            boolean bl = isInherited = !ownChildren.contains(child);
            if (child instanceof PsiClass) {
                array.add(new JavaClassTreeElement((PsiClass)child, isInherited));
                continue;
            }
            if (child instanceof PsiField) {
                array.add(new PsiFieldTreeElement((PsiField)child, isInherited));
                continue;
            }
            if (child instanceof PsiMethod) {
                array.add(new PsiMethodTreeElement((PsiMethod)child, isInherited));
                continue;
            }
            if (!(child instanceof PsiClassInitializer)) continue;
            array.add(new ClassInitializerTreeElement((PsiClassInitializer)child));
        }
        return array;
    }

    public String getPresentableText() {
        return ((PsiClass)this.getElement()).getName();
    }

    @Override
    public boolean isPublic() {
        return ((PsiClass)this.getElement()).getParent() instanceof PsiFile || super.isPublic();
    }
}

