/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.Icons;
import com.intellij.util.StringBuilderSpinAllocator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectLayoutPanel<T>
extends JPanel {
    private static final Icon ICON_MODULE = IconLoader.getIcon((String)"/nodes/ModuleClosed.png");
    private static final Icon RENAME_ICON = IconLoader.getIcon((String)"/modules/edit.png");
    private static final Icon MERGE_ICON = IconLoader.getIcon((String)"/modules/merge.png");
    private static final Icon SPLIT_ICON = IconLoader.getIcon((String)"/modules/split.png");
    private final ElementsChooser<T> myEntriesChooser;
    private final JList myDependenciesList;
    private final ModuleInsight myInsight;
    private final Comparator<T> COMPARATOR = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            int w2;
            int w1 = ProjectLayoutPanel.this.getWeight(o1);
            if (w1 != (w2 = ProjectLayoutPanel.this.getWeight(o2))) {
                return w1 - w2;
            }
            return ProjectLayoutPanel.getElementText(o1).compareToIgnoreCase(ProjectLayoutPanel.getElementText(o2));
        }
    };

    public ProjectLayoutPanel(ModuleInsight insight) {
        super(new BorderLayout());
        this.myInsight = insight;
        this.myEntriesChooser = new ElementsChooser<T>(true){

            @Override
            public String getItemText(@NotNull T element) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/importProject/ProjectLayoutPanel$2.getItemText must not be null");
                }
                return ProjectLayoutPanel.getElementText(element);
            }
        };
        this.myDependenciesList = this.createList();
        Splitter splitter = new Splitter(false);
        JScrollPane entriesPane = new JScrollPane(this.myEntriesChooser);
        entriesPane.setBorder(BorderFactory.createTitledBorder(this.getEntriesChooserTitle()));
        splitter.setFirstComponent((JComponent)entriesPane);
        JScrollPane depsPane = new JScrollPane(this.myDependenciesList);
        depsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getDependenciesTitle()), depsPane.getBorder()));
        splitter.setSecondComponent((JComponent)depsPane);
        JPanel groupPanel = new JPanel(new BorderLayout());
        groupPanel.add((Component)this.createEntriesActionToolbar().getComponent(), "North");
        groupPanel.add((Component)splitter, "Center");
        groupPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        MultiLineLabel description = new MultiLineLabel(this.getStepDescriptionText());
        description.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.add((Component)description, "North");
        this.add((Component)groupPanel, "Center");
        this.myEntriesChooser.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                List entries = ProjectLayoutPanel.this.getSelectedEntries();
                Collection deps = ProjectLayoutPanel.this.getDependencies(entries);
                DefaultListModel depsModel = (DefaultListModel)ProjectLayoutPanel.this.myDependenciesList.getModel();
                depsModel.clear();
                for (Object dep : ProjectLayoutPanel.this.alphaSortList(new ArrayList(deps))) {
                    depsModel.addElement(dep);
                }
            }
        });
    }

    private ActionToolbar createEntriesActionToolbar() {
        DefaultActionGroup entriesActions = new DefaultActionGroup();
        RenameAction rename = new RenameAction();
        rename.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(117, 64)), this);
        entriesActions.add((AnAction)rename);
        MergeAction merge = new MergeAction();
        merge.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(114, 0)), this);
        entriesActions.add((AnAction)merge);
        SplitAction split = new SplitAction();
        split.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), this);
        entriesActions.add((AnAction)split);
        return ActionManager.getInstance().createActionToolbar("ProjectLayoutPanel.Entries", (ActionGroup)entriesActions, true);
    }

    public final ModuleInsight getInsight() {
        return this.myInsight;
    }

    private JList createList() {
        JList<Object> list = new JList<Object>(new DefaultListModel());
        list.getSelectionModel().setSelectionMode(2);
        list.setCellRenderer(new MyListCellRenderer());
        return list;
    }

    public final Collection getDependencies(List<T> entries) {
        HashSet deps = new HashSet();
        for (T et : entries) {
            deps.addAll(this.getDependencies(et));
        }
        return deps;
    }

    public List<T> getSelectedEntries() {
        return this.myEntriesChooser.getSelectedElements();
    }

    public List<T> getChosenEntries() {
        return this.myEntriesChooser.getMarkedElements();
    }

    public void rebuild() {
        this.myEntriesChooser.clear();
        for (T entry : this.alphaSortList(this.getEntries())) {
            this.myEntriesChooser.addElement(entry, true, new EntryProperties(entry));
        }
        if (this.myEntriesChooser.getElementCount() > 0) {
            this.myEntriesChooser.selectElements(Collections.singleton(this.myEntriesChooser.getElementAt(0)));
        }
    }

    private List<T> alphaSortList(List<T> entries) {
        Collections.sort(entries, this.COMPARATOR);
        return entries;
    }

    @Nullable
    protected Icon getElementIcon(Object element) {
        if (element instanceof ModuleDescriptor) {
            return ICON_MODULE;
        }
        if (element instanceof LibraryDescriptor) {
            return Icons.LIBRARY_ICON;
        }
        if (element instanceof File) {
            File file = (File)element;
            return file.isDirectory() ? Icons.DIRECTORY_CLOSED_ICON : Icons.JAR_ICON;
        }
        return null;
    }

    protected int getWeight(Object element) {
        if (element instanceof File) {
            return 10;
        }
        if (element instanceof ModuleDescriptor) {
            return 20;
        }
        if (element instanceof LibraryDescriptor) {
            return ((LibraryDescriptor)element).getJars().size() > 1 ? 30 : 40;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getElementText(Object element) {
        if (element instanceof LibraryDescriptor) {
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                Object parentFile2;
                builder.append(((LibraryDescriptor)element).getName());
                Collection<File> jars = ((LibraryDescriptor)element).getJars();
                if (jars.size() == 1 && (parentFile2 = jars.iterator().next().getParentFile()) != null) {
                    builder.append(" (");
                    builder.append(((File)parentFile2).getPath());
                    builder.append(")");
                }
                parentFile2 = builder.toString();
                return parentFile2;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
        if (element instanceof File) {
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                builder.append(((File)element).getName());
                File parentFile = ((File)element).getParentFile();
                if (parentFile != null) {
                    builder.append(" (");
                    builder.append(parentFile.getPath());
                    builder.append(")");
                }
                String parentFile2 = builder.toString();
                return parentFile2;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
        if (element instanceof ModuleDescriptor) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)element;
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                Set<File> sourceRoots;
                builder.append(moduleDescriptor.getName());
                Set<File> contents = moduleDescriptor.getContentRoots();
                int rootCount = contents.size();
                if (rootCount > 0) {
                    builder.append(" (");
                    builder.append(contents.iterator().next().getPath());
                    if (rootCount > 1) {
                        builder.append("...");
                    }
                    builder.append(")");
                }
                if ((sourceRoots = moduleDescriptor.getSourceRoots()).size() > 0) {
                    builder.append(" [");
                    Iterator<File> it = sourceRoots.iterator();
                    while (it.hasNext()) {
                        File root = it.next();
                        builder.append(root.getName());
                        if (!it.hasNext()) continue;
                        builder.append(",");
                    }
                    builder.append("]");
                }
                String string = builder.toString();
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
        return "";
    }

    protected abstract List<T> getEntries();

    protected abstract Collection getDependencies(T var1);

    @Nullable
    protected abstract T merge(List<T> var1);

    @Nullable
    protected abstract T split(T var1, String var2, Collection<File> var3);

    protected abstract Collection<File> getContent(T var1);

    protected abstract String getElementName(T var1);

    protected abstract void setElementName(T var1, String var2);

    protected abstract String getSplitDialogTitle();

    protected abstract String getSplitDialogChooseFilesPrompt();

    protected abstract String getNameAlreadyUsedMessage(String var1);

    protected abstract String getStepDescriptionText();

    protected abstract String getEntriesChooserTitle();

    protected abstract String getDependenciesTitle();

    private boolean isNameAlreadyUsed(String entryName) {
        HashSet<T> itemsToIgnore = new HashSet<T>(this.myEntriesChooser.getSelectedElements());
        for (T entry : this.getEntries()) {
            if (itemsToIgnore.contains(entry) || !entryName.equals(this.getElementName(entry))) continue;
            return true;
        }
        return false;
    }

    private class EntryProperties
    implements ElementsChooser.ElementProperties {
        private final T myEntry;

        public EntryProperties(T entry) {
            this.myEntry = entry;
        }

        @Override
        public Icon getIcon() {
            return ProjectLayoutPanel.this.getElementIcon(this.myEntry);
        }

        @Override
        public Color getColor() {
            return null;
        }
    }

    private class SplitDialog
    extends DialogWrapper {
        final JTextField myNameField;
        final ElementsChooser<File> myChooser;

        private SplitDialog(Collection<File> files) {
            super((Component)ProjectLayoutPanel.this.myEntriesChooser, true);
            this.setTitle(ProjectLayoutPanel.this.getSplitDialogTitle());
            this.myNameField = new JTextField();
            this.myChooser = new ElementsChooser<File>(true){

                @Override
                protected String getItemText(@NotNull File value) {
                    if (value == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/importProject/ProjectLayoutPanel$SplitDialog$1.getItemText must not be null");
                    }
                    return ProjectLayoutPanel.getElementText(value);
                }
            };
            for (final File file : files) {
                this.myChooser.addElement(file, false, new ElementsChooser.ElementProperties(){

                    @Override
                    public Icon getIcon() {
                        return ProjectLayoutPanel.this.getElementIcon(file);
                    }

                    @Override
                    public Color getColor() {
                        return null;
                    }
                });
            }
            this.init();
        }

        protected void doOKAction() {
            String name = this.getName();
            if (ProjectLayoutPanel.this.isNameAlreadyUsed(name)) {
                Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(name), (String)"");
                return;
            }
            super.doOKAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            JPanel labelNameField = new JPanel(new BorderLayout());
            labelNameField.add((Component)new JLabel("Name:"), "North");
            labelNameField.add((Component)this.myNameField, "Center");
            labelNameField.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel labelChooser = new JPanel(new BorderLayout());
            labelChooser.add((Component)new JLabel(ProjectLayoutPanel.this.getSplitDialogChooseFilesPrompt()), "North");
            labelChooser.add((Component)new JScrollPane(this.myChooser), "Center");
            labelChooser.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)labelNameField, "North");
            panel.add((Component)labelChooser, "Center");
            panel.setPreferredSize(new Dimension(450, 300));
            return panel;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myNameField;
        }

        public String getName() {
            return this.myNameField.getText().trim();
        }

        public Collection<File> getChosenFiles() {
            return this.myChooser.getMarkedElements();
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(ProjectLayoutPanel.getElementText(value));
            this.setIcon(ProjectLayoutPanel.this.getElementIcon(value));
            return comp;
        }
    }

    private class RenameAction
    extends AnAction {
        private RenameAction() {
            super("Rename", "", RENAME_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            List elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements();
            if (elements.size() == 1) {
                Object element = elements.get(0);
                String newName = Messages.showInputDialog((Component)ProjectLayoutPanel.this, (String)("Enter new name for " + ProjectLayoutPanel.getElementText(element)), (String)"Rename", (Icon)Messages.getQuestionIcon(), (String)ProjectLayoutPanel.this.getElementName(element), (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return true;
                    }

                    public boolean canClose(String inputString) {
                        if (ProjectLayoutPanel.this.isNameAlreadyUsed(inputString.trim())) {
                            Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(inputString), (String)"");
                            return false;
                        }
                        return true;
                    }
                });
                if (newName != null) {
                    ProjectLayoutPanel.this.setElementName(element, newName);
                    ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                    ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(element));
                }
            }
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements().size() == 1);
        }
    }

    private class SplitAction
    extends AnAction {
        private SplitAction() {
            super("Split", "", SPLIT_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            List elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements();
            if (elements.size() == 1) {
                Collection<File> chosenFiles;
                String newName;
                Object extracted;
                Object entry = elements.get(0);
                Collection<File> files = ProjectLayoutPanel.this.getContent(entry);
                SplitDialog dialog = new SplitDialog(files);
                dialog.show();
                if (dialog.isOK() && (extracted = ProjectLayoutPanel.this.split(entry, newName = dialog.getName(), chosenFiles = dialog.getChosenFiles())) != null) {
                    if (!ProjectLayoutPanel.this.getEntries().contains(entry)) {
                        ProjectLayoutPanel.this.myEntriesChooser.removeElement(entry);
                    }
                    ProjectLayoutPanel.this.myEntriesChooser.addElement(extracted, true, new EntryProperties(extracted));
                    ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                    ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(extracted));
                }
            }
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements().size() == 1);
        }
    }

    private class MergeAction
    extends AnAction {
        private MergeAction() {
            super("Merge", "", MERGE_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            String newName;
            List elements = ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements();
            if (elements.size() > 1 && (newName = Messages.showInputDialog((Component)ProjectLayoutPanel.this, (String)"Enter new name for merge result:", (String)"Merge", (Icon)Messages.getQuestionIcon(), (String)ProjectLayoutPanel.this.getElementName(elements.get(0)), (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return true;
                }

                public boolean canClose(String inputString) {
                    if (ProjectLayoutPanel.this.isNameAlreadyUsed(inputString.trim())) {
                        Messages.showErrorDialog((String)ProjectLayoutPanel.this.getNameAlreadyUsedMessage(inputString), (String)"");
                        return false;
                    }
                    return true;
                }
            })) != null) {
                Object merged = ProjectLayoutPanel.this.merge(elements);
                ProjectLayoutPanel.this.setElementName(merged, newName);
                for (Object element : elements) {
                    ProjectLayoutPanel.this.myEntriesChooser.removeElement(element);
                }
                ProjectLayoutPanel.this.myEntriesChooser.addElement(merged, true, new EntryProperties(merged));
                ProjectLayoutPanel.this.myEntriesChooser.sort(ProjectLayoutPanel.this.COMPARATOR);
                ProjectLayoutPanel.this.myEntriesChooser.selectElements(Collections.singleton(merged));
            }
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(ProjectLayoutPanel.this.myEntriesChooser.getSelectedElements().size() > 1);
        }
    }
}

