/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.EmptyMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.HashMap;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MockDocument
implements DocumentEx {
    private final Map myUserData = new HashMap();
    private StringBuffer myText = new StringBuffer();
    private long myModStamp = LocalTimeCounter.currentTime();

    public MockDocument() {
    }

    public MockDocument(String text) {
        this.myText.append(text);
    }

    public String getText() {
        return this.myText.toString();
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.replaceText must not be null");
        }
        this.myText = new StringBuffer();
        this.myText.append(chars);
        this.myModStamp = newModificationStamp;
    }

    @Override
    public int getListenersCount() {
        return 0;
    }

    public CharSequence textToCharArray() {
        return this.getText();
    }

    @NotNull
    public char[] getChars() {
        char[] cArray = this.getText().toCharArray();
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.getChars must not return null");
        }
        return cArray;
    }

    @NotNull
    public CharSequence getCharsSequence() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.getCharsSequence must not return null");
        }
        return string;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.myText.length();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockDocument.insertString must not be null");
        }
        this.myText.insert(offset, s);
    }

    public void deleteString(int startOffset, int endOffset) {
        this.myText.delete(startOffset, endOffset);
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/mock/MockDocument.replaceString must not be null");
        }
        this.myText.replace(startOffset, endOffset, ((Object)s).toString());
        this.myModStamp = LocalTimeCounter.currentTime();
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return this.myModStamp;
    }

    public void fireReadOnlyModificationAttempt() {
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.addDocumentListener must not be null");
        }
    }

    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.addDocumentListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/mock/MockDocument.addDocumentListener must not be null");
        }
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.removeDocumentListener must not be null");
        }
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        if (null == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.createRangeMarker must not return null");
        }
        return null;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (null == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.createRangeMarker must not return null");
        }
        return null;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        if (null == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.getMarkupModel must not return null");
        }
        return null;
    }

    @NotNull
    public MarkupModel getMarkupModel(Project project) {
        EmptyMarkupModel emptyMarkupModel = new EmptyMarkupModel(this);
        if (emptyMarkupModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.getMarkupModel must not return null");
        }
        return emptyMarkupModel;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.addPropertyChangeListener must not be null");
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.removePropertyChangeListener must not be null");
        }
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.getUserData must not be null");
        }
        return (T)this.myUserData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.putUserData must not be null");
        }
        this.myUserData.put(key, value);
    }

    @Override
    public void stripTrailingSpaces(boolean inChangedLinesOnly) {
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
    }

    public int getLineSeparatorLength(int line) {
        return 0;
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        if (null == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.createLineIterator must not return null");
        }
        return null;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModStamp = modificationStamp;
    }

    public void setReadOnly(boolean isReadOnly) {
    }

    public RangeMarker getRangeGuard(int start, int end) {
        return null;
    }

    public void startGuardedBlockChecking() {
    }

    public void stopGuardedBlockChecking() {
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        if (null == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.createGuardedBlock must not return null");
        }
        return null;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.removeGuardedBlock must not be null");
        }
    }

    public RangeMarker getOffsetGuard(int offset) {
        return null;
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.addEditReadOnlyListener must not be null");
        }
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.removeEditReadOnlyListener must not be null");
        }
    }

    @Override
    public void suppressGuardedExceptions() {
    }

    @Override
    public void unSuppressGuardedExceptions() {
    }

    @Override
    public boolean isInEventsHandling() {
        return false;
    }

    @Override
    public void clearLineModificationFlags() {
    }

    @Override
    public void removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.removeRangeMarker must not be null");
        }
    }

    @Override
    public void addRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.addRangeMarker must not be null");
        }
    }

    @Override
    public boolean isInBulkUpdate() {
        return false;
    }

    @Override
    public void setInBulkUpdate(boolean value) {
    }

    public void setCyclicBufferSize(int bufferSize) {
    }

    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.setText must not be null");
        }
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockDocument.createRangeMarker must not be null");
        }
        RangeMarker rangeMarker = this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.createRangeMarker must not return null");
        }
        return rangeMarker;
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockDocument.getGuardedBlocks must not return null");
        }
        return list;
    }
}

