/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.ComponentStoreImpl;
import com.intellij.openapi.components.impl.stores.DefaultsStateStorage;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

class ApplicationStoreImpl
extends ComponentStoreImpl
implements IApplicationStore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.ApplicationStoreImpl");
    @NonNls
    private static final String XML_EXTENSION = ".xml";
    private final ApplicationImpl myApplication;
    private final StateStorageManager myStateStorageManager;
    @NonNls
    private static final String APP_CONFIG_STORAGE_MACRO = "APP_CONFIG";
    @NonNls
    private static final String OPTIONS_MACRO = "OPTIONS";
    @NonNls
    private static final String CONFIG_MACRO = "ROOT_CONFIG";
    private final DefaultsStateStorage myDefaultsStateStorage;
    @NonNls
    private static final String ROOT_ELEMENT_NAME = "application";
    public static final String DEFAULT_STORAGE_SPEC = "$APP_CONFIG$/other.xml";

    public ApplicationStoreImpl(ApplicationImpl application, PathMacroManager pathMacroManager) {
        this.myApplication = application;
        this.myStateStorageManager = new StateStorageManagerImpl(pathMacroManager.createTrackingSubstitutor(), ROOT_ELEMENT_NAME, (Disposable)application, (PicoContainer)application.getPicoContainer()){

            @Override
            protected XmlElementStorage.StorageData createStorageData(String storageSpec) {
                return new FileBasedStorage.FileStorageData(ApplicationStoreImpl.ROOT_ELEMENT_NAME);
            }

            @Override
            protected String getOldStorageSpec(Object component, String componentName, StateStorageOperation operation) {
                String fileName = component instanceof NamedJDOMExternalizable ? "$APP_CONFIG$/" + ((NamedJDOMExternalizable)component).getExternalFileName() + ApplicationStoreImpl.XML_EXTENSION : ApplicationStoreImpl.DEFAULT_STORAGE_SPEC;
                return fileName;
            }

            @Override
            protected String getVersionsFilePath() {
                return PathManager.getConfigPath() + "/options/" + "appComponentVersions.xml";
            }

            @Override
            protected TrackingPathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
                if (fileSpec == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/ApplicationStoreImpl$1.getMacroSubstitutor must not be null");
                }
                if (fileSpec.equals("$APP_CONFIG$/path.macros.xml")) {
                    return null;
                }
                return super.getMacroSubstitutor(fileSpec);
            }
        };
        this.myDefaultsStateStorage = new DefaultsStateStorage(null);
    }

    public void initStore() {
    }

    @Override
    public void load() throws IOException {
        this.myApplication.initComponents();
    }

    @Override
    public void setOptionsPath(String path) {
        this.myStateStorageManager.addMacro(APP_CONFIG_STORAGE_MACRO, path);
        this.myStateStorageManager.addMacro(OPTIONS_MACRO, path);
    }

    @Override
    public void setConfigPath(String configPath) {
        this.myStateStorageManager.addMacro(CONFIG_MACRO, configPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reload(Set<Pair<VirtualFile, StateStorage>> changedFiles, Collection<String> notReloadableComponents) throws StateStorage.StateStorageException, IOException {
        IComponentStore.SaveSession saveSession = this.startSave();
        Set<String> componentNames = saveSession.analyzeExternalChanges(changedFiles);
        try {
            if (componentNames == null) {
                boolean bl = false;
                return bl;
            }
            for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                if (pair.second != null) continue;
                boolean bl = false;
                return bl;
            }
            for (String name : componentNames) {
                if (this.isReloadPossible(Collections.singleton(name))) continue;
                notReloadableComponents.add(name);
            }
            if (!componentNames.isEmpty()) {
                StorageUtil.logStateDiffInfo(changedFiles, componentNames);
            }
            if (!this.isReloadPossible(componentNames)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.finishSave(saveSession);
        }
        if (!componentNames.isEmpty()) {
            ((BatchUpdateListener)this.myApplication.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateStarted();
            try {
                this.doReload(changedFiles, componentNames);
                this.reinitComponents(componentNames, false);
            }
            finally {
                ((BatchUpdateListener)this.myApplication.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC)).onBatchUpdateFinished();
            }
        }
        return true;
    }

    @Override
    public StateStorageManager getStateStorageManager() {
        return this.myStateStorageManager;
    }

    @Override
    protected StateStorage getDefaultsStorage() {
        return this.myDefaultsStateStorage;
    }
}

