/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.FrameWrapper;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JDialog;
import org.jetbrains.annotations.Nullable;

class FrameDiffTool
implements DiffTool {
    FrameDiffTool() {
    }

    public void show(DiffRequest request) {
        Collection hints = request.getHints();
        boolean shouldOpenDialog = FrameDiffTool.shouldOpenDialog(hints);
        if (shouldOpenDialog) {
            final DialogBuilder builder = new DialogBuilder(request.getProject());
            DiffPanelImpl diffPanel = FrameDiffTool.createDiffPanelIfShouldShow(request, builder.getWindow());
            if (diffPanel == null) {
                return;
            }
            builder.setCenterPanel(diffPanel.getComponent());
            builder.addDisposable((Disposable)diffPanel);
            builder.setPreferedFocusComponent(diffPanel.getPreferredFocusedComponent());
            builder.removeAllActions();
            builder.setTitle(request.getWindowTitle());
            builder.setDimensionServiceKey(request.getGroupKey());
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    builder.getDialogWrapper().close(0);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseEditor")), diffPanel.getComponent());
            FrameDiffTool.showDiffDialog(builder, hints);
        } else {
            final FrameWrapper frameWrapper = new FrameWrapper(request.getGroupKey());
            DiffPanelImpl diffPanel = FrameDiffTool.createDiffPanelIfShouldShow(request, frameWrapper.getFrame());
            if (diffPanel == null) {
                return;
            }
            frameWrapper.setTitle(request.getWindowTitle());
            DiffUtil.initDiffFrame(frameWrapper, diffPanel);
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    frameWrapper.getFrame().dispose();
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseEditor")), diffPanel.getComponent());
            frameWrapper.show();
        }
    }

    @Nullable
    private static DiffPanelImpl createDiffPanelIfShouldShow(DiffRequest request, Window window) {
        DiffPanelImpl diffPanel = (DiffPanelImpl)DiffManagerImpl.createDiffPanel(request, window);
        if (FrameDiffTool.checkNoDifferenceAndNotify(diffPanel, request, window)) {
            diffPanel.dispose();
            diffPanel = null;
        }
        return diffPanel;
    }

    private static void showDiffDialog(DialogBuilder builder, Collection hints) {
        builder.showModal(!hints.contains(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG));
    }

    private static boolean shouldOpenDialog(Collection hints) {
        if (hints.contains(DiffTool.HINT_SHOW_MODAL_DIALOG)) {
            return true;
        }
        if (hints.contains(DiffTool.HINT_SHOW_NOT_MODAL_DIALOG)) {
            return true;
        }
        if (hints.contains(DiffTool.HINT_SHOW_FRAME)) {
            return false;
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof JDialog;
    }

    private static boolean checkNoDifferenceAndNotify(DiffPanel diffPanel, DiffRequest data, Window window) {
        if (!diffPanel.hasDifferences() && !data.getHints().contains(HINT_ALLOW_NO_DIFFERENCES)) {
            DiffManagerImpl manager = (DiffManagerImpl)DiffManager.getInstance();
            if (!Comparing.equal((Object)manager.getComparisonPolicy(), (Object)ComparisonPolicy.DEFAULT)) {
                ComparisonPolicy oldPolicy = manager.getComparisonPolicy();
                manager.setComparisonPolicy(ComparisonPolicy.DEFAULT);
                DiffPanel maybeDiffPanel = DiffManagerImpl.createDiffPanel(data, window);
                manager.setComparisonPolicy(oldPolicy);
                boolean hasDiffs = maybeDiffPanel.hasDifferences();
                maybeDiffPanel.dispose();
                if (hasDiffs) {
                    return false;
                }
            }
            return !FrameDiffTool.askForceOpenDiff(data);
        }
        return false;
    }

    private static boolean askForceOpenDiff(DiffRequest data) {
        byte[] bytes2;
        byte[] bytes1;
        try {
            bytes1 = data.getContents()[0].getBytes();
            bytes2 = data.getContents()[1].getBytes();
        }
        catch (IOException e) {
            MessagesEx.error(data.getProject(), e.getMessage()).showNow();
            return false;
        }
        String message = Arrays.equals(bytes1, bytes2) ? DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]) : DiffBundle.message((String)"diff.contents.have.differences.only.in.line.separators.message.text", (Object[])new Object[0]);
        Messages.showInfoMessage((Project)data.getProject(), (String)message, (String)DiffBundle.message((String)"no.differences.dialog.title", (Object[])new Object[0]));
        return false;
    }

    public boolean canShow(DiffRequest data) {
        DiffContent[] contents = data.getContents();
        if (contents.length != 2) {
            return false;
        }
        for (DiffContent content : contents) {
            if (content.isBinary()) {
                return false;
            }
            VirtualFile file = content.getFile();
            if (file == null || !file.isDirectory()) continue;
            return false;
        }
        return true;
    }
}

