/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.util.ContextLogger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;

class MergeBuilder {
    private final ContextLogger LOG;
    private final int[] myProcessed = new int[]{0, 0, 0};
    private final ArrayList<MergeFragment> myResult = new ArrayList();
    private final EqualPair[] myPairs = new EqualPair[2];

    public MergeBuilder(ContextLogger log) {
        this.LOG = log;
    }

    public void add(TextRange base, TextRange version, FragmentSide side) {
        this.LOG.assertTrue(base.getLength() == version.getLength());
        this.myPairs[side.getIndex()] = new EqualPair(base.getStartOffset(), version.getStartOffset(), base.getLength(), side, this.LOG);
        if (this.myPairs[side.otherSide().getIndex()] == null) {
            return;
        }
        if (this.myPairs[0].baseStartFrom(this.myProcessed) && this.myPairs[1].baseStartFrom(this.myProcessed)) {
            this.processInsertOrConflict();
            return;
        }
        if (this.processNoIntersection()) {
            return;
        }
        for (int i = 0; i < this.myPairs.length; ++i) {
            EqualPair pair = this.myPairs[i];
            if (!pair.startsFrom(this.myProcessed)) continue;
            this.processDeleteOrChange(FragmentSide.fromIndex((int)i).otherSide());
            return;
        }
        if (!this.removeSingleSideBase()) {
            return;
        }
        this.LOG.assertTrue(this.myPairs[0].getBase() == this.myPairs[1].getBase());
        this.LOG.assertTrue(this.myPairs[0].getBase() > this.myProcessed[1]);
        this.addMergeFragment(this.myPairs[0].processVersion(this.myProcessed), this.proccesBaseChange(this.myPairs[0]), this.myPairs[1].processVersion(this.myProcessed));
        this.skipProcessed();
    }

    private boolean processNoIntersection() {
        FragmentSide firstSide = this.getFirstSide();
        int firstIndex = firstSide.getIndex();
        if (this.myPairs[firstIndex].getBaseEnd() <= this.myPairs[firstSide.otherSide().getIndex()].getBase()) {
            this.myPairs[firstIndex] = null;
            return true;
        }
        return false;
    }

    private boolean removeSingleSideBase() {
        FragmentSide firstSide = this.getFirstSide();
        int firstIndex = firstSide.getIndex();
        int singleSideDelta = this.myPairs[firstSide.otherSide().getIndex()].getBase() - this.myPairs[firstIndex].getBase();
        if (singleSideDelta >= this.myPairs[firstIndex].getLength()) {
            this.LOG.notTested();
            this.myPairs[firstIndex] = null;
            return false;
        }
        if (!this.myPairs[firstIndex].cutHead(singleSideDelta)) {
            this.LOG.notTested();
            this.myPairs[firstIndex] = null;
            return false;
        }
        return true;
    }

    private FragmentSide getFirstSide() {
        return this.myPairs[0].getBase() < this.myPairs[1].getBase() ? FragmentSide.SIDE1 : FragmentSide.SIDE2;
    }

    private void processDeleteOrChange(FragmentSide side) {
        EqualPair workingPair = this.myPairs[side.getIndex()];
        EqualPair otherPair = this.myPairs[side.otherSide().getIndex()];
        this.LOG.assertTrue(!workingPair.baseStartFrom(this.myProcessed) && otherPair.baseStartFrom(this.myProcessed));
        TextRange versionChange = workingPair.processVersion(this.myProcessed);
        TextRange baseChange = new TextRange(this.myProcessed[1], workingPair.getBase());
        int changeLength = workingPair.getBase() - this.myProcessed[1];
        this.myProcessed[1] = this.myProcessed[1] + changeLength;
        int n = otherPair.getSide().getMergeIndex();
        this.myProcessed[n] = this.myProcessed[n] + changeLength;
        this.myProcessed[side.getMergeIndex()] = workingPair.getVersion();
        boolean stillValid = otherPair.cutHead(changeLength);
        this.LOG.assertTrue(stillValid);
        this.myResult.add(MergeFragment.notConflict(baseChange, versionChange, side));
        this.skipProcessed();
    }

    private TextRange proccesBaseChange(EqualPair workingPair) {
        int base = workingPair.getBase();
        TextRange change = new TextRange(this.myProcessed[1], base);
        int otherBase = this.myPairs[workingPair.getSide().otherSide().getIndex()].getBase();
        this.LOG.assertTrue(otherBase >= base);
        this.myProcessed[1] = base;
        return change;
    }

    private void processInsertOrConflict() {
        boolean leftVersionProcessed = this.myPairs[0].versionStartsFrom(this.myProcessed);
        boolean rightVersionProcessed = this.myPairs[1].versionStartsFrom(this.myProcessed);
        TextRange emptyBase = new TextRange(this.myProcessed[1], this.myProcessed[1]);
        if (!leftVersionProcessed && rightVersionProcessed) {
            this.addMergeFragment(this.myPairs[0].processVersion(this.myProcessed), emptyBase, null);
        } else if (!rightVersionProcessed && leftVersionProcessed) {
            this.addMergeFragment(null, emptyBase, this.myPairs[1].processVersion(this.myProcessed));
        } else if (!leftVersionProcessed && !rightVersionProcessed) {
            this.addMergeFragment(this.myPairs[0].processVersion(this.myProcessed), emptyBase, this.myPairs[1].processVersion(this.myProcessed));
        }
        this.skipProcessed();
    }

    private void addMergeFragment(TextRange left, TextRange base, TextRange right) {
        this.myResult.add(new MergeFragment(new TextRange[]{left, base, right}));
    }

    private void skipProcessed() {
        this.LOG.assertTrue(this.myProcessed[0] == this.myPairs[0].getVersion());
        this.LOG.assertTrue(this.myProcessed[2] == this.myPairs[1].getVersion());
        this.LOG.assertTrue(this.myPairs[0].getBase() == this.myPairs[1].getBase());
        this.LOG.assertTrue(this.myPairs[0].getBase() == this.myProcessed[1]);
        int processedDelta = Math.min(this.myPairs[0].getBaseEnd(), this.myPairs[1].getBaseEnd()) - this.myProcessed[1];
        this.LOG.assertTrue(processedDelta > 0);
        int i = 0;
        while (i < this.myProcessed.length) {
            int n = i++;
            this.myProcessed[n] = this.myProcessed[n] + processedDelta;
        }
        for (i = 0; i < this.myPairs.length; ++i) {
            if (this.myPairs[i].cutHead(processedDelta)) continue;
            this.myPairs[i] = null;
        }
        this.LOG.assertTrue(this.myPairs[0] == null || this.myPairs[1] == null);
    }

    public List<MergeFragment> finish(int leftLength, int baseLength, int rightLength) {
        int[] lengths = new int[]{leftLength, baseLength, rightLength};
        if (this.isProcessedUpto(lengths)) {
            return this.myResult;
        }
        int[] afterEnds = new int[3];
        for (int i = 0; i < lengths.length; ++i) {
            afterEnds[i] = lengths[i] + 1;
        }
        FragmentSide notProcessedSide = this.getNotProcessedSide();
        if (notProcessedSide == null) {
            this.addTailChange(lengths);
            return this.myResult;
        }
        this.myPairs[notProcessedSide.getIndex()].grow(1);
        FragmentSide processedSide = notProcessedSide.otherSide();
        this.add(this.createRange(lengths, afterEnds, 1), this.createRange(lengths, afterEnds, processedSide.getMergeIndex()), processedSide);
        if (!this.isProcessedUpto(afterEnds)) {
            this.add(this.createRange(lengths, afterEnds, 1), this.createRange(lengths, afterEnds, notProcessedSide.getMergeIndex()), notProcessedSide);
        }
        this.LOG.assertTrue(this.isProcessedUpto(afterEnds));
        return this.myResult;
    }

    private TextRange createRange(int[] starts, int[] ends, int column) {
        return new TextRange(starts[column], ends[column]);
    }

    private void addTailChange(int[] lengths) {
        TextRange[] tailChange = new TextRange[3];
        for (int i = 0; i < tailChange.length; ++i) {
            tailChange[i] = i != 1 && this.myProcessed[i] == lengths[i] ? null : new TextRange(this.myProcessed[i], lengths[i]);
        }
        this.myResult.add(new MergeFragment(tailChange));
    }

    private FragmentSide getNotProcessedSide() {
        EqualPair left = this.myPairs[0];
        EqualPair right = this.myPairs[1];
        this.LOG.assertTrue(left == null || right == null);
        if (left != null) {
            return FragmentSide.SIDE1;
        }
        if (right != null) {
            return FragmentSide.SIDE2;
        }
        return null;
    }

    private boolean isProcessedUpto(int[] lengths) {
        for (int i = 0; i < lengths.length; ++i) {
            int length = lengths[i];
            if (length == this.myProcessed[i]) continue;
            return false;
        }
        return true;
    }

    public static class MergeFragment {
        private final TextRange[] myRanges;

        public MergeFragment(TextRange[] ranges) {
            this.myRanges = ranges;
        }

        public TextRange[] getRanges() {
            return this.myRanges;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MergeFragment)) {
                return false;
            }
            MergeFragment other = (MergeFragment)obj;
            for (int i = 0; i < this.myRanges.length; ++i) {
                TextRange range = this.myRanges[i];
                if (Comparing.equal((Object)range, (Object)other.myRanges[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 0;
            for (int i = 0; i < this.myRanges.length; ++i) {
                TextRange range = this.myRanges[i];
                result ^= range == null ? i : range.hashCode();
            }
            return result;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<");
            for (int i = 0; i < this.myRanges.length; ++i) {
                TextRange range = this.myRanges[i];
                buffer.append(range != null ? range.toString() : "-----");
                if (i == this.myRanges.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(">");
            return buffer.toString();
        }

        public static MergeFragment notConflict(TextRange baseChange, TextRange versionChange, FragmentSide versionSide) {
            TextRange[] ranges = new TextRange[3];
            ranges[1] = baseChange;
            ranges[versionSide.getMergeIndex()] = versionChange;
            ranges[versionSide.otherSide().getMergeIndex()] = null;
            return new MergeFragment(ranges);
        }
    }

    private static class EqualPair {
        private final ContextLogger LOG;
        private int myVersionStart;
        private int myBaseStart;
        private int myLength;
        private final FragmentSide mySide;

        public EqualPair(int baseStart, int versionStart, int length, FragmentSide side, ContextLogger log) {
            this.LOG = log;
            this.myBaseStart = baseStart;
            this.myVersionStart = versionStart;
            this.myLength = length;
            this.mySide = side;
        }

        public boolean startsFrom(int[] bound) {
            return this.versionStartsFrom(bound) && this.baseStartFrom(bound);
        }

        public boolean versionStartsFrom(int[] bound) {
            return this.myVersionStart == bound[this.mySide.getMergeIndex()];
        }

        public boolean baseStartFrom(int[] bound) {
            return this.myBaseStart == bound[1];
        }

        public int getBaseEnd() {
            return this.myBaseStart + this.myLength;
        }

        public int getVersion() {
            return this.myVersionStart;
        }

        public TextRange processVersion(int[] processed) {
            TextRange change = new TextRange(processed[this.mySide.getMergeIndex()], this.getVersion());
            processed[this.mySide.getMergeIndex()] = this.getVersion();
            return change;
        }

        public boolean cutHead(int processedDelta) {
            this.LOG.assertTrue(this.myLength >= processedDelta);
            this.myBaseStart += processedDelta;
            this.myVersionStart += processedDelta;
            this.myLength -= processedDelta;
            return this.myLength > 0;
        }

        public int getBase() {
            return this.myBaseStart;
        }

        public int getLength() {
            return this.myLength;
        }

        public FragmentSide getSide() {
            return this.mySide;
        }

        public void grow(int delta) {
            this.myLength += delta;
        }
    }
}

