/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class ApplyTextFilePatch
extends ApplyFilePatchBase<TextFilePatch> {
    public ApplyTextFilePatch(TextFilePatch patch) {
        super(patch);
    }

    @Override
    @Nullable
    protected ApplyPatchStatus applyChange(VirtualFile fileToPatch) throws IOException, ApplyPatchException {
        StringBuilder newText;
        byte[] fileContents = fileToPatch.contentsToByteArray();
        CharSequence text = LoadTextUtil.getTextByBinaryPresentation(fileContents, fileToPatch);
        ApplyPatchStatus status = ApplyFilePatchBase.applyModifications((TextFilePatch)this.myPatch, text, newText = new StringBuilder());
        if (status != ApplyPatchStatus.ALREADY_APPLIED) {
            Document document = FileDocumentManager.getInstance().getDocument(fileToPatch);
            if (document == null) {
                throw new ApplyPatchException("Failed to set contents for updated file " + fileToPatch.getPath());
            }
            document.setText((CharSequence)newText.toString());
            FileDocumentManager.getInstance().saveDocument(document);
        }
        return status;
    }

    @Override
    protected void applyCreate(VirtualFile newFile) throws IOException, ApplyPatchException {
        Document document = FileDocumentManager.getInstance().getDocument(newFile);
        if (document == null) {
            throw new ApplyPatchException("Failed to set contents for new file " + newFile.getPath());
        }
        document.setText((CharSequence)((TextFilePatch)this.myPatch).getNewFileText());
        FileDocumentManager.getInstance().saveDocument(document);
    }
}

