/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.find.EditorSearchComponent;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import javax.swing.JComponent;

public class IncrementalFindAction
extends EditorAction {
    public IncrementalFindAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void execute(Editor editor, DataContext dataContext) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (!editor.isOneLineMode()) {
                JComponent headerComponent = editor.getHeaderComponent();
                if (headerComponent instanceof EditorSearchComponent) {
                    ((EditorSearchComponent)headerComponent).setInitialText(editor.getSelectionModel().getSelectedText());
                    headerComponent.requestFocus();
                } else {
                    EditorSearchComponent header = new EditorSearchComponent(editor, project);
                    editor.setHeaderComponent((JComponent)header);
                    header.requestFocus();
                }
            }
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            return project != null && !editor.isOneLineMode();
        }
    }
}

