/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.text.CharArrayUtil;

public class SplitLineAction
extends EditorAction {
    public SplitLineAction() {
        super((EditorActionHandler)new Handler());
        this.setEnabledInModalContext(false);
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return Handler.getEnterHandler().isEnabled(editor, dataContext) && !((EditorEx)editor).isEmbeddedIntoDialogWrapper();
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            int offset;
            int lineStart;
            LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
            Document document = editor.getDocument();
            CharSequence chars = document.getCharsSequence();
            CharSequence beforeCaret = chars.subSequence(lineStart = document.getLineStartOffset(document.getLineNumber(offset = editor.getCaretModel().getOffset())), offset);
            if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)beforeCaret)) {
                String strToInsert = "";
                if (beforeCaret != null) {
                    strToInsert = strToInsert + ((Object)beforeCaret).toString();
                }
                strToInsert = strToInsert + "\n";
                document.insertString(lineStart, (CharSequence)strToInsert);
                editor.getCaretModel().moveToOffset(offset);
            } else {
                Handler.getEnterHandler().execute(editor, dataContext);
                editor.getCaretModel().moveToLogicalPosition(caretPosition);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static EditorActionHandler getEnterHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorEnter");
        }
    }
}

