/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.CharArray;
import com.intellij.openapi.editor.impl.DocumentMarkupModelManager;
import com.intellij.openapi.editor.impl.EmptyMarkupModel;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.text.CharArrayUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.DocumentImpl");
    private final List<DocumentListener> myDocumentListeners = new ArrayList<DocumentListener>();
    private final WeakHashMap<RangeMarkerEx, String> myRangeMarkers = new WeakHashMap();
    private final List<RangeMarker> myGuardedBlocks = new ArrayList<RangeMarker>();
    private ReadonlyFragmentModificationHandler myReadonlyFragmentModificationHandler;
    private final LineSet myLineSet = new LineSet();
    private final CharArray myText = new CharArray(0){

        @Override
        protected DocumentEvent beforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
            return DocumentImpl.this.beforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
        }

        @Override
        protected void afterChangedUpdate(DocumentEvent event, long newModificationStamp) {
            DocumentImpl.this.changedUpdate(event, newModificationStamp);
        }
    };
    private boolean myIsReadOnly = false;
    private boolean isStripTrailingSpacesEnabled = true;
    private volatile long myModificationStamp;
    private final ConcurrentMap<Project, MarkupModel> myProjectToMarkupModelMap = new ConcurrentHashMap();
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private volatile MarkupModelEx myMarkupModel;
    private DocumentListener[] myCachedDocumentListeners;
    private final List<EditReadOnlyListener> myReadOnlyListeners = new ArrayList<EditReadOnlyListener>(1);
    private static final Comparator<? super DocumentListener> ourListenersComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return this.getPriority(o1) - this.getPriority(o2);
        }

        private int getPriority(Object o) {
            if (o instanceof PrioritizedDocumentListener) {
                return ((PrioritizedDocumentListener)o).getPriority();
            }
            return Integer.MAX_VALUE;
        }
    };
    private int myCheckGuardedBlocks = 0;
    private boolean myGuardsSuppressed = false;
    private boolean myEventsHandling = false;
    private final boolean myAssertWriteAccess;
    private boolean myDoingBulkUpdate = false;
    private static final Key<WeakReference<EditorHighlighter>> ourSomeEditorSyntaxHighlighter = Key.create((String)"some editor highlighter");
    private boolean myAcceptSlashR = false;
    private final Object lock = new Object();

    private DocumentImpl() {
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertWriteAccess = true;
    }

    public DocumentImpl(String text) {
        this((CharSequence)text);
    }

    public DocumentImpl(boolean forUseInNonAWTThread) {
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertWriteAccess = !forUseInNonAWTThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    public DocumentImpl(CharSequence chars) {
        this();
        this.assertValidSeparators(chars);
        this.myText.setText(chars);
        DocumentEventImpl event = new DocumentEventImpl(this, 0, null, null, -1L, true);
        this.myLineSet.documentCreated(event);
    }

    public char[] getRawChars() {
        return this.myText.getChars();
    }

    @NotNull
    public char[] getChars() {
        char[] cArray = CharArrayUtil.fromSequence((CharSequence)this.getCharsSequence());
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getChars must not return null");
        }
        return cArray;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        MarkupModel markupModel = this.getMarkupModel(null);
        if (markupModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getMarkupModel must not return null");
        }
        return markupModel;
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.isStripTrailingSpacesEnabled = isEnabled;
    }

    @Override
    public void stripTrailingSpaces(boolean inChangedLinesOnly) {
        int i;
        Editor[] editors = EditorFactory.getInstance().getEditors((Document)this, null);
        VisualPosition[] visualCarets = new VisualPosition[editors.length];
        int[] caretLines = new int[editors.length];
        for (int i2 = 0; i2 < editors.length; ++i2) {
            visualCarets[i2] = editors[i2].getCaretModel().getVisualPosition();
            caretLines[i2] = editors[i2].getCaretModel().getLogicalPosition().line;
        }
        if (!this.isStripTrailingSpacesEnabled) {
            return;
        }
        boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
        block1: for (i = 0; i < this.myLineSet.getLineCount(); ++i) {
            char c;
            if (!isTestMode) {
                for (int caretLine : caretLines) {
                    if (caretLine == i) continue block1;
                }
            }
            if (inChangedLinesOnly && !this.myLineSet.isModified(i)) continue;
            int start = -1;
            int lineEnd = this.myLineSet.getLineEnd(i) - this.myLineSet.getSeparatorLength(i);
            int lineStart = this.myLineSet.getLineStart(i);
            CharSequence text = this.myText.getCharArray();
            int offset = lineEnd - 1;
            while (offset >= lineStart && ((c = text.charAt(offset)) == ' ' || c == '\t')) {
                start = offset--;
            }
            if (start == -1) continue;
            this.deleteString(start, lineEnd);
        }
        if (!ShutDownTracker.isShutdownHookRunning()) {
            for (i = 0; i < editors.length; ++i) {
                editors[i].getCaretModel().moveToVisualPosition(visualCarets[i]);
            }
        }
    }

    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    public ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler() {
        return this.myReadonlyFragmentModificationHandler;
    }

    public void setReadonlyFragmentModificationHandler(ReadonlyFragmentModificationHandler readonlyFragmentModificationHandler) {
        this.myReadonlyFragmentModificationHandler = readonlyFragmentModificationHandler;
    }

    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removeRangeMarker must not be null");
        }
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        WeakHashMap<RangeMarkerEx, String> weakHashMap = this.myRangeMarkers;
        synchronized (weakHashMap) {
            this.myRangeMarkers.remove(rangeMarker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addRangeMarker must not be null");
        }
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        WeakHashMap<RangeMarkerEx, String> weakHashMap = this.myRangeMarkers;
        synchronized (weakHashMap) {
            this.myRangeMarkers.put(rangeMarker, null);
        }
    }

    public Collection<RangeMarkerEx> getRangeMarkers() {
        return this.myRangeMarkers.keySet();
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        LOG.assertTrue(startOffset <= endOffset, (Object)"Should be startOffset <= endOffset");
        RangeMarker block = this.createRangeMarker(startOffset, endOffset, true);
        this.myGuardedBlocks.add(block);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createGuardedBlock must not return null");
        }
        return rangeMarker;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removeGuardedBlock must not be null");
        }
        this.myGuardedBlocks.remove(block);
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = this.myGuardedBlocks;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getGuardedBlocks must not return null");
        }
        return list;
    }

    public RangeMarker getOffsetGuard(int offset) {
        for (int i = 0; i < this.myGuardedBlocks.size(); ++i) {
            RangeMarker block = this.myGuardedBlocks.get(i);
            if (!DocumentImpl.offsetInRange(offset, block.getStartOffset(), block.getEndOffset())) continue;
            return block;
        }
        return null;
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangeIntersect(new int[]{start, block.getStartOffset()}, new int[]{end, block.getEndOffset()}, new boolean[]{true, block.isGreedyToLeft()}, new boolean[]{true, block.isGreedyToRight()})) continue;
            return block;
        }
        return null;
    }

    public void startGuardedBlockChecking() {
        ++this.myCheckGuardedBlocks;
    }

    public void stopGuardedBlockChecking() {
        LOG.assertTrue(this.myCheckGuardedBlocks > 0, (Object)"Unpaired start/stopGuardedBlockChecking");
        --this.myCheckGuardedBlocks;
    }

    private static boolean offsetInRange(int offset, int start, int end) {
        return start <= offset && offset < end;
    }

    private static boolean rangeIntersect(int[] start, int[] end, boolean[] leftInclusive, boolean[] rightInclusive) {
        if (start[0] > start[1] || start[0] == start[1] && !leftInclusive[0]) {
            ArrayUtil.swap((int[])start, (int)0, (int)1);
            ArrayUtil.swap((int[])end, (int)0, (int)1);
            ArrayUtil.swap((boolean[])leftInclusive, (int)0, (int)1);
            ArrayUtil.swap((boolean[])rightInclusive, (int)0, (int)1);
        }
        if (end[0] < start[1]) {
            return false;
        }
        if (end[0] > start[1]) {
            return true;
        }
        return leftInclusive[1] && rightInclusive[0];
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        RangeMarkerImpl rangeMarkerImpl = new RangeMarkerImpl(this, startOffset, endOffset);
        if (rangeMarkerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createRangeMarker must not return null");
        }
        return rangeMarkerImpl;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        if (0 > startOffset || startOffset > endOffset || endOffset > this.getTextLength()) {
            LOG.error("Incorrect offsets startOffset=" + startOffset + ", endOffset=" + endOffset + ", text length=" + this.getTextLength());
        }
        RangeMarkerImpl rangeMarkerImpl = surviveOnExternalChange ? new PersistentRangeMarker(this, startOffset, endOffset) : new RangeMarkerImpl(this, startOffset, endOffset);
        if (rangeMarkerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createRangeMarker must not return null");
        }
        return rangeMarkerImpl;
    }

    public long getModificationStamp() {
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.replaceText must not be null");
        }
        this.replaceString(0, this.getTextLength(), chars, newModificationStamp, true);
        this.clearLineModificationFlags();
    }

    @Override
    public int getListenersCount() {
        return this.myDocumentListeners.size();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.insertString must not be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset);
        }
        if (offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + "; documentLength: " + this.getTextLength() + "; " + s.subSequence(Math.max(0, this.getTextLength() - 20), this.getTextLength()));
        }
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        if (s.length() == 0) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(offset, offset);
        if (marker != null) {
            this.throwGuardedFragment(marker, offset, null, ((Object)s).toString());
        }
        this.myText.insert(s, offset);
    }

    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        if (startOffset == endOffset) {
            return;
        }
        CharSequence sToDelete = this.myText.substring(startOffset, endOffset);
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, ((Object)sToDelete).toString(), null);
        }
        this.myText.remove(startOffset, endOffset, sToDelete);
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.replaceString must not be null");
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), startOffset == 0 && endOffset == this.getTextLength());
    }

    private void replaceString(int startOffset, int endOffset, CharSequence s, long newModificationStamp, boolean wholeTextReplaced) {
        int newStartInString;
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException((Document)this);
        }
        int newStringLength = s.length();
        CharSequence chars = this.getCharsSequence();
        int newEndInString = newStringLength;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        while (endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1)) {
            --newEndInString;
            --endOffset;
        }
        s = s.subSequence(newStartInString, newEndInString);
        CharSequence sToDelete = this.myText.substring(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, ((Object)sToDelete).toString(), ((Object)s).toString());
        }
        this.myText.replace(startOffset, endOffset, sToDelete, s, newModificationStamp, wholeTextReplaced);
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertWriteAccess && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
        }
    }

    private void assertValidSeparators(CharSequence s) {
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators((CharSequence)s);
    }

    private void throwGuardedFragment(RangeMarker guard, int offset, String oldString, String newString) {
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException((DocumentEvent)event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    @Override
    public void clearLineModificationFlags() {
        this.myLineSet.clearModificationFlags();
    }

    private DocumentEvent beforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
        if (ShutDownTracker.isShutdownHookRunning()) {
            return null;
        }
        DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, wholeTextReplaced);
        DocumentListener[] listeners = this.getCachedListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            try {
                listeners[i].beforeDocumentChange((DocumentEvent)event);
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myEventsHandling = true;
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changedUpdate(DocumentEvent event, long newModificationStamp) {
        if (ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        try {
            DocumentListener[] listeners;
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            this.myLineSet.changedUpdate(event);
            this.setModificationStamp(newModificationStamp);
            this.updateRangeMarkers(event);
            for (DocumentListener listener : listeners = this.getCachedListeners()) {
                try {
                    listener.documentChanged(event);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRangeMarkers(DocumentEvent event) {
        WeakHashMap<RangeMarkerEx, String> weakHashMap = this.myRangeMarkers;
        synchronized (weakHashMap) {
            Iterator<RangeMarkerEx> rangeMarkerIterator = this.myRangeMarkers.keySet().iterator();
            while (rangeMarkerIterator.hasNext()) {
                try {
                    RangeMarkerEx rangeMarker = rangeMarkerIterator.next();
                    if (rangeMarker != null && rangeMarker.isValid()) {
                        if (event.getOffset() > rangeMarker.getEndOffset()) continue;
                        rangeMarker.documentChanged(event);
                        if (rangeMarker.isValid()) continue;
                        rangeMarkerIterator.remove();
                        if (!this.myGuardedBlocks.remove(rangeMarker)) continue;
                        LOG.error("Guarded blocks should stay valid: " + rangeMarker);
                        continue;
                    }
                    rangeMarkerIterator.remove();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public String getText() {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        return this.myText.toString();
    }

    public int getTextLength() {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        return this.myText.length();
    }

    private static void assertReadAccessToDocumentsAllowed() {
    }

    CharSequence getCharsNoThreadCheck() {
        return this.myText.getCharArray();
    }

    @NotNull
    public CharSequence getCharsSequence() {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        CharSequence charSequence = this.myText.getCharArray();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getCharsSequence must not return null");
        }
        return charSequence;
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addDocumentListener must not be null");
        }
        this.myCachedDocumentListeners = null;
        LOG.assertTrue(!this.myDocumentListeners.contains(listener), (Object)listener);
        this.myDocumentListeners.add(listener);
    }

    public void addDocumentListener(final @NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addDocumentListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addDocumentListener must not be null");
        }
        this.addDocumentListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DocumentImpl.this.removeDocumentListener(listener);
            }
        });
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removeDocumentListener must not be null");
        }
        this.myCachedDocumentListeners = null;
        boolean success = this.myDocumentListeners.remove(listener);
        LOG.assertTrue(success);
    }

    public int getLineNumber(int offset) {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        int lineIndex = this.myLineSet.findLineIndex(offset);
        assert (lineIndex >= 0);
        return lineIndex;
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        LineIterator lineIterator = this.myLineSet.createIterator();
        if (lineIterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createLineIterator must not return null");
        }
        return lineIterator;
    }

    public final int getLineStartOffset(int line) {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        if (line == 0) {
            return 0;
        }
        int lineStart = this.myLineSet.getLineStart(line);
        assert (lineStart >= 0);
        return lineStart;
    }

    public final int getLineEndOffset(int line) {
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result = this.myLineSet.getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result >= 0);
        return result;
    }

    public final int getLineSeparatorLength(int line) {
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        int separatorLength = this.myLineSet.getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    public final int getLineCount() {
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        int lineCount = this.myLineSet.getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    private DocumentListener[] getCachedListeners() {
        if (this.myCachedDocumentListeners == null) {
            Collections.sort(this.myDocumentListeners, ourListenersComparator);
            this.myCachedDocumentListeners = this.myDocumentListeners.toArray(new DocumentListener[this.myDocumentListeners.size()]);
        }
        return this.myCachedDocumentListeners;
    }

    public void fireReadOnlyModificationAttempt() {
        EditReadOnlyListener[] listeners;
        ApplicationManagerEx.getApplicationEx().assertReadAccessToDocumentsAllowed();
        for (EditReadOnlyListener listener : listeners = this.myReadOnlyListeners.toArray(new EditReadOnlyListener[this.myReadOnlyListeners.size()])) {
            listener.readOnlyModificationAttempt(this);
        }
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addEditReadOnlyListener must not be null");
        }
        this.myReadOnlyListeners.add(listener);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removeEditReadOnlyListener must not be null");
        }
        this.myReadOnlyListeners.remove(listener);
    }

    public void removeMarkupModel(Project project) {
        MarkupModel model = (MarkupModel)this.myProjectToMarkupModelMap.remove(project);
        if (model != null) {
            ((MarkupModelEx)model).dispose();
        }
    }

    @NotNull
    public MarkupModel getMarkupModel(Project project) {
        MarkupModel markupModel = this.getMarkupModel(project, true);
        if (markupModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getMarkupModel must not return null");
        }
        return markupModel;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addPropertyChangeListener must not be null");
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removePropertyChangeListener must not be null");
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkupModel getMarkupModel(@Nullable Project project, boolean create) {
        DocumentMarkupModelManager documentMarkupModelManager;
        if (project == null) {
            MarkupModelEx markupModel = this.myMarkupModel;
            if (create && markupModel == null) {
                Object object = this.lock;
                synchronized (object) {
                    markupModel = this.myMarkupModel;
                    if (markupModel == null) {
                        this.myMarkupModel = markupModel = new MarkupModelImpl(this);
                    }
                }
            }
            return markupModel;
        }
        DocumentMarkupModelManager documentMarkupModelManager2 = documentMarkupModelManager = project.isDisposed() ? null : DocumentMarkupModelManager.getInstance(project);
        if (documentMarkupModelManager == null || documentMarkupModelManager.isDisposed()) {
            return new EmptyMarkupModel(this);
        }
        MarkupModel model = (MarkupModel)this.myProjectToMarkupModelMap.get(project);
        if (create && model == null) {
            model = (MarkupModel)ConcurrencyUtil.cacheOrGet(this.myProjectToMarkupModelMap, (Object)project, (Object)new MarkupModelImpl(this));
            documentMarkupModelManager.registerDocument(this);
        }
        return model;
    }

    public void setCyclicBufferSize(int bufferSize) {
        this.myText.setBufferSize(bufferSize);
    }

    public void setText(final @NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.setText must not be null");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.replaceString(0, DocumentImpl.this.getTextLength(), text, LocalTimeCounter.currentTime(), true);
            }
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", (Object)DocCommandGroupId.noneGroupId((Document)this));
        }
        this.clearLineModificationFlags();
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.createRangeMarker must not be null");
        }
        RangeMarker rangeMarker = this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createRangeMarker must not return null");
        }
        return rangeMarker;
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    @Override
    public final void setInBulkUpdate(boolean value) {
        if (value) {
            this.myDoingBulkUpdate = true;
            DocumentImpl.getPublisher().updateStarted(this);
        } else {
            this.myDoingBulkUpdate = false;
            DocumentImpl.getPublisher().updateFinished(this);
        }
    }

    @Nullable
    public EditorHighlighter getEditorHighlighterForCachesBuilding() {
        EditorHighlighter someEditorHighlighter;
        WeakReference editorHighlighterWeakReference = (WeakReference)this.getUserData(ourSomeEditorSyntaxHighlighter);
        EditorHighlighter editorHighlighter = someEditorHighlighter = editorHighlighterWeakReference != null ? (EditorHighlighter)editorHighlighterWeakReference.get() : null;
        if (someEditorHighlighter instanceof LexerEditorHighlighter) {
            return someEditorHighlighter;
        }
        return null;
    }

    public void rememberEditorHighlighterForCachesOptimization(@NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.rememberEditorHighlighterForCachesOptimization must not be null");
        }
        this.putUserData(ourSomeEditorSyntaxHighlighter, new WeakReference<EditorHighlighter>(highlighter));
    }

    private static DocumentBulkUpdateListener getPublisher() {
        return DocumentBulkUpdateListenerHolder.ourBulkChangePublisher;
    }

    private static class DocumentBulkUpdateListenerHolder {
        private static final DocumentBulkUpdateListener ourBulkChangePublisher = (DocumentBulkUpdateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DocumentBulkUpdateListener.TOPIC);

        private DocumentBulkUpdateListenerHolder() {
        }
    }
}

